/*
 * Decompiled with CFR 0.152.
 */
package jaicore.search.algorithms.standard.bestfirst;

import ai.libs.jaicore.basic.ILoggingCustomizable;
import jaicore.search.algorithms.standard.bestfirst.BestFirst;
import jaicore.search.algorithms.standard.bestfirst.StandardBestFirst;
import jaicore.search.algorithms.standard.bestfirst.nodeevaluation.INodeEvaluator;
import jaicore.search.model.travesaltree.Node;
import jaicore.search.probleminputs.GraphSearchWithSubpathEvaluationsInput;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BestFirstEpsilon<T, A, W extends Comparable<W>>
extends StandardBestFirst<T, A, Double> {
    private Logger logger = LoggerFactory.getLogger(BestFirst.class);
    private String loggerName;
    private final INodeEvaluator<T, W> secondaryNodeEvaluator;
    private final Map<Node<T, Double>, W> secondaryCache = new HashMap<Node<T, Double>, W>();
    private final OpenList focalBasedOpenList = new OpenList();
    private final boolean absolute;
    private final double epsilon;

    public BestFirstEpsilon(GraphSearchWithSubpathEvaluationsInput<T, A, Double> problem, INodeEvaluator<T, W> pSecondaryNodeEvaluator, int epsilon) throws InterruptedException {
        this(problem, pSecondaryNodeEvaluator, epsilon, true);
    }

    public BestFirstEpsilon(GraphSearchWithSubpathEvaluationsInput<T, A, Double> problem, INodeEvaluator<T, W> pSecondaryNodeEvaluator, double epsilon, boolean absolute) throws InterruptedException {
        super(problem);
        this.secondaryNodeEvaluator = pSecondaryNodeEvaluator;
        this.epsilon = epsilon;
        this.absolute = absolute;
        this.setOpen(this.focalBasedOpenList);
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    @Override
    public void setLoggerName(String name) {
        this.logger.info("Switching logger from {} to {}", (Object)this.logger.getName(), (Object)name);
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Activated logger {} with name {}", (Object)name, (Object)this.logger.getName());
        if (this.secondaryNodeEvaluator instanceof ILoggingCustomizable) {
            ((ILoggingCustomizable)this.secondaryNodeEvaluator).setLoggerName(name + ".secnodeeval");
        }
        super.setLoggerName(this.loggerName + "._bestfirst");
    }

    private class OpenList
    extends PriorityQueue<Node<T, Double>> {
        private OpenList() {
        }

        @Override
        public Node<T, Double> peek() {
            if (BestFirstEpsilon.this.epsilon <= 0.0 || BestFirstEpsilon.this.open.isEmpty()) {
                return (Node)super.peek();
            }
            double best = (Double)((Node)super.peek()).getInternalLabel();
            double threshold = BestFirstEpsilon.this.absolute ? (best >= 0.0 ? best + BestFirstEpsilon.this.epsilon : best - BestFirstEpsilon.this.epsilon) : best * (best >= 0.0 ? 1.0 + BestFirstEpsilon.this.epsilon : 1.0 - BestFirstEpsilon.this.epsilon);
            Collection focal = super.stream().filter(n -> (Double)n.getInternalLabel() <= threshold).collect(Collectors.toList());
            focal.stream().filter(n -> !BestFirstEpsilon.this.secondaryCache.containsKey(n)).forEach((? super T n) -> {
                try {
                    BestFirstEpsilon.this.secondaryCache.put(n, BestFirstEpsilon.this.secondaryNodeEvaluator.f(n));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            });
            Node choice = (Node)focal.stream().min((p1, p2) -> ((Comparable)BestFirstEpsilon.this.secondaryCache.get(p1)).compareTo(BestFirstEpsilon.this.secondaryCache.get(p2))).get();
            BestFirstEpsilon.this.logger.info("Best score is {}. Threshold for focal is {}. Choose node with f1 {} and best f2 {}. Size of focal was {}.", new Object[]{best, threshold, choice.getInternalLabel(), BestFirstEpsilon.this.secondaryCache.get(choice), focal.size()});
            return choice;
        }
    }
}

