/*
 * Decompiled with CFR 0.152.
 */
package jaicore.search.algorithms.standard.bestfirst;

import ai.libs.jaicore.basic.ILoggingCustomizable;
import ai.libs.jaicore.logging.ToJSONStringUtil;
import jaicore.search.algorithms.standard.bestfirst.BestFirst;
import jaicore.search.algorithms.standard.bestfirst.BestFirstFactory;
import jaicore.search.algorithms.standard.bestfirst.nodeevaluation.AlternativeNodeEvaluator;
import jaicore.search.algorithms.standard.bestfirst.nodeevaluation.INodeEvaluator;
import jaicore.search.core.interfaces.GraphGenerator;
import jaicore.search.probleminputs.GraphSearchWithSubpathEvaluationsInput;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardBestFirstFactory<N, A, V extends Comparable<V>>
extends BestFirstFactory<GraphSearchWithSubpathEvaluationsInput<N, A, V>, N, A, V>
implements ILoggingCustomizable {
    private Logger logger = LoggerFactory.getLogger(StandardBestFirstFactory.class);
    private INodeEvaluator<N, V> preferredNodeEvaluator;

    public void setNodeEvaluator(INodeEvaluator<N, V> nodeEvaluator) {
        this.setProblemInput(new GraphSearchWithSubpathEvaluationsInput(this.getInput() != null ? ((GraphSearchWithSubpathEvaluationsInput)this.getInput()).getGraphGenerator() : null, nodeEvaluator));
    }

    public void setGraphGenerator(GraphGenerator<N, A> graphGenerator) {
        this.setProblemInput(new GraphSearchWithSubpathEvaluationsInput(graphGenerator, this.getInput() != null ? ((GraphSearchWithSubpathEvaluationsInput)this.getInput()).getNodeEvaluator() : null));
    }

    public INodeEvaluator<N, V> getPreferredNodeEvaluator() {
        return this.preferredNodeEvaluator;
    }

    public void setPreferredNodeEvaluator(INodeEvaluator<N, V> preferredNodeEvaluator) {
        this.preferredNodeEvaluator = preferredNodeEvaluator;
    }

    @Override
    public BestFirst<GraphSearchWithSubpathEvaluationsInput<N, A, V>, N, A, V> getAlgorithm() {
        if (((GraphSearchWithSubpathEvaluationsInput)this.getInput()).getGraphGenerator() == null) {
            throw new IllegalStateException("Cannot produce BestFirst searches before the graph generator is set in the problem.");
        }
        if (((GraphSearchWithSubpathEvaluationsInput)this.getInput()).getNodeEvaluator() == null) {
            throw new IllegalStateException("Cannot produce BestFirst searches before the node evaluator is set.");
        }
        GraphSearchWithSubpathEvaluationsInput problem = (GraphSearchWithSubpathEvaluationsInput)this.getInput();
        if (this.preferredNodeEvaluator != null) {
            problem = new GraphSearchWithSubpathEvaluationsInput(problem.getGraphGenerator(), new AlternativeNodeEvaluator<N, V>(this.preferredNodeEvaluator, problem.getNodeEvaluator()));
        }
        this.logger.debug("Created algorithm input with\n\tgraph generator: {}\n\tnode evaluator: {}", problem.getGraphGenerator(), problem.getNodeEvaluator());
        BestFirst search = new BestFirst(problem);
        search.setTimeoutForComputationOfF(this.getTimeoutForFInMS(), this.getTimeoutEvaluator());
        if (this.getLoggerName() != null && this.getLoggerName().length() > 0) {
            search.setLoggerName(this.getLoggerName());
        }
        return search;
    }

    public String toString() {
        HashMap<String, INodeEvaluator<N, V>> fields = new HashMap<String, INodeEvaluator<N, V>>();
        fields.put("preferredNodeEvaluator", this.preferredNodeEvaluator);
        return ToJSONStringUtil.toJSONString((String)this.getClass().getSimpleName(), fields);
    }

    @Override
    public String getLoggerName() {
        return this.logger.getName();
    }

    @Override
    public void setLoggerName(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
    }
}

