/*
 * Decompiled with CFR 0.152.
 */
package jaicore.search.algorithms.standard.bestfirst.nodeevaluation;

import ai.libs.jaicore.basic.ILoggingCustomizable;
import ai.libs.jaicore.logging.ToJSONStringUtil;
import jaicore.search.algorithms.standard.bestfirst.exceptions.NodeEvaluationException;
import jaicore.search.algorithms.standard.bestfirst.nodeevaluation.DecoratingNodeEvaluator;
import jaicore.search.algorithms.standard.bestfirst.nodeevaluation.INodeEvaluator;
import jaicore.search.algorithms.standard.bestfirst.nodeevaluation.IPotentiallyGraphDependentNodeEvaluator;
import jaicore.search.algorithms.standard.bestfirst.nodeevaluation.IPotentiallySolutionReportingNodeEvaluator;
import jaicore.search.core.interfaces.GraphGenerator;
import jaicore.search.model.travesaltree.Node;
import java.util.HashMap;

public class AlternativeNodeEvaluator<T, V extends Comparable<V>>
extends DecoratingNodeEvaluator<T, V>
implements ILoggingCustomizable {
    private String loggerName;
    private final INodeEvaluator<T, V> ne1;

    public AlternativeNodeEvaluator(INodeEvaluator<T, V> ne1, INodeEvaluator<T, V> ne2) {
        super(ne2);
        if (ne1 == null) {
            throw new IllegalArgumentException("The alternativ evaluator in node evaluator must not be null!");
        }
        this.ne1 = ne1;
    }

    @Override
    public boolean requiresGraphGenerator() {
        if (super.requiresGraphGenerator()) {
            return true;
        }
        return this.ne1 instanceof IPotentiallyGraphDependentNodeEvaluator && ((IPotentiallyGraphDependentNodeEvaluator)this.ne1).requiresGraphGenerator();
    }

    public boolean doesPrimaryNodeEvaluatorReportSolutions() {
        return this.ne1 instanceof IPotentiallySolutionReportingNodeEvaluator && ((IPotentiallySolutionReportingNodeEvaluator)this.ne1).reportsSolutions();
    }

    @Override
    public boolean reportsSolutions() {
        if (super.reportsSolutions()) {
            return true;
        }
        return this.doesDecoratedEvaluatorReportSolutions();
    }

    @Override
    public void setGenerator(GraphGenerator<T, ?> generator) {
        super.setGenerator(generator);
        if (!(this.ne1 instanceof IPotentiallyGraphDependentNodeEvaluator)) {
            return;
        }
        IPotentiallyGraphDependentNodeEvaluator castedNE1 = (IPotentiallyGraphDependentNodeEvaluator)this.ne1;
        if (castedNE1.requiresGraphGenerator()) {
            castedNE1.setGenerator(generator);
        }
    }

    @Override
    public void registerSolutionListener(Object listener) {
        if (super.doesDecoratedEvaluatorReportSolutions()) {
            super.registerSolutionListener(listener);
        }
        if (this.doesPrimaryNodeEvaluatorReportSolutions()) {
            ((IPotentiallySolutionReportingNodeEvaluator)this.ne1).registerSolutionListener(listener);
        }
    }

    @Override
    public V f(Node<T, ?> node) throws NodeEvaluationException, InterruptedException {
        V f1 = this.ne1.f(node);
        if (f1 != null) {
            return f1;
        }
        return super.f(node);
    }

    public String toString() {
        HashMap fields = new HashMap();
        fields.put("primary", this.ne1);
        fields.put("secondary", super.getEvaluator());
        return ToJSONStringUtil.toJSONString((String)this.getClass().getSimpleName(), fields);
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    @Override
    public void setLoggerName(String name) {
        this.loggerName = name;
        super.setLoggerName(name + "._decorating");
        if (this.ne1 instanceof ILoggingCustomizable) {
            ((ILoggingCustomizable)this.ne1).setLoggerName(name + ".primary");
        }
        if (this.getEvaluator() instanceof ILoggingCustomizable) {
            ((ILoggingCustomizable)this.getEvaluator()).setLoggerName(name + ".secondary");
        }
    }
}

