/*
 * Decompiled with CFR 0.152.
 */
package jaicore.search.algorithms.standard.bestfirst.nodeevaluation;

import ai.libs.jaicore.basic.ILoggingCustomizable;
import jaicore.search.algorithms.standard.bestfirst.exceptions.NodeEvaluationException;
import jaicore.search.algorithms.standard.bestfirst.nodeevaluation.ICancelableNodeEvaluator;
import jaicore.search.algorithms.standard.bestfirst.nodeevaluation.INodeEvaluator;
import jaicore.search.algorithms.standard.bestfirst.nodeevaluation.IPotentiallyGraphDependentNodeEvaluator;
import jaicore.search.algorithms.standard.bestfirst.nodeevaluation.IPotentiallySolutionReportingNodeEvaluator;
import jaicore.search.core.interfaces.GraphGenerator;
import jaicore.search.model.travesaltree.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DecoratingNodeEvaluator<T, V extends Comparable<V>>
implements INodeEvaluator<T, V>,
ICancelableNodeEvaluator,
ILoggingCustomizable,
IPotentiallyGraphDependentNodeEvaluator<T, V>,
IPotentiallySolutionReportingNodeEvaluator<T, V> {
    private boolean canceled = false;
    private Logger logger = LoggerFactory.getLogger(DecoratingNodeEvaluator.class);
    private final INodeEvaluator<T, V> decoratedEvaluator;

    public DecoratingNodeEvaluator(INodeEvaluator<T, V> evaluator) {
        if (evaluator == null) {
            throw new IllegalArgumentException("The decorated evaluator must not be null!");
        }
        this.decoratedEvaluator = evaluator;
    }

    public INodeEvaluator<T, V> getEvaluator() {
        return this.decoratedEvaluator;
    }

    @Override
    public V f(Node<T, ?> node) throws NodeEvaluationException, InterruptedException {
        return this.decoratedEvaluator.f(node);
    }

    public boolean isDecoratedEvaluatorCancelable() {
        return this.decoratedEvaluator instanceof ICancelableNodeEvaluator;
    }

    public boolean isDecoratedEvaluatorGraphDependent() {
        return this.decoratedEvaluator instanceof IPotentiallyGraphDependentNodeEvaluator && ((IPotentiallyGraphDependentNodeEvaluator)this.decoratedEvaluator).requiresGraphGenerator();
    }

    public boolean doesDecoratedEvaluatorReportSolutions() {
        return this.decoratedEvaluator instanceof IPotentiallySolutionReportingNodeEvaluator && ((IPotentiallySolutionReportingNodeEvaluator)this.decoratedEvaluator).reportsSolutions();
    }

    @Override
    public boolean requiresGraphGenerator() {
        return this.isDecoratedEvaluatorGraphDependent();
    }

    @Override
    public boolean reportsSolutions() {
        return this.doesDecoratedEvaluatorReportSolutions();
    }

    @Override
    public void setGenerator(GraphGenerator<T, ?> generator) {
        this.logger.info("Setting graph generator of {} to {}", (Object)this, generator);
        if (!this.requiresGraphGenerator()) {
            throw new UnsupportedOperationException("This node evaluator is not graph dependent");
        }
        if (!this.isDecoratedEvaluatorGraphDependent()) {
            return;
        }
        ((IPotentiallyGraphDependentNodeEvaluator)this.decoratedEvaluator).setGenerator(generator);
    }

    @Override
    public void registerSolutionListener(Object listener) {
        if (!this.doesDecoratedEvaluatorReportSolutions()) {
            throw new UnsupportedOperationException(this.getClass().getName() + " is not a solution reporting node evaluator");
        }
        ((IPotentiallySolutionReportingNodeEvaluator)this.decoratedEvaluator).registerSolutionListener(listener);
    }

    @Override
    public void cancelActiveTasks() {
        if (this.canceled) {
            return;
        }
        this.canceled = true;
        if (this.isDecoratedEvaluatorCancelable()) {
            ((ICancelableNodeEvaluator)((Object)this.decoratedEvaluator)).cancelActiveTasks();
        }
        if (this instanceof ICancelableNodeEvaluator) {
            this.cancelActiveTasks();
        }
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public void setLoggerName(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
    }
}

