/*
 * Decompiled with CFR 0.152.
 */
package jaicore.search.algorithms.standard.bestfirst.nodeevaluation;

import jaicore.search.algorithms.standard.bestfirst.exceptions.NodeEvaluationException;
import jaicore.search.algorithms.standard.bestfirst.nodeevaluation.INodeEvaluator;
import jaicore.search.model.travesaltree.Node;
import java.util.Map;

public class LinearCombiningNodeEvaluator<T>
implements INodeEvaluator<T, Double> {
    private final Map<INodeEvaluator<T, Double>, Double> evaluators;

    public LinearCombiningNodeEvaluator(Map<INodeEvaluator<T, Double>, Double> evaluators) {
        this.evaluators = evaluators;
    }

    @Override
    public Double f(Node<T, ?> node) throws NodeEvaluationException, InterruptedException {
        double score = 0.0;
        for (INodeEvaluator<T, Double> evaluator : this.evaluators.keySet()) {
            if (this.evaluators.get(evaluator) == 0.0) continue;
            double incr = evaluator.f(node);
            if (incr == 2.147483647E9) {
                score = 2.147483647E9;
                break;
            }
            score += incr * this.evaluators.get(evaluator);
        }
        return score;
    }
}

