/*
 * Decompiled with CFR 0.152.
 */
package jaicore.search.algorithms.standard.bestfirst.nodeevaluation;

import ai.libs.jaicore.basic.ILoggingCustomizable;
import ai.libs.jaicore.basic.IObjectEvaluator;
import ai.libs.jaicore.basic.TimeOut;
import ai.libs.jaicore.basic.algorithm.AlgorithmExecutionCanceledException;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmInitializedEvent;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.logging.LoggerUtil;
import ai.libs.jaicore.logging.ToJSONStringUtil;
import ai.libs.jaicore.timing.TimedComputation;
import com.google.common.eventbus.Subscribe;
import jaicore.search.algorithms.standard.bestfirst.events.EvaluatedSearchSolutionCandidateFoundEvent;
import jaicore.search.algorithms.standard.bestfirst.events.NodeAnnotationEvent;
import jaicore.search.algorithms.standard.bestfirst.events.NodeExpansionCompletedEvent;
import jaicore.search.algorithms.standard.bestfirst.events.RolloutEvent;
import jaicore.search.algorithms.standard.bestfirst.exceptions.NodeEvaluationException;
import jaicore.search.algorithms.standard.bestfirst.nodeevaluation.ICancelableNodeEvaluator;
import jaicore.search.algorithms.standard.bestfirst.nodeevaluation.IPotentiallyGraphDependentNodeEvaluator;
import jaicore.search.algorithms.standard.bestfirst.nodeevaluation.IPotentiallySolutionReportingNodeEvaluator;
import jaicore.search.algorithms.standard.bestfirst.nodeevaluation.IPotentiallyUncertaintyAnnotatingNodeEvaluator;
import jaicore.search.algorithms.standard.bestfirst.nodeevaluation.RandomizedDepthFirstNodeEvaluator;
import jaicore.search.algorithms.standard.bestfirst.nodeevaluation.TimeAwareNodeEvaluator;
import jaicore.search.algorithms.standard.gbf.SolutionEventBus;
import jaicore.search.algorithms.standard.random.RandomSearch;
import jaicore.search.algorithms.standard.uncertainty.IUncertaintySource;
import jaicore.search.core.interfaces.GraphGenerator;
import jaicore.search.model.other.EvaluatedSearchGraphPath;
import jaicore.search.model.other.SearchGraphPath;
import jaicore.search.model.travesaltree.Node;
import jaicore.search.probleminputs.GraphSearchWithSubpathEvaluationsInput;
import jaicore.search.structure.graphgenerator.NodeGoalTester;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomCompletionBasedNodeEvaluator<T, A, V extends Comparable<V>>
extends TimeAwareNodeEvaluator<T, V>
implements IPotentiallyGraphDependentNodeEvaluator<T, V>,
IPotentiallySolutionReportingNodeEvaluator<T, V>,
ICancelableNodeEvaluator,
IPotentiallyUncertaintyAnnotatingNodeEvaluator<T, V>,
ILoggingCustomizable {
    private static final String ALGORITHM_ID = "RandomCompletion";
    private static final boolean LOG_FAILURES_AS_ERRORS = false;
    private String loggerName;
    private Logger logger = LoggerFactory.getLogger(RandomCompletionBasedNodeEvaluator.class);
    private final int timeoutForSingleCompletionEvaluationInMS;
    protected Set<List<T>> unsuccessfulPaths = Collections.synchronizedSet(new HashSet());
    protected Set<List<T>> postedSolutions = new HashSet<List<T>>();
    protected Map<List<T>, Integer> timesToComputeEvaluations = new HashMap<List<T>, Integer>();
    protected Map<List<T>, V> scoresOfSolutionPaths = new ConcurrentHashMap<List<T>, V>();
    protected Map<Node<T, ?>, V> fValues = new ConcurrentHashMap();
    protected Map<String, Integer> ppFails = new ConcurrentHashMap<String, Integer>();
    protected Map<String, Integer> plFails = new ConcurrentHashMap<String, Integer>();
    protected Map<String, Integer> plSuccesses = new ConcurrentHashMap<String, Integer>();
    protected GraphGenerator<T, ?> generator;
    protected long timestampOfFirstEvaluation;
    protected final Random random;
    protected int samples;
    private final Predicate<T> priorityPredicateForRDFS;
    private RandomSearch<T, ?> completer;
    private final Semaphore completerInsertionSemaphore = new Semaphore(0);
    protected final IObjectEvaluator<SearchGraphPath<T, A>, V> solutionEvaluator;
    protected IUncertaintySource<T, V> uncertaintySource;
    protected SolutionEventBus<T> eventBus = new SolutionEventBus();
    private final Map<List<T>, V> bestKnownScoreUnderNodeInCompleterGraph = new HashMap<List<T>, V>();
    private boolean visualizeSubSearch;

    public RandomCompletionBasedNodeEvaluator(Random random, int samples, IObjectEvaluator<SearchGraphPath<T, A>, V> solutionEvaluator) {
        this(random, samples, solutionEvaluator, -1, -1);
    }

    public RandomCompletionBasedNodeEvaluator(Random random, int samples, IObjectEvaluator<SearchGraphPath<T, A>, V> solutionEvaluator, int timeoutForSingleCompletionEvaluationInMS, int timeoutForNodeEvaluationInMS) {
        this(random, samples, solutionEvaluator, timeoutForSingleCompletionEvaluationInMS, timeoutForNodeEvaluationInMS, null);
    }

    public RandomCompletionBasedNodeEvaluator(Random random, int samples, IObjectEvaluator<SearchGraphPath<T, A>, V> solutionEvaluator, int timeoutForSingleCompletionEvaluationInMS, int timeoutForNodeEvaluationInMS, Predicate<T> priorityPredicateForRDFS) {
        super(timeoutForNodeEvaluationInMS);
        if (random == null) {
            throw new IllegalArgumentException("Random source must not be null!");
        }
        if (samples <= 0) {
            throw new IllegalArgumentException("Sample size must be greater than 0!");
        }
        if (solutionEvaluator == null) {
            throw new IllegalArgumentException("Solution evaluator must not be null!");
        }
        this.random = random;
        this.samples = samples;
        this.solutionEvaluator = solutionEvaluator;
        this.timeoutForSingleCompletionEvaluationInMS = timeoutForSingleCompletionEvaluationInMS;
        this.priorityPredicateForRDFS = priorityPredicateForRDFS;
        this.logger.info("Initialized RandomCompletionEvaluator with timeout {}ms for single evaluations and {}ms in total per node", (Object)timeoutForSingleCompletionEvaluationInMS, (Object)timeoutForNodeEvaluationInMS);
        assert (this.logAssertionActivation());
    }

    private boolean logAssertionActivation() {
        StringBuilder sb = new StringBuilder();
        sb.append("Assertion remark:\n--------------------------------------------------------\n");
        sb.append("Assertions are activated.\n");
        sb.append("This may cause significant performance loss using ");
        sb.append(RandomCompletionBasedNodeEvaluator.class.getName());
        sb.append(".\nIf you are not in debugging mode, we strongly suggest to disable assertions.\n");
        sb.append("--------------------------------------------------------");
        this.logger.info("{}", (Object)sb);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected V fTimeouted(Node<T, ?> n, int timeout) throws InterruptedException, NodeEvaluationException {
        long deadline;
        assert (this.generator != null) : "Cannot compute f as no generator has been set!";
        this.eventBus.post(new NodeAnnotationEvent<T>(ALGORITHM_ID, n.getPoint(), "f-computing thread", Thread.currentThread().getName()));
        this.logger.info("Received request for f-value of node with hashCode {}. Number of subsamples will be {}, timeout for node evaluation is {}ms and for a single candidate is {}ms. Enable DEBUG for node details.", new Object[]{n.hashCode(), this.samples, this.getTimeoutForNodeEvaluationInMS(), this.timeoutForSingleCompletionEvaluationInMS});
        this.logger.debug("Node details: {}", n);
        long startOfComputation = System.currentTimeMillis();
        long l = deadline = timeout > 0 ? startOfComputation + (long)timeout : -1L;
        if (this.timestampOfFirstEvaluation == 0L) {
            this.timestampOfFirstEvaluation = startOfComputation;
        }
        if (!this.fValues.containsKey(n)) {
            if (this.generator == null) {
                throw new IllegalStateException("Cannot compute f-values before the generator is set!");
            }
            List<T> path = n.externalPath();
            if (this.eventBus == null) {
                this.eventBus = new SolutionEventBus();
            }
            double uncertainty = 0.0;
            if (!n.isGoal()) {
                if (n.getParent() != null && this.completer.getExploredGraph().hasItem(n.getParent().getPoint())) {
                    boolean nodeHasSibling;
                    boolean parentHasFValue = this.fValues.containsKey(n.getParent());
                    assert (parentHasFValue || n.getParent().getParent() == null) : "No f-value has been stored for the parent of node with hash code " + n.hashCode() + " (hash code of parent is " + n.getParent().hashCode() + ") whose f-value we may want to reuse.\nThis is only allowed for top-level nodes, but the actual path is: " + n.path().stream().map(k -> "\n\t" + k.hashCode() + "\t(f-value: " + k.getInternalLabel() + ")").collect(Collectors.joining());
                    boolean bl = nodeHasSibling = this.completer.getExploredGraph().getSuccessors(n.getParent().getPoint()).size() > 1;
                    if (path.size() > 1 && !nodeHasSibling && parentHasFValue) {
                        Comparable score = (Comparable)this.fValues.get(n.getParent());
                        this.fValues.put(n, score);
                        this.logger.debug("Score {} of parent is used since the last action did not affect the performance.", (Object)score);
                        if (score == null) {
                            this.logger.warn("Returning score NULL inherited from parent, this should not happen.");
                        }
                        return (V)score;
                    }
                }
                if (!this.completer.knowsNode(n.getPoint())) {
                    RandomSearch<T, ?> parentHasFValue = this.completer;
                    synchronized (parentHasFValue) {
                        this.completer.appendPathToNode(n.externalPath());
                    }
                    for (Node<T, ?> current = n.getParent(); current != null && !this.fValues.containsKey(current); current = current.getParent()) {
                        this.fValues.put(current, current.getInternalLabel());
                        this.logger.debug("Filling up the f-value of {} with {}", (Object)current.hashCode(), current.getInternalLabel());
                    }
                }
                AtomicInteger drawnSamples = new AtomicInteger();
                AtomicInteger successfulSamples = new AtomicInteger();
                int countedExceptions = 0;
                int maxSamples = this.samples * 2;
                ArrayList evaluations = new ArrayList();
                ArrayList completedPaths = new ArrayList();
                this.logger.debug("Now drawing {} successful examples but no more than {}", (Object)this.samples, (Object)maxSamples);
                while (successfulSamples.get() < this.samples) {
                    long remainingTimeForNodeEvaluation;
                    this.logger.debug("Drawing next sample. {} samples have been drawn already, {} have been successful.", (Object)drawnSamples, (Object)successfulSamples);
                    this.checkInterruption();
                    if (deadline > 0L && deadline < System.currentTimeMillis()) {
                        this.logger.info("Deadline for random completions hit! Finishing node evaluation.");
                        break;
                    }
                    long l2 = remainingTimeForNodeEvaluation = deadline > 0L ? deadline - System.currentTimeMillis() : -1L;
                    long timeoutForJob = remainingTimeForNodeEvaluation >= 0L && this.timeoutForSingleCompletionEvaluationInMS >= 0 ? Math.min(remainingTimeForNodeEvaluation, (long)this.timeoutForSingleCompletionEvaluationInMS) : (remainingTimeForNodeEvaluation >= 0L ? remainingTimeForNodeEvaluation : (this.timeoutForSingleCompletionEvaluationInMS >= 0 ? (long)this.timeoutForSingleCompletionEvaluationInMS : -1L));
                    ArrayList<T> pathCompletion = null;
                    ArrayList<T> completedPath = new ArrayList<T>(n.externalPath());
                    RandomSearch<T, ?> randomSearch = this.completer;
                    synchronized (randomSearch) {
                        long startCompletion = System.currentTimeMillis();
                        if (this.completer.isCanceled()) {
                            this.logger.info("Completer has been canceled (perhaps due a cancel on the evaluator). Canceling sampling.");
                            break;
                        }
                        this.logger.debug("Starting search for next solution ...");
                        SearchGraphPath<T, ?> solutionPathFromN = null;
                        try {
                            solutionPathFromN = this.completer.nextSolutionUnderNode(n.getPoint());
                        }
                        catch (AlgorithmExecutionCanceledException | TimeoutException e) {
                            this.logger.info("Completer has been canceled or timeouted. Returning control.");
                            break;
                        }
                        if (solutionPathFromN == null) {
                            this.logger.info("No completion was found for path {}.", path);
                            break;
                        }
                        long finishedCompletion = System.currentTimeMillis();
                        this.logger.debug("Found solution of length {} in {}ms. Enable TRACE for details.", (Object)solutionPathFromN.getNodes().size(), (Object)(finishedCompletion - startCompletion));
                        this.logger.trace("Solution path is {}", solutionPathFromN);
                        pathCompletion = new ArrayList<T>(solutionPathFromN.getNodes());
                        pathCompletion.remove(0);
                        completedPath.addAll(pathCompletion);
                    }
                    completedPaths.add(completedPath);
                    try {
                        TimedComputation.compute(() -> {
                            drawnSamples.incrementAndGet();
                            V val = this.getFValueOfSolutionPath(completedPath);
                            this.logger.debug("Completed path evaluation. Score is {}", val);
                            successfulSamples.incrementAndGet();
                            this.eventBus.post((Object)new RolloutEvent(ALGORITHM_ID, n.path(), val));
                            if (val != null) {
                                evaluations.add(val);
                                this.updateMapOfBestScoreFoundSoFar(completedPath, val);
                            } else {
                                this.logger.warn("Got NULL result as score for path {}", (Object)completedPath);
                            }
                            return true;
                        }, (long)timeoutForJob, (String)"RCNE-timeout");
                    }
                    catch (InterruptedException e) {
                        this.logger.debug("Path evaluation has been interrupted.");
                        throw e;
                    }
                    catch (Exception ex) {
                        if (countedExceptions == maxSamples) {
                            this.logger.warn("Too many retry attempts, giving up. {} samples were drawn, {} were successful.", (Object)drawnSamples, (Object)successfulSamples);
                            throw new NodeEvaluationException(ex, "Error in the evaluation of a node!");
                        }
                        ++countedExceptions;
                        this.logger.debug("Could not evaluate solution candidate ... retry another completion. {}", (Object)LoggerUtil.getExceptionInfo((Throwable)ex));
                    }
                    finally {
                        this.logger.debug("Finished process for sample {}.", (Object)drawnSamples);
                    }
                }
                Comparable best = (Comparable)this.bestKnownScoreUnderNodeInCompleterGraph.get(n.externalPath());
                this.logger.debug("Finished sampling. {} samples were drawn, {} were successful. Best seen score is {}", new Object[]{drawnSamples, successfulSamples, best});
                if (best == null) {
                    this.checkInterruption();
                    if (countedExceptions > 0) {
                        throw new NoSuchElementException("Among " + drawnSamples + " evaluated candidates, we could not identify any candidate that did not throw an exception.");
                    }
                    return null;
                }
                this.logger.debug("Checking interruption.");
                this.checkInterruption();
                this.logger.debug("Not interrupted.");
                n.setAnnotation("fRPSamples", successfulSamples);
                if (this.uncertaintySource != null) {
                    uncertainty = this.uncertaintySource.calculateUncertainty(n, completedPaths, evaluations);
                    this.logger.debug("Setting uncertainty to {}", (Object)uncertainty);
                } else {
                    this.logger.debug("Not setting uncertainty, because no uncertainty source has been defined.");
                }
                this.fValues.put(n, best);
            } else {
                V score = this.getFValueOfSolutionPath(path);
                if (score == null) {
                    this.logger.warn("No score was computed");
                    return null;
                }
                this.fValues.put(n, score);
                if (!this.postedSolutions.contains(path)) {
                    this.logger.error("Found a goal node whose solution has not been posted before!");
                }
                uncertainty = 0.0;
            }
            if (this.uncertaintySource != null) {
                n.setAnnotation("uncertainty", uncertainty);
            }
        }
        assert (this.fValues.containsKey(n));
        Comparable f = (Comparable)this.fValues.get(n);
        this.logger.info("Returning f-value: {}. Annotated uncertainty is {}", (Object)f, n.getAnnotation("uncertainty"));
        return (V)f;
    }

    private void updateMapOfBestScoreFoundSoFar(List<T> nodeInCompleterGraph, V scoreOnOriginalBenchmark) {
        Comparable bestKnownScore = (Comparable)this.bestKnownScoreUnderNodeInCompleterGraph.get(nodeInCompleterGraph);
        if (bestKnownScore == null || scoreOnOriginalBenchmark.compareTo((Comparable)bestKnownScore) < 0) {
            this.logger.debug("Updating best score of path, because score {} is better than previously observed best score {} under path {}", new Object[]{scoreOnOriginalBenchmark, bestKnownScore, nodeInCompleterGraph});
            this.bestKnownScoreUnderNodeInCompleterGraph.put(nodeInCompleterGraph, scoreOnOriginalBenchmark);
            if (nodeInCompleterGraph.size() > 1) {
                this.updateMapOfBestScoreFoundSoFar(nodeInCompleterGraph.subList(0, nodeInCompleterGraph.size() - 1), scoreOnOriginalBenchmark);
            }
        }
    }

    protected V getFValueOfSolutionPath(List<T> path) throws InterruptedException, NodeEvaluationException {
        boolean knownPath = this.scoresOfSolutionPaths.containsKey(path);
        if (!knownPath) {
            if (this.unsuccessfulPaths.contains(path)) {
                this.logger.warn("Asking again for the reevaluation of a path that was evaluated unsuccessfully in a previous run; returning NULL: {}", path);
                return null;
            }
            this.logger.debug("Associated plan is new. Calling solution evaluator {} to compute f-value for path of length {}. Enable TRACE for exact plan.", (Object)this.solutionEvaluator.getClass().getName(), (Object)path.size());
            this.logger.trace("The path is {}", path);
            long start = System.currentTimeMillis();
            Comparable val = null;
            try {
                val = this.solutionEvaluator.evaluate(new SearchGraphPath(path));
            }
            catch (InterruptedException e) {
                this.logger.info("Received interrupt during computation of f-value.");
                throw e;
            }
            catch (Exception e) {
                this.unsuccessfulPaths.add(path);
                throw new NodeEvaluationException(e, "Error in evaluating node!");
            }
            long duration = System.currentTimeMillis() - start;
            if (duration >= (long)this.timeoutForSingleCompletionEvaluationInMS) {
                this.logger.warn("Evaluation took {}ms, but timeout is {}", (Object)duration, (Object)this.timeoutForSingleCompletionEvaluationInMS);
                assert (duration < (long)(this.timeoutForSingleCompletionEvaluationInMS + 10000)) : "Evaluation took " + duration + "ms, but timeout is " + this.timeoutForSingleCompletionEvaluationInMS;
            }
            this.logger.info("Result: {}, Size: {}", (Object)val, (Object)this.scoresOfSolutionPaths.size());
            if (val == null) {
                this.logger.warn("The solution evaluator has returned NULL, which should not happen.");
                this.unsuccessfulPaths.add(path);
                return null;
            }
            this.scoresOfSolutionPaths.put(path, val);
            this.timesToComputeEvaluations.put(path, (int)duration);
            this.postSolution(path);
        } else {
            this.logger.info("Associated plan is known. Reading score from cache.");
            if (this.logger.isTraceEnabled()) {
                for (List<T> existingPath : this.scoresOfSolutionPaths.keySet()) {
                    if (!existingPath.equals(path)) continue;
                    this.logger.trace("The following plans appear equal:\n\t{}\n\t{}", existingPath, path);
                }
            }
            if (!this.postedSolutions.contains(path)) {
                throw new IllegalStateException("Reading cached score of a plan whose path has not been posted as a solution! Are there several paths to a plan?");
            }
        }
        Comparable score = (Comparable)this.scoresOfSolutionPaths.get(path);
        assert (score != null) : "Stored scores must never be null";
        this.logger.debug("Determined value {} for path of length {}.", (Object)score, (Object)path.size());
        this.logger.trace("Full path is {}", path);
        return (V)score;
    }

    protected void postSolution(List<T> solution) {
        assert (!this.postedSolutions.contains(solution)) : "Solution " + solution.toString() + " already posted!";
        assert (((NodeGoalTester)this.generator.getGoalTester()).isGoal(solution.get(solution.size() - 1))) : "Last node is not a goal node!";
        this.postedSolutions.add(solution);
        try {
            int numberOfComputedFValues = this.scoresOfSolutionPaths.size();
            if (this.eventBus == null) {
                this.eventBus = new SolutionEventBus();
            }
            EvaluatedSearchGraphPath solutionObject = new EvaluatedSearchGraphPath(solution, null, (Comparable)this.scoresOfSolutionPaths.get(solution));
            solutionObject.setAnnotation("fTime", this.timesToComputeEvaluations.get(solution));
            solutionObject.setAnnotation("timeToSolution", (int)(System.currentTimeMillis() - this.timestampOfFirstEvaluation));
            solutionObject.setAnnotation("nodesEvaluatedToSolution", numberOfComputedFValues);
            this.logger.debug("Posting solution {}", solutionObject);
            this.eventBus.post((Object)new EvaluatedSearchSolutionCandidateFoundEvent(ALGORITHM_ID, solutionObject));
        }
        catch (Exception e) {
            ArrayList<SetUtil.Pair> explanations = new ArrayList<SetUtil.Pair>();
            if (this.logger.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                solution.forEach(n -> sb.append(n.toString() + "\n"));
                explanations.add(new SetUtil.Pair((Object)"The path that has been tried to convert is as follows:", (Object)sb.toString()));
            }
            this.logger.error("Cannot post solution, because no valid MLPipeline object could be derived from it:\n{}", (Object)LoggerUtil.getExceptionInfo((Throwable)e, explanations));
        }
    }

    @Override
    public void setGenerator(GraphGenerator<T, ?> generator) {
        this.generator = generator;
        RandomizedDepthFirstNodeEvaluator nodeEvaluator = new RandomizedDepthFirstNodeEvaluator(this.random);
        GraphSearchWithSubpathEvaluationsInput completionProblem = new GraphSearchWithSubpathEvaluationsInput(this.generator, nodeEvaluator);
        this.completer = new RandomSearch(completionProblem, this.priorityPredicateForRDFS, this.random);
        if (this.getTotalDeadline() >= 0L) {
            this.completer.setTimeout(new TimeOut(this.getTotalDeadline() - System.currentTimeMillis(), TimeUnit.MILLISECONDS));
        }
        if (this.loggerName != null) {
            this.completer.setLoggerName(this.loggerName + ".completer");
        }
        AlgorithmEvent e = this.completer.next();
        assert (e instanceof AlgorithmInitializedEvent) : "First event of completer is not the initialization event!";
        this.logger.info("Generator has been set, and completer has been initialized");
    }

    @Subscribe
    public void receiveCompleterEvent(NodeExpansionCompletedEvent<Node<T, Double>> event) {
        this.completerInsertionSemaphore.release();
    }

    @Override
    public void registerSolutionListener(Object listener) {
        this.eventBus.register(listener);
    }

    @Override
    public void cancelActiveTasks() {
        this.logger.info("Receive cancel signal. Canceling the completer.");
        this.completer.cancel();
    }

    public void setNumberOfRandomCompletions(int randomCompletions) {
        this.samples = randomCompletions;
    }

    @Override
    public void setUncertaintySource(IUncertaintySource<T, V> uncertaintySource) {
        this.uncertaintySource = uncertaintySource;
    }

    public IObjectEvaluator<SearchGraphPath<T, A>, V> getSolutionEvaluator() {
        return this.solutionEvaluator;
    }

    public boolean isVisualizeSubSearch() {
        return this.visualizeSubSearch;
    }

    public void setVisualizeSubSearch(boolean visualizeSubSearch) {
        this.visualizeSubSearch = visualizeSubSearch;
    }

    @Override
    public void setLoggerName(String name) {
        this.loggerName = name;
        this.logger.info("Switching logger (name) of object of class {} to {}", (Object)this.getClass().getName(), (Object)name);
        this.logger = LoggerFactory.getLogger((String)name);
        if (this.completer != null) {
            this.completer.setLoggerName(name + ".randomsearch");
        }
        this.logger.info("Switched logger (name) of {} to {}", (Object)this, (Object)name);
        this.logger.info("Reprinting RandomCompletionEvaluator configuration after logger switch: timeout {}ms for single evaluations and {}ms in total per node", (Object)this.timeoutForSingleCompletionEvaluationInMS, (Object)this.getTimeoutForNodeEvaluationInMS());
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    public String toString() {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("solutionEvaluator", this.solutionEvaluator);
        fields.put("visualizeSubSearch", this.visualizeSubSearch);
        return ToJSONStringUtil.toJSONString((String)this.getClass().getSimpleName(), fields);
    }

    @Override
    public boolean requiresGraphGenerator() {
        return true;
    }

    @Override
    public boolean reportsSolutions() {
        return true;
    }

    @Override
    public boolean annotatesUncertainty() {
        return this.uncertaintySource != null;
    }
}

