/*
 * Decompiled with CFR 0.152.
 */
package jaicore.search.algorithms.standard.bestfirst.nodeevaluation;

import jaicore.search.algorithms.standard.bestfirst.exceptions.NodeEvaluationException;
import jaicore.search.algorithms.standard.bestfirst.nodeevaluation.INodeEvaluator;
import jaicore.search.model.travesaltree.Node;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class SkippingNodeEvaluator<T, V extends Comparable<V>>
implements INodeEvaluator<T, V> {
    private final INodeEvaluator<T, V> actualEvaluator;
    private final Random rand;
    private final float coin;
    private final Map<Node<T, ?>, V> fCache = new HashMap();

    public SkippingNodeEvaluator(INodeEvaluator<T, V> actualEvaluator, Random rand, float coin) {
        this.actualEvaluator = actualEvaluator;
        this.rand = rand;
        this.coin = coin;
    }

    @Override
    public V f(Node<T, ?> node) throws NodeEvaluationException, InterruptedException {
        int depth = node.path().size() - 1;
        if (!this.fCache.containsKey(node)) {
            if (depth == 0) {
                this.fCache.put(node, this.actualEvaluator.f(node));
            } else if (this.rand.nextFloat() >= this.coin) {
                this.fCache.put(node, this.actualEvaluator.f(node));
            } else {
                this.fCache.put(node, this.f(node.getParent()));
            }
        }
        return (V)((Comparable)this.fCache.get(node));
    }

    public String toString() {
        return "SkippingEvaluator [actualEvaluator=" + this.actualEvaluator + "]";
    }
}

