/*
 * Decompiled with CFR 0.152.
 */
package jaicore.search.algorithms.standard.bestfirst.nodeevaluation;

import ai.libs.jaicore.basic.ILoggingCustomizable;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmTimeoutedException;
import ai.libs.jaicore.timing.TimedComputation;
import jaicore.search.algorithms.standard.bestfirst.exceptions.NodeEvaluationException;
import jaicore.search.algorithms.standard.bestfirst.nodeevaluation.INodeEvaluator;
import jaicore.search.model.travesaltree.Node;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimeAwareNodeEvaluator<T, V extends Comparable<V>>
implements INodeEvaluator<T, V>,
ILoggingCustomizable {
    private Logger logger = LoggerFactory.getLogger(TimeAwareNodeEvaluator.class);
    private final int timeoutForNodeEvaluationInMS;
    private long totalDeadline = -1L;
    private final INodeEvaluator<T, V> fallbackNodeEvaluator;

    public TimeAwareNodeEvaluator(int pTimeoutInMS) {
        this(pTimeoutInMS, n -> null);
    }

    public TimeAwareNodeEvaluator(int pTimeoutInMS, INodeEvaluator<T, V> pFallbackNodeEvaluator) {
        this.timeoutForNodeEvaluationInMS = pTimeoutInMS;
        this.fallbackNodeEvaluator = pFallbackNodeEvaluator;
    }

    protected abstract V fTimeouted(Node<T, ?> var1, int var2) throws NodeEvaluationException, InterruptedException;

    @Override
    public final V f(Node<T, ?> node) throws NodeEvaluationException, InterruptedException {
        int remainingTime = this.totalDeadline >= 0L && this.timeoutForNodeEvaluationInMS >= 0 ? Math.min(this.timeoutForNodeEvaluationInMS, (int)(this.totalDeadline - System.currentTimeMillis())) : (this.totalDeadline >= 0L ? (int)(this.totalDeadline - System.currentTimeMillis()) : (this.timeoutForNodeEvaluationInMS >= 0 ? this.timeoutForNodeEvaluationInMS : 2147482647));
        int grantedTime = remainingTime - 50;
        int interruptionTime = remainingTime + 150;
        try {
            return (V)((Comparable)TimedComputation.compute(() -> this.fTimeouted(node, grantedTime), (long)interruptionTime, (String)("Node evaluation has timed out (" + TimeAwareNodeEvaluator.class.getName() + "::" + Thread.currentThread() + "-" + System.currentTimeMillis() + ")")));
        }
        catch (AlgorithmTimeoutedException e) {
            this.logger.warn("Computation of f-value for {} failed due to exception {} with message {}", new Object[]{node, ((Object)((Object)e)).getClass().getName(), e.getMessage()});
            return this.fallbackNodeEvaluator.f(node);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof NodeEvaluationException) {
                throw (NodeEvaluationException)((Object)e.getCause());
            }
            throw new NodeEvaluationException(e.getCause(), "Could not evaluate path.");
        }
    }

    public int getTimeoutForNodeEvaluationInMS() {
        return this.timeoutForNodeEvaluationInMS;
    }

    public INodeEvaluator<T, V> getFallbackNodeEvaluator() {
        return this.fallbackNodeEvaluator;
    }

    public long getTotalDeadline() {
        return this.totalDeadline;
    }

    public void setTotalDeadline(long totalDeadline) {
        this.totalDeadline = totalDeadline;
    }

    protected void checkInterruption() throws InterruptedException {
        boolean interrupted = Thread.currentThread().isInterrupted();
        this.logger.debug("Checking interruption of RCNE: {}", (Object)interrupted);
        if (interrupted) {
            Thread.interrupted();
            throw new InterruptedException("Node evaluation of " + this.getClass().getName() + " has been interrupted.");
        }
    }

    public void setLoggerName(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Switched logger name to {}", (Object)name);
    }

    public String getLoggerName() {
        return this.logger.getName();
    }
}

