/*
 * Decompiled with CFR 0.152.
 */
package jaicore.search.algorithms.standard.bestfirst.nodeevaluation;

import jaicore.search.algorithms.standard.bestfirst.exceptions.NodeEvaluationException;
import jaicore.search.algorithms.standard.bestfirst.nodeevaluation.DecoratingNodeEvaluator;
import jaicore.search.algorithms.standard.bestfirst.nodeevaluation.INodeEvaluator;
import jaicore.search.model.travesaltree.Node;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TimeLoggingNodeEvaluator<T, V extends Comparable<V>>
extends DecoratingNodeEvaluator<T, V> {
    private final Map<Node<T, ?>, Integer> times = new ConcurrentHashMap();

    public TimeLoggingNodeEvaluator(INodeEvaluator<T, V> baseEvaluator) {
        super(baseEvaluator);
    }

    public int getMSRequiredForComputation(Node<T, V> node) {
        if (!this.times.containsKey(node)) {
            throw new IllegalArgumentException("No f-value has been computed for node: " + node);
        }
        return this.times.get(node);
    }

    @Override
    public V f(Node<T, ?> node) throws NodeEvaluationException, InterruptedException {
        long start = System.currentTimeMillis();
        Object f = super.f(node);
        this.times.put(node, (int)(System.currentTimeMillis() - start));
        return f;
    }
}

