/*
 * Decompiled with CFR 0.152.
 */
package jaicore.search.algorithms.standard.lds;

import ai.libs.jaicore.basic.ILoggingCustomizable;
import ai.libs.jaicore.basic.algorithm.AlgorithmExecutionCanceledException;
import ai.libs.jaicore.basic.algorithm.AlgorithmState;
import ai.libs.jaicore.basic.algorithm.events.ASolutionCandidateFoundEvent;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmFinishedEvent;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmInitializedEvent;
import ai.libs.jaicore.basic.algorithm.events.SolutionCandidateFoundEvent;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmTimeoutedException;
import com.google.common.eventbus.Subscribe;
import jaicore.search.algorithms.standard.bestfirst.StandardBestFirst;
import jaicore.search.algorithms.standard.bestfirst.events.SuccessorComputationCompletedEvent;
import jaicore.search.algorithms.standard.bestfirst.nodeevaluation.INodeEvaluator;
import jaicore.search.algorithms.standard.lds.NodeOrderList;
import jaicore.search.core.interfaces.AOptimalPathInORGraphSearch;
import jaicore.search.model.other.EvaluatedSearchGraphPath;
import jaicore.search.model.travesaltree.Node;
import jaicore.search.model.travesaltree.NodeExpansionDescription;
import jaicore.search.probleminputs.GraphSearchWithNodeRecommenderInput;
import jaicore.search.probleminputs.GraphSearchWithSubpathEvaluationsInput;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BestFirstLimitedDiscrepancySearch<T, A, V extends Comparable<V>>
extends AOptimalPathInORGraphSearch<GraphSearchWithNodeRecommenderInput<T, A>, T, A, V> {
    private Logger logger = LoggerFactory.getLogger(BestFirstLimitedDiscrepancySearch.class);
    private String loggerName;
    private final StandardBestFirst<T, A, NodeOrderList> bestFirst;

    public BestFirstLimitedDiscrepancySearch(GraphSearchWithNodeRecommenderInput<T, A> problem) {
        super(problem);
        OrderListNumberComputer nodeEvaluator = new OrderListNumberComputer(problem.getRecommender());
        this.bestFirst = new StandardBestFirst(new GraphSearchWithSubpathEvaluationsInput(problem.getGraphGenerator(), nodeEvaluator));
        this.bestFirst.registerListener(nodeEvaluator);
    }

    public void cancel() {
        super.cancel();
        this.bestFirst.cancel();
    }

    public void registerListener(Object listener) {
        this.bestFirst.registerListener(listener);
    }

    public void setNumCPUs(int numberOfCPUs) {
        super.setNumCPUs(numberOfCPUs);
        this.bestFirst.setNumCPUs(numberOfCPUs);
    }

    public AlgorithmEvent nextWithException() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException, AlgorithmException {
        this.checkAndConductTermination();
        if (this.getState().equals((Object)AlgorithmState.created)) {
            this.bestFirst.setTimeout(this.getTimeout());
            return this.activate();
        }
        AlgorithmEvent e = this.bestFirst.nextWithException();
        if (e instanceof AlgorithmInitializedEvent) {
            return this.nextWithException();
        }
        if (e instanceof AlgorithmFinishedEvent) {
            return this.terminate();
        }
        if (e instanceof SolutionCandidateFoundEvent) {
            EvaluatedSearchGraphPath solution = (EvaluatedSearchGraphPath)((SolutionCandidateFoundEvent)e).getSolutionCandidate();
            EvaluatedSearchGraphPath modifiedSolution = new EvaluatedSearchGraphPath(solution.getNodes(), solution.getEdges(), null);
            return new ASolutionCandidateFoundEvent(this.getId(), modifiedSolution);
        }
        return e;
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    @Override
    public void setLoggerName(String name) {
        this.logger.info("Switching logger from {} to {}", (Object)this.logger.getName(), (Object)name);
        this.loggerName = name;
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Activated logger {} with name {}", (Object)name, (Object)this.logger.getName());
        if (this.bestFirst instanceof ILoggingCustomizable) {
            this.bestFirst.setLoggerName(name + ".bestfirst");
        }
        super.setLoggerName(this.loggerName + "._orgraphsearch");
    }

    private class OrderListNumberComputer
    implements INodeEvaluator<T, NodeOrderList> {
        private final Comparator<T> heuristic;
        private final Map<Node<T, ?>, List<T>> childOrdering = new HashMap();

        public OrderListNumberComputer(Comparator<T> heuristic) {
            this.heuristic = heuristic;
        }

        @Override
        public NodeOrderList f(Node<T, ?> node) {
            NodeOrderList list = new NodeOrderList();
            Node parent = node.getParent();
            if (parent == null) {
                return list;
            }
            list.addAll((NodeOrderList)parent.getInternalLabel());
            list.add(this.childOrdering.get(parent).indexOf(node.getPoint()));
            return list;
        }

        @Subscribe
        public void receiveSuccessorsCreatedEvent(SuccessorComputationCompletedEvent<T, ?> successorDescriptions) {
            List successors = successorDescriptions.getSuccessorDescriptions().stream().map(NodeExpansionDescription::getTo).sorted(this.heuristic).collect(Collectors.toList());
            this.childOrdering.put(successorDescriptions.getNode(), successors);
        }
    }
}

