/*
 * Decompiled with CFR 0.152.
 */
package jaicore.search.algorithms.standard.lds;

import ai.libs.jaicore.basic.algorithm.AlgorithmExecutionCanceledException;
import ai.libs.jaicore.basic.algorithm.events.ASolutionCandidateFoundEvent;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmFinishedEvent;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmInitializedEvent;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmTimeoutedException;
import ai.libs.jaicore.graph.TreeNode;
import ai.libs.jaicore.graphvisualizer.events.graph.GraphInitializedEvent;
import ai.libs.jaicore.graphvisualizer.events.graph.NodeAddedEvent;
import jaicore.search.algorithms.standard.lds.NoMoreNodesOnLevelEvent;
import jaicore.search.core.interfaces.AOptimalPathInORGraphSearch;
import jaicore.search.model.other.EvaluatedSearchGraphPath;
import jaicore.search.model.travesaltree.NodeExpansionDescription;
import jaicore.search.probleminputs.GraphSearchWithNodeRecommenderInput;
import jaicore.search.structure.graphgenerator.NodeGoalTester;
import jaicore.search.structure.graphgenerator.PathGoalTester;
import jaicore.search.structure.graphgenerator.SingleRootGenerator;
import jaicore.search.structure.graphgenerator.SuccessorGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LimitedDiscrepancySearch<T, A, V extends Comparable<V>>
extends AOptimalPathInORGraphSearch<GraphSearchWithNodeRecommenderInput<T, A>, T, A, V> {
    private Logger logger = LoggerFactory.getLogger(LimitedDiscrepancySearch.class);
    private String loggerName;
    protected TreeNode<T> traversalTree;
    protected Collection<TreeNode<T>> expanded = new HashSet<TreeNode<T>>();
    protected Collection<TreeNode<T>> exhausted = new HashSet<TreeNode<T>>();
    protected final SingleRootGenerator<T> rootGenerator = (SingleRootGenerator)((GraphSearchWithNodeRecommenderInput)this.getInput()).getGraphGenerator().getRootGenerator();
    protected final SuccessorGenerator<T, A> successorGenerator = ((GraphSearchWithNodeRecommenderInput)this.getInput()).getGraphGenerator().getSuccessorGenerator();
    protected final boolean checkGoalPropertyOnEntirePath;
    protected final PathGoalTester<T> pathGoalTester;
    protected final NodeGoalTester<T> nodeGoalTester;
    protected final Comparator<T> heuristic;
    private int maxK = 0;
    private int currentK = 0;

    public LimitedDiscrepancySearch(GraphSearchWithNodeRecommenderInput<T, A> problemInput) {
        super(problemInput);
        boolean bl = this.checkGoalPropertyOnEntirePath = !(((GraphSearchWithNodeRecommenderInput)this.getInput()).getGraphGenerator().getGoalTester() instanceof NodeGoalTester);
        if (this.checkGoalPropertyOnEntirePath) {
            this.nodeGoalTester = null;
            this.pathGoalTester = (PathGoalTester)((GraphSearchWithNodeRecommenderInput)this.getInput()).getGraphGenerator().getGoalTester();
        } else {
            this.nodeGoalTester = (NodeGoalTester)((GraphSearchWithNodeRecommenderInput)this.getInput()).getGraphGenerator().getGoalTester();
            this.pathGoalTester = null;
        }
        this.heuristic = problemInput.getRecommender();
    }

    public AlgorithmEvent nextWithException() throws InterruptedException, AlgorithmTimeoutedException, AlgorithmExecutionCanceledException, AlgorithmException {
        this.registerActiveThread();
        try {
            switch (this.getState()) {
                case created: {
                    this.traversalTree = this.newNode(null, this.rootGenerator.getRoot());
                    this.post(new GraphInitializedEvent(this.getId(), this.traversalTree));
                    AlgorithmInitializedEvent algorithmInitializedEvent = this.activate();
                    return algorithmInitializedEvent;
                }
                case active: {
                    this.currentK = this.maxK;
                    AlgorithmEvent event = this.ldsProbe(this.traversalTree);
                    if (event instanceof NoMoreNodesOnLevelEvent) {
                        if (this.currentK == 0) {
                            this.logger.info("Probe process has no more nodes to be considered, restarting with augmented k {}", (Object)(this.maxK + 1));
                            ++this.maxK;
                            AlgorithmEvent algorithmEvent = event;
                            return algorithmEvent;
                        }
                        AlgorithmFinishedEvent algorithmFinishedEvent = this.terminate();
                        return algorithmFinishedEvent;
                    }
                    this.logger.info("Returning event {}", (Object)event);
                    this.post(event);
                    AlgorithmEvent algorithmEvent = event;
                    return algorithmEvent;
                }
            }
            throw new IllegalStateException("The algorithm cannot do anything in state " + this.getState());
        }
        finally {
            this.unregisterActiveThread();
        }
    }

    private void updateExhaustMap(TreeNode<T> node) {
        if (node == null) {
            return;
        }
        if (this.exhausted.contains(node)) {
            this.updateExhaustMap(node.getParent());
        }
        if (this.exhausted.containsAll(node.getChildren())) {
            this.exhausted.add(node);
            this.updateExhaustMap(node.getParent());
        }
    }

    private AlgorithmEvent ldsProbe(TreeNode<T> node) throws InterruptedException, AlgorithmTimeoutedException, AlgorithmExecutionCanceledException, AlgorithmException {
        this.logger.debug("Probing under node {} with k = {}. Exhausted: {}", new Object[]{node.getValue(), this.currentK, this.exhausted.contains(node)});
        if (this.nodeGoalTester.isGoal(node.getValue())) {
            this.updateExhaustMap(node);
            List path = node.getValuesOnPathFromRoot();
            EvaluatedSearchGraphPath solution = new EvaluatedSearchGraphPath(path, null, null);
            this.updateBestSeenSolution(solution);
            this.logger.debug("Found solution {}.", node.getValue());
            return new ASolutionCandidateFoundEvent(this.getId(), solution);
        }
        if (!this.expanded.contains(node)) {
            this.expanded.add(node);
            this.logger.debug("Starting successor generation of {}", node.getValue());
            long start = System.currentTimeMillis();
            Collection succ = (Collection)this.computeTimeoutAware(() -> this.successorGenerator.generateSuccessors(node.getValue()), "Successor generation", true);
            if (succ == null || succ.isEmpty()) {
                this.logger.debug("No successors were generated.");
                return new NoMoreNodesOnLevelEvent(this.getId());
            }
            this.logger.debug("Computed {} successors in {}ms. Attaching the nodes to the local model.", (Object)succ.size(), (Object)(System.currentTimeMillis() - start));
            List prioSucc = succ.stream().sorted((d1, d2) -> this.heuristic.compare(d1.getTo(), d2.getTo())).collect(Collectors.toList());
            this.checkAndConductTermination();
            ArrayList<TreeNode<T>> generatedNodes = new ArrayList<TreeNode<T>>();
            long lastCheck = System.currentTimeMillis();
            for (NodeExpansionDescription successorDescription : prioSucc) {
                if (System.currentTimeMillis() - lastCheck > 10L) {
                    this.checkAndConductTermination();
                    lastCheck = System.currentTimeMillis();
                }
                TreeNode<T> newNode = this.newNode(node, successorDescription.getTo());
                generatedNodes.add(newNode);
            }
            this.logger.debug("Local model updated.");
            this.checkAndConductTermination();
        } else {
            this.logger.info("Not expanding node {} again.", node.getValue());
        }
        List children = node.getChildren();
        if (children.isEmpty()) {
            return new NoMoreNodesOnLevelEvent(this.getId());
        }
        if (this.currentK == 0 || children.size() == 1) {
            boolean onlyAdmissibleChildExhausted = this.exhausted.contains(children.get(0));
            this.logger.debug("No deviation allowed or only one child node. Probing this child (if not, the reason is that it is exhausted already): {}", (Object)(!onlyAdmissibleChildExhausted ? 1 : 0));
            return !onlyAdmissibleChildExhausted ? this.ldsProbe((TreeNode)children.get(0)) : new NoMoreNodesOnLevelEvent(this.getId());
        }
        --this.currentK;
        this.logger.debug("Deviating from heuristic. Decreased current k to {}", (Object)this.currentK);
        if (this.exhausted.contains(children.get(1))) {
            return new NoMoreNodesOnLevelEvent(this.getId());
        }
        return this.ldsProbe((TreeNode)children.get(1));
    }

    protected synchronized TreeNode<T> newNode(TreeNode<T> parent, T newNode) {
        TreeNode newTree;
        TreeNode treeNode = newTree = parent != null ? parent.addChild(newNode) : new TreeNode(newNode);
        if (parent != null) {
            boolean isGoal = this.nodeGoalTester.isGoal(newNode);
            this.post(new NodeAddedEvent(this.getId(), parent, (Object)newTree, "or_" + (isGoal ? "solution" : "created")));
        }
        return newTree;
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    @Override
    public void setLoggerName(String name) {
        this.logger.info("Switching logger from {} to {}", (Object)this.logger.getName(), (Object)name);
        this.loggerName = name;
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Activated logger {} with name {}", (Object)name, (Object)this.logger.getName());
        super.setLoggerName(this.loggerName + "._orgraphsearch");
    }
}

