/*
 * Decompiled with CFR 0.152.
 */
package jaicore.search.algorithms.standard.mcts;

import ai.libs.jaicore.basic.ILoggingCustomizable;
import ai.libs.jaicore.basic.IObjectEvaluator;
import ai.libs.jaicore.basic.algorithm.AlgorithmExecutionCanceledException;
import ai.libs.jaicore.basic.algorithm.AlgorithmState;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmFinishedEvent;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmTimeoutedException;
import ai.libs.jaicore.basic.algorithm.exceptions.ObjectEvaluationFailedException;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.graph.LabeledGraph;
import ai.libs.jaicore.graphvisualizer.events.graph.GraphInitializedEvent;
import ai.libs.jaicore.graphvisualizer.events.graph.NodeAddedEvent;
import ai.libs.jaicore.graphvisualizer.events.graph.NodeTypeSwitchEvent;
import jaicore.search.algorithms.standard.bestfirst.events.EvaluatedSearchSolutionCandidateFoundEvent;
import jaicore.search.algorithms.standard.mcts.ActionPredictionFailedException;
import jaicore.search.algorithms.standard.mcts.IPathUpdatablePolicy;
import jaicore.search.algorithms.standard.mcts.IPolicy;
import jaicore.search.core.interfaces.AOptimalPathInORGraphSearch;
import jaicore.search.core.interfaces.GraphGenerator;
import jaicore.search.model.other.EvaluatedSearchGraphPath;
import jaicore.search.model.other.SearchGraphPath;
import jaicore.search.model.travesaltree.Node;
import jaicore.search.model.travesaltree.NodeExpansionDescription;
import jaicore.search.probleminputs.GraphSearchWithPathEvaluationsInput;
import jaicore.search.structure.graphgenerator.NodeGoalTester;
import jaicore.search.structure.graphgenerator.PathGoalTester;
import jaicore.search.structure.graphgenerator.RootGenerator;
import jaicore.search.structure.graphgenerator.SingleRootGenerator;
import jaicore.search.structure.graphgenerator.SuccessorGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MCTS<N, A, V extends Comparable<V>>
extends AOptimalPathInORGraphSearch<GraphSearchWithPathEvaluationsInput<N, A, V>, N, A, V>
implements IPolicy<N, A, V> {
    private static final String NODESTATE_ROLLOUT = "or_rollout";
    private Logger logger = LoggerFactory.getLogger(MCTS.class);
    private String loggerName;
    protected final Map<N, Node<N, V>> ext2int = new HashMap<N, Node<N, V>>();
    protected final GraphGenerator<N, A> graphGenerator;
    protected final RootGenerator<N> rootGenerator;
    protected final SuccessorGenerator<N, A> successorGenerator;
    protected final boolean checkGoalPropertyOnEntirePath;
    protected final PathGoalTester<N> pathGoalTester;
    protected final NodeGoalTester<N> nodeGoalTester;
    protected final IPathUpdatablePolicy<N, A, V> treePolicy;
    protected final IPolicy<N, A, V> defaultPolicy;
    protected final IObjectEvaluator<SearchGraphPath<N, A>, V> playoutSimulator;
    private final Map<List<N>, V> scoreCache = new HashMap<List<N>, V>();
    private final N root;
    private final Collection<N> nodesExplicitlyAdded = new HashSet<N>();
    private final Collection<N> unexpandedNodes = new HashSet<N>();
    protected final LabeledGraph<N, A> exploredGraph;
    private final Collection<N> fullyExploredNodes = new HashSet<N>();
    private final Collection<N> deadLeafNodes = new HashSet<N>();
    private final V penaltyForFailedEvaluation;
    private final boolean forbidDoublePaths;

    public MCTS(GraphSearchWithPathEvaluationsInput<N, A, V> problem, IPathUpdatablePolicy<N, A, V> treePolicy, IPolicy<N, A, V> defaultPolicy, V penaltyForFailedEvaluation, boolean forbidDoublePaths) {
        super(problem);
        this.graphGenerator = problem.getGraphGenerator();
        this.rootGenerator = this.graphGenerator.getRootGenerator();
        this.successorGenerator = this.graphGenerator.getSuccessorGenerator();
        boolean bl = this.checkGoalPropertyOnEntirePath = !(this.graphGenerator.getGoalTester() instanceof NodeGoalTester);
        if (this.checkGoalPropertyOnEntirePath) {
            this.nodeGoalTester = null;
            this.pathGoalTester = (PathGoalTester)this.graphGenerator.getGoalTester();
        } else {
            this.nodeGoalTester = (NodeGoalTester)this.graphGenerator.getGoalTester();
            this.pathGoalTester = null;
        }
        this.treePolicy = treePolicy;
        this.defaultPolicy = defaultPolicy;
        this.playoutSimulator = problem.getPathEvaluator();
        this.exploredGraph = new LabeledGraph();
        this.root = ((SingleRootGenerator)this.rootGenerator).getRoot();
        this.unexpandedNodes.add(this.root);
        this.exploredGraph.addItem(this.root);
        this.penaltyForFailedEvaluation = penaltyForFailedEvaluation;
        this.forbidDoublePaths = forbidDoublePaths;
    }

    private List<N> getPlayout() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException, AlgorithmException, ActionPredictionFailedException {
        A chosenAction;
        this.logger.debug("Computing a new playout ...");
        Object current = this.root;
        Set childrenOfCurrent = this.unexpandedNodes.contains(current) ? null : this.exploredGraph.getSuccessors(current);
        ArrayList<N> path = new ArrayList<N>();
        path.add(current);
        this.logger.debug("Step 1: Using tree policy to identify new path to not fully expanded node.");
        int level = 0;
        while (childrenOfCurrent != null && SetUtil.differenceEmpty((Collection)childrenOfCurrent, this.nodesExplicitlyAdded)) {
            this.logger.trace("Step 1 (level {}): choose one of the {} succesors {} of current node {}", new Object[]{level, childrenOfCurrent.size(), childrenOfCurrent, current});
            this.checkAndConductTermination();
            ArrayList<Object> availableActions = new ArrayList<Object>();
            HashMap successorStates = new HashMap();
            for (Object child : childrenOfCurrent) {
                if (this.deadLeafNodes.contains(child)) {
                    this.logger.trace("Ignoring child {}, which is known to be a dead end", child);
                    continue;
                }
                if (this.forbidDoublePaths && this.fullyExploredNodes.contains(child)) {
                    this.logger.trace("Ignoring child {}, which has been fully explored.", child);
                    continue;
                }
                Object action = this.exploredGraph.getEdgeLabel(current, child);
                assert (!successorStates.containsKey(action)) : "A successor state has already been defined for action \"" + action + "\" with hashCode " + action.hashCode();
                availableActions.add(action);
                successorStates.put(action, child);
                assert (successorStates.keySet().size() == availableActions.size()) : "We have generated " + availableActions.size() + " available actions but the map of successor states only contains " + successorStates.keySet().size() + " item(s). Actions (by hash codes): \n\t" + availableActions.stream().map(a -> a.hashCode() + ": " + a.toString()).collect(Collectors.joining("\n\t"));
            }
            if (availableActions.isEmpty()) {
                this.logger.debug("Node {} has only dead-end successors and hence is a dead-end itself. Adding it to the list of dead ends.", current);
                if (current == this.exploredGraph.getRoot()) {
                    this.logger.info("No more action available in root node. Throwing exception.");
                    throw new NoSuchElementException();
                }
                this.deadLeafNodes.add(current);
                return this.getPlayout();
            }
            this.logger.trace("{} available actions of expanded node {}: {}. Corresponding successor states: {}", new Object[]{availableActions.size(), current, availableActions, successorStates});
            Object chosenAction2 = this.treePolicy.getAction(current, successorStates);
            assert (chosenAction2 != null) : "Chosen action must not be null!";
            Object next = successorStates.get(chosenAction2);
            assert (next != null) : "Next action must not be null!";
            this.logger.trace("Tree policy decides to expand {} taking action {} to {}", new Object[]{current, chosenAction2, next});
            current = next;
            childrenOfCurrent = this.unexpandedNodes.contains(current) ? null : this.exploredGraph.getSuccessors(current);
            path.add(current);
            if (this.isGoal(current)) {
                this.logger.debug("Constructed complete solution with tree policy.");
                return path;
            }
            this.post(new NodeTypeSwitchEvent(this.getId(), next, NODESTATE_ROLLOUT));
            ++level;
        }
        assert (childrenOfCurrent == null || !childrenOfCurrent.isEmpty()) : "Set of children of current node must not be empty!";
        assert (childrenOfCurrent == null || SetUtil.differenceNotEmpty((Collection)childrenOfCurrent, this.nodesExplicitlyAdded)) : "The current node has " + childrenOfCurrent.size() + " successors and all of them have been considered in at least one playout. In spite of this, the tree policy has not been used to choose a child, but it should have been used.";
        assert (childrenOfCurrent == null || SetUtil.differenceNotEmpty((Collection)childrenOfCurrent, this.deadLeafNodes)) : "Flag that current node is dead end is set, but there are successors that are not yet marked as dead-ends.";
        this.logger.debug("Determined non-fully-expanded node {} of traversal tree using tree policy. Untried successors are: {}. Now selecting an untried successor.", current, childrenOfCurrent != null ? SetUtil.difference((Collection)childrenOfCurrent, this.nodesExplicitlyAdded) : "<not generated>");
        this.checkAndConductTermination();
        HashMap<Object, Object> untriedActionsAndTheirSuccessors = new HashMap<Object, Object>();
        if (this.unexpandedNodes.contains(current)) {
            this.logger.trace("This is the first time we visit this node, so compute its successors and add add them to explicit graph model.");
            untriedActionsAndTheirSuccessors.putAll(this.expandNode(current));
        } else {
            for (Object child : SetUtil.difference((Collection)childrenOfCurrent, this.nodesExplicitlyAdded)) {
                Object action = this.exploredGraph.getEdgeLabel(current, child);
                untriedActionsAndTheirSuccessors.put(action, child);
            }
        }
        this.logger.debug("Step 2: Using default policy to choose one of the {} untried actions {} of current node {}", new Object[]{untriedActionsAndTheirSuccessors.size(), untriedActionsAndTheirSuccessors.keySet(), current});
        if (!untriedActionsAndTheirSuccessors.isEmpty()) {
            this.logger.trace("Asking default policy for action to take in node {}", current);
            chosenAction = this.defaultPolicy.getAction(current, untriedActionsAndTheirSuccessors);
            current = untriedActionsAndTheirSuccessors.get(chosenAction);
            assert (this.unexpandedNodes.contains(current));
        } else {
            this.deadLeafNodes.add(current);
            this.logger.debug("Found leaf node {}. Adding to dead end list.", current);
            return this.getPlayout();
        }
        this.nodesExplicitlyAdded.add(current);
        this.post(new NodeTypeSwitchEvent(this.getId(), current, NODESTATE_ROLLOUT));
        path.add(current);
        this.logger.debug("Selected {} as the untried action with successor state {}. Now completing rest playout from this situation.", chosenAction, current);
        this.logger.debug("Step 3: Using default policy to create full path under {}.", current);
        while (!this.isGoal(current)) {
            assert (this.unexpandedNodes.contains(current));
            this.checkAndConductTermination();
            HashMap<A, N> actionsAndTheirSuccessorStates = new HashMap<A, N>();
            this.logger.trace("Determining possible moves for {}.", current);
            actionsAndTheirSuccessorStates.putAll(this.expandNode(current));
            if (actionsAndTheirSuccessorStates.isEmpty()) {
                this.deadLeafNodes.add(current);
                this.propagateFullyKnownNodes(current);
                return path;
            }
            if (!this.isGoal(current = actionsAndTheirSuccessorStates.get(this.defaultPolicy.getAction(current, actionsAndTheirSuccessorStates)))) {
                this.post(new NodeTypeSwitchEvent(this.getId(), current, NODESTATE_ROLLOUT));
            }
            this.nodesExplicitlyAdded.add(current);
            path.add(current);
        }
        this.checkThatPathIsSolution(path);
        this.logger.debug("Drawn playout path is: {}.", path);
        this.propagateFullyKnownNodes(current);
        return path;
    }

    private void closePath(List<N> path) {
        int n = path.size();
        for (int i = n - 2; i > 0; --i) {
            N node = path.get(i);
            this.post(new NodeTypeSwitchEvent(this.getId(), node, this.fullyExploredNodes.contains(node) ? "or_exhausted" : "or_closed"));
        }
    }

    private void propagateFullyKnownNodes(N node) {
        if (this.fullyExploredNodes.containsAll(this.exploredGraph.getSuccessors(node))) {
            this.fullyExploredNodes.add(node);
            assert (this.exploredGraph.getPredecessors(node).size() <= 1);
            if (this.exploredGraph.getPredecessors(node).isEmpty()) {
                return;
            }
            this.propagateFullyKnownNodes(this.exploredGraph.getPredecessors(node).iterator().next());
        }
    }

    private Map<A, N> expandNode(N node) throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException, AlgorithmException {
        this.logger.debug("Starting expansion of node {}", node);
        this.checkAndConductTermination();
        if (!this.unexpandedNodes.contains(node)) {
            throw new IllegalArgumentException();
        }
        this.logger.trace("Situation {} has never been analyzed before, expanding the graph at the respective point.", node);
        this.unexpandedNodes.remove(node);
        Collection availableActions = (Collection)this.computeTimeoutAware(() -> this.successorGenerator.generateSuccessors(node), "Successor generation", true);
        assert (availableActions.stream().map(NodeExpansionDescription::getAction).collect(Collectors.toList()).size() == availableActions.stream().map(NodeExpansionDescription::getAction).collect(Collectors.toSet()).size()) : "The actions under this node don't have unique names";
        HashMap successorStates = new HashMap();
        for (NodeExpansionDescription d : availableActions) {
            this.checkAndConductTermination();
            successorStates.put(d.getAction(), d.getTo());
            this.logger.trace("Adding edge {} -> {} with label {}", new Object[]{d.getFrom(), d.getTo(), d.getAction()});
            this.exploredGraph.addItem(d.getTo());
            this.unexpandedNodes.add(d.getTo());
            this.exploredGraph.addEdge(d.getFrom(), d.getTo(), d.getAction());
            this.post(new NodeAddedEvent(this.getId(), d.getFrom(), d.getTo(), this.isGoal(d.getTo()) ? "or_solution" : "or_open"));
        }
        return successorStates;
    }

    private boolean isGoal(N node) {
        return this.nodeGoalTester.isGoal(node);
    }

    @Override
    public A getAction(N node, Map<A, N> actionsWithSuccessors) throws ActionPredictionFailedException {
        try {
            this.nextSolutionCandidate();
            return this.treePolicy.getAction(this.root, actionsWithSuccessors);
        }
        catch (Exception e) {
            throw new ActionPredictionFailedException(e);
        }
    }

    private void checkThatPathIsSolution(List<N> path) {
        Object current = this.exploredGraph.getRoot();
        assert (current.equals(path.get(0))) : "The root of the path does not match the root of the graph!";
        for (int i = 1; i < path.size(); ++i) {
            assert (this.exploredGraph.getSuccessors(current).contains(path.get(i))) : "Invalid path. The " + i + "-th entry " + path.get(i) + " of the path " + path + " is not a successor of the " + (i - 1) + "-th node whose successors are " + this.exploredGraph.getSuccessors(current) + "!";
            current = path.get(i);
        }
        assert (!path.isEmpty()) : "Solution paths cannot be empty!";
        assert (this.isGoal(path.get(path.size() - 1))) : "The head of a solution path must be a goal node, but this is not the case for this path: \n\t" + path.stream().map(Object::toString).collect(Collectors.joining("\n\t"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlgorithmEvent nextWithException() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmException, AlgorithmTimeoutedException {
        switch (this.getState()) {
            case created: {
                this.post(new GraphInitializedEvent(this.getId(), this.root));
                this.logger.info("Starting MCTS with node class {}", (Object)this.root.getClass().getName());
                return this.activate();
            }
            case active: {
                AlgorithmFinishedEvent algorithmFinishedEvent;
                if (this.playoutSimulator == null) {
                    throw new IllegalStateException("no simulator has been set!");
                }
                this.logger.debug("Next algorithm iteration. Number of unexpanded nodes: {}", (Object)this.unexpandedNodes.size());
                try {
                    this.registerActiveThread();
                    while (this.getState() == AlgorithmState.active) {
                        Comparable playoutScore;
                        this.checkAndConductTermination();
                        if (this.unexpandedNodes.isEmpty()) {
                            AlgorithmFinishedEvent finishEvent = this.terminate();
                            this.logger.info("Finishing MCTS as all nodes have been expanded; the search graph has been exhausted.");
                            algorithmFinishedEvent = finishEvent;
                            return algorithmFinishedEvent;
                        }
                        this.logger.debug("There are {} known unexpanded nodes. Starting computation of next playout path.", (Object)this.unexpandedNodes.size());
                        List<N> path = this.getPlayout();
                        assert (path != null) : "The playout must never be null!";
                        if (!this.scoreCache.containsKey(path)) {
                            this.logger.debug("Obtained path {}. Now starting computation of the score for this playout.", path);
                            try {
                                playoutScore = this.playoutSimulator.evaluate(this.getPathForNodeList(path));
                                boolean isSolutionPlayout = this.nodeGoalTester.isGoal(path.get(path.size() - 1));
                                this.logger.debug("Determined playout score {}. Is goal: {}. Now updating the path.", (Object)playoutScore, (Object)isSolutionPlayout);
                                this.scoreCache.put(path, playoutScore);
                                this.treePolicy.updatePath(path, playoutScore);
                                if (!isSolutionPlayout) continue;
                                EvaluatedSearchSolutionCandidateFoundEvent<N, A, Comparable> evaluatedSearchSolutionCandidateFoundEvent = this.registerSolution(new EvaluatedSearchGraphPath<N, A, Comparable>(path, this.getActionListForPath(path), playoutScore));
                                return evaluatedSearchSolutionCandidateFoundEvent;
                            }
                            catch (InterruptedException e) {
                                Thread.interrupted();
                                this.checkAndConductTermination();
                                throw e;
                            }
                            catch (ObjectEvaluationFailedException e) {
                                this.scoreCache.put(path, this.penaltyForFailedEvaluation);
                                this.post(new NodeTypeSwitchEvent(this.getId(), path.get(path.size() - 1), "or_ffail"));
                                this.treePolicy.updatePath(path, this.penaltyForFailedEvaluation);
                                this.logger.warn("Could not evaluate playout {}", (Throwable)e);
                                continue;
                            }
                            finally {
                                this.closePath(path);
                                continue;
                            }
                        }
                        assert (!this.forbidDoublePaths) : "Second time path " + this.getActionListForPath(path) + " has been generated even though double paths are forbidden!";
                        this.logger.warn("Path {} has already been observed in the past.", this.getActionListForPath(path));
                        playoutScore = (Comparable)this.scoreCache.get(path);
                        this.logger.debug("Looking up score {} for the already evaluated path {}", (Object)playoutScore, path);
                        this.treePolicy.updatePath(path, playoutScore);
                        this.closePath(path);
                    }
                }
                catch (NoSuchElementException e) {
                    this.logger.info("No more playouts exist. Terminating.");
                    algorithmFinishedEvent = this.terminate();
                    return algorithmFinishedEvent;
                }
                catch (ActionPredictionFailedException e) {
                    throw new AlgorithmException((Throwable)e, "Step failed due to an exception in predicting an action when computing the playout.");
                }
                finally {
                    this.unregisterActiveThread();
                }
                throw new IllegalStateException("The algorithm has reached the end of the active-block, which shall never happen.");
            }
        }
        throw new UnsupportedOperationException("Cannot do anything in state " + this.getState());
    }

    private List<A> getActionListForPath(List<N> path) {
        ArrayList<Object> actions = new ArrayList<Object>();
        int n = path.size();
        for (int i = 1; i < n; ++i) {
            actions.add(this.exploredGraph.getEdgeLabel(path.get(i - 1), path.get(i)));
        }
        return actions;
    }

    private SearchGraphPath<N, A> getPathForNodeList(List<N> nodeList) {
        ArrayList<Object> actions = new ArrayList<Object>();
        int n = nodeList.size();
        for (int i = 1; i < n; ++i) {
            actions.add(this.exploredGraph.getEdgeLabel(nodeList.get(i - 1), nodeList.get(i)));
        }
        return new SearchGraphPath(nodeList, actions);
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    @Override
    public void setLoggerName(String name) {
        this.logger.info("Switching logger from {} to {}", (Object)this.logger.getName(), (Object)name);
        this.loggerName = name;
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Activated logger {} with name {}", (Object)name, (Object)this.logger.getName());
        super.setLoggerName(this.loggerName + "._orgraphsearch");
        if (this.graphGenerator instanceof ILoggingCustomizable) {
            this.logger.info("Setting logger of graph generator to {}.graphgenerator", (Object)name);
            ((ILoggingCustomizable)this.graphGenerator).setLoggerName(name + ".graphgenerator");
        } else {
            this.logger.info("Not setting logger of graph generator");
        }
        if (this.treePolicy instanceof ILoggingCustomizable) {
            this.logger.info("Setting logger of tree policy to {}.treepolicy", (Object)name);
            ((ILoggingCustomizable)this.treePolicy).setLoggerName(name + ".treepolicy");
        } else {
            this.logger.info("Not setting logger of tree policy");
        }
    }
}

