/*
 * Decompiled with CFR 0.152.
 */
package jaicore.search.algorithms.standard.opencollections;

import ai.libs.jaicore.basic.sets.SetUtil;
import jaicore.search.model.travesaltree.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnforcedExplorationOpenSelection<N, V extends Comparable<V>>
extends PriorityQueue<Node<N, V>> {
    private static final Logger logger = LoggerFactory.getLogger(EnforcedExplorationOpenSelection.class);
    private final Collection<Node<N, V>> suspended = new ArrayList<Node<N, V>>();
    private Node<N, V> temporaryRoot;

    public void setTemporaryRoot(Node<N, V> temporaryRoot) {
        int numItemsBefore = this.size() + this.suspended.size();
        this.temporaryRoot = temporaryRoot;
        Collection openAndSuspendedNodes = SetUtil.union((Collection[])new Collection[]{this.suspended, this});
        this.suspended.clear();
        this.clear();
        Iterator iterator = openAndSuspendedNodes.iterator();
        while (iterator.hasNext()) {
            Node n;
            boolean isSuspsended = true;
            for (Node current = n = (Node)iterator.next(); current != null; current = current.getParent()) {
                if (!current.equals(temporaryRoot)) continue;
                isSuspsended = false;
                break;
            }
            if (isSuspsended) {
                this.suspended.add(n);
                continue;
            }
            this.add(n);
        }
        int numItemsAfter = this.size() + this.suspended.size();
        assert (numItemsAfter == numItemsBefore) : "The total number of elements in OPEN/SUSPENDED has changed from " + numItemsBefore + " to " + numItemsAfter + " by setting the temporary root!";
    }

    public Node<N, V> getTemporaryRoot() {
        return this.temporaryRoot;
    }
}

