/*
 * Decompiled with CFR 0.152.
 */
package jaicore.search.algorithms.standard.random;

import ai.libs.jaicore.basic.ILoggingCustomizable;
import ai.libs.jaicore.basic.algorithm.AlgorithmExecutionCanceledException;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmFinishedEvent;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmInitializedEvent;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmTimeoutedException;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.graph.Graph;
import ai.libs.jaicore.graphvisualizer.events.graph.GraphInitializedEvent;
import ai.libs.jaicore.graphvisualizer.events.graph.NodeAddedEvent;
import ai.libs.jaicore.graphvisualizer.events.graph.NodeTypeSwitchEvent;
import jaicore.search.algorithms.standard.bestfirst.events.GraphSearchSolutionCandidateFoundEvent;
import jaicore.search.core.interfaces.AAnyPathInORGraphSearch;
import jaicore.search.model.other.SearchGraphPath;
import jaicore.search.model.travesaltree.NodeExpansionDescription;
import jaicore.search.probleminputs.GraphSearchInput;
import jaicore.search.structure.graphgenerator.NodeGoalTester;
import jaicore.search.structure.graphgenerator.SingleRootGenerator;
import jaicore.search.structure.graphgenerator.SingleSuccessorGenerator;
import jaicore.search.structure.graphgenerator.SuccessorGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomSearch<N, A>
extends AAnyPathInORGraphSearch<GraphSearchInput<N, A>, SearchGraphPath<N, A>, N, A>
implements ILoggingCustomizable {
    private String loggerName;
    private Logger logger = LoggerFactory.getLogger(RandomSearch.class);
    private final N root;
    private final SuccessorGenerator<N, A> gen;
    private final boolean isSingleNodeSuccessorGenerator;
    private final NodeGoalTester<N> goalTester;
    private final Graph<N> exploredGraph = new Graph();
    private final Set<N> closed = new HashSet<N>();
    private final Predicate<N> priorityPredicate;
    private final Set<N> prioritizedNodes = new HashSet<N>();
    private final Set<N> exhausted = new HashSet<N>();
    private final Random random;

    public RandomSearch(GraphSearchInput<N, A> problem) {
        this(problem, 0);
    }

    public RandomSearch(GraphSearchInput<N, A> problem, int seed) {
        this(problem, new Random(seed));
    }

    public RandomSearch(GraphSearchInput<N, A> problem, Random random) {
        this(problem, null, random);
    }

    public RandomSearch(GraphSearchInput<N, A> problem, Predicate<N> priorityPredicate, Random random) {
        super(problem);
        this.root = ((SingleRootGenerator)problem.getGraphGenerator().getRootGenerator()).getRoot();
        this.gen = problem.getGraphGenerator().getSuccessorGenerator();
        this.isSingleNodeSuccessorGenerator = this.gen instanceof SingleSuccessorGenerator;
        this.goalTester = (NodeGoalTester)problem.getGraphGenerator().getGoalTester();
        this.exploredGraph.addItem(this.root);
        this.random = random;
        this.priorityPredicate = priorityPredicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandNode(N node) throws InterruptedException, AlgorithmTimeoutedException, AlgorithmExecutionCanceledException {
        Graph<N> graph = this.exploredGraph;
        synchronized (graph) {
            assert (this.exploredGraph.isGraphSane());
            assert (!this.goalTester.isGoal(node)) : "Goal nodes cannot be expanded!";
            assert (this.exploredGraph.hasItem(node)) : "Node that shall be expanded is not part of the graph: " + node;
            assert (!this.closed.contains(node) && !this.goalTester.isGoal(node));
            this.logger.debug("Expanding next node {}", node);
            boolean closeNodeAfterwards = false;
            boolean nodeAdded = false;
            if (this.isSingleNodeSuccessorGenerator) {
                SingleSuccessorGenerator cGen = (SingleSuccessorGenerator)this.gen;
                for (int i = 0; i < 3 && !nodeAdded; ++i) {
                    assert (this.exploredGraph.isGraphSane());
                    NodeExpansionDescription successor = cGen.generateSuccessor(node, this.random.nextInt(Integer.MAX_VALUE));
                    assert (this.exploredGraph.isGraphSane());
                    if (successor == null) continue;
                    assert (this.exploredGraph.hasItem(successor.getFrom())) : "Parent node of successor is not part of the explored graph.";
                    if (this.exploredGraph.getSuccessors(node).contains(successor.getTo())) {
                        this.logger.trace("Single node evaluator has generated a known successor. Generating another candidate.");
                        continue;
                    }
                    assert (!this.exploredGraph.hasItem(successor.getTo())) : "Successor " + successor.getTo() + " has been reached before. Predecessors of that node are: " + this.exploredGraph.getPredecessors(successor.getTo());
                    this.addNodeToLocalModel(successor.getFrom(), successor.getTo());
                    nodeAdded = true;
                }
                closeNodeAfterwards = cGen.allSuccessorsComputed(node);
            }
            if (!nodeAdded) {
                long start = System.currentTimeMillis();
                List<NodeExpansionDescription<N, A>> successors = this.gen.generateSuccessors(node);
                this.logger.debug("Identified {} successor(s) in {}ms, which are now appended.", (Object)successors.size(), (Object)(System.currentTimeMillis() - start));
                Set knownSuccessors = this.exploredGraph.getSuccessors(node);
                long lastTerminationCheck = 0L;
                for (NodeExpansionDescription<N, A> successor : successors) {
                    if (System.currentTimeMillis() - lastTerminationCheck > 100L) {
                        this.checkAndConductTermination();
                        lastTerminationCheck = System.currentTimeMillis();
                    }
                    if (knownSuccessors.contains(successor.getTo())) continue;
                    this.addNodeToLocalModel(successor.getFrom(), successor.getTo());
                }
                this.logger.debug("{} nodes have been added to the local model. Now checking prioritization.", (Object)successors.size());
                if (!this.exploredGraph.getSuccessors(node).isEmpty() && this.prioritizedNodes.contains(node)) {
                    this.prioritizedNodes.remove(node);
                    this.updateExhaustedAndPrioritizedState(node);
                }
                closeNodeAfterwards = true;
            }
            if (closeNodeAfterwards) {
                if (!this.prioritizedNodes.contains(node)) {
                    this.post(new NodeTypeSwitchEvent(this.getId(), node, "or_closed"));
                }
                this.closed.add(node);
            }
            this.logger.debug("Finished node expansion. Sizes of explored graph and CLOSED are {} and {} respectively.", (Object)this.exploredGraph.getItems().size(), (Object)this.closed.size());
        }
    }

    private void addNodeToLocalModel(N from, N to) {
        boolean isPrioritized;
        assert (this.exploredGraph.isGraphSane());
        assert (from != null);
        assert (to != null);
        assert (!this.exploredGraph.hasItem(to));
        assert (this.exploredGraph.hasItem(from));
        this.exploredGraph.addItem(to);
        assert (this.exploredGraph.hasItem(to));
        assert (this.exploredGraph.isGraphSane());
        boolean bl = isPrioritized = this.priorityPredicate != null && this.priorityPredicate.test(to);
        if (isPrioritized) {
            this.prioritizedNodes.add(to);
        }
        this.exploredGraph.addEdge(from, to);
        boolean isGoalNode = this.goalTester.isGoal(to);
        if (isGoalNode) {
            // empty if block
        }
        this.post(new NodeAddedEvent(this.getId(), from, to, isGoalNode ? "or_solution" : (isPrioritized ? "or_prioritized" : "or_open")));
    }

    public AlgorithmEvent nextWithException() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException, AlgorithmException {
        try {
            this.registerActiveThread();
            this.logger.debug("Starting next algorithm step.");
            assert (this.exploredGraph.isGraphSane());
            switch (this.getState()) {
                case created: {
                    this.post(new GraphInitializedEvent(this.getId(), this.root));
                    this.logger.info("Starting random search ...");
                    assert (this.exploredGraph.isGraphSane());
                    AlgorithmInitializedEvent algorithmInitializedEvent = this.activate();
                    return algorithmInitializedEvent;
                }
                case active: {
                    SearchGraphPath<N, A> drawnPath = null;
                    drawnPath = this.nextSolutionUnderNode(this.root);
                    if (drawnPath == null) {
                        this.logger.info("Drew NULL path, terminating");
                        AlgorithmFinishedEvent algorithmFinishedEvent = this.terminate();
                        return algorithmFinishedEvent;
                    }
                    assert (!drawnPath.getNodes().isEmpty() && this.goalTester.isGoal(drawnPath.getNodes().get(drawnPath.getNodes().size() - 1))) : "The drawn path is empty or its leaf node is not a goal!";
                    this.logger.info("Drew path of length {}. Posting this event. For more details on the path, enable TRACE", (Object)drawnPath.getNodes().size());
                    this.logger.trace("The drawn path is {}", drawnPath);
                    GraphSearchSolutionCandidateFoundEvent event = new GraphSearchSolutionCandidateFoundEvent(this.getId(), drawnPath);
                    this.logger.info("Identified new solution. Event is {}", event);
                    this.post((Object)event);
                    assert (this.exploredGraph.isGraphSane());
                    GraphSearchSolutionCandidateFoundEvent graphSearchSolutionCandidateFoundEvent = event;
                    return graphSearchSolutionCandidateFoundEvent;
                }
            }
            try {
                throw new IllegalStateException("Cannot do anything in state " + this.getState());
            }
            catch (InterruptedException e) {
                if (this.hasThreadBeenInterruptedDuringShutdown(Thread.currentThread())) {
                    this.checkTermination(false);
                    assert (false) : "The thread has been interrupted due to shutdown but apparently no stopping criterion is satisfied!";
                    throw new AlgorithmException("This part should never be reached!");
                }
                throw e;
            }
        }
        finally {
            this.unregisterActiveThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean knowsNode(N node) {
        Graph<N> graph = this.exploredGraph;
        synchronized (graph) {
            return this.exploredGraph.getItems().contains(node);
        }
    }

    public void appendPathToNode(List<N> nodes) {
        N parent = null;
        for (N node : nodes) {
            if (!this.exploredGraph.getItems().contains(node)) {
                this.addNodeToLocalModel(parent, node);
            }
            parent = node;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchGraphPath<N, A> nextSolutionUnderNode(N node) throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException {
        this.logger.info("Looking for next solution under node {}. Remaining time is {}.", node, (Object)this.getRemainingTimeToDeadline());
        this.checkAndConductTermination();
        assert (this.exploredGraph.isGraphSane());
        if (this.exhausted.contains(node)) {
            return null;
        }
        ArrayList<N> path = new ArrayList<N>();
        path.add(node);
        Object head = node;
        Graph<N> graph = this.exploredGraph;
        synchronized (graph) {
            while (!this.goalTester.isGoal(head)) {
                this.checkAndConductTermination();
                assert (this.checkThatNodeExistsInExploredGraph(head));
                assert (this.exploredGraph.isGraphSane());
                if (!this.closed.contains(head)) {
                    this.expandNode(head);
                }
                List successors = this.exploredGraph.getSuccessors(head).stream().filter(n -> !this.exhausted.contains(n)).collect(Collectors.toList());
                assert (this.exploredGraph.getSuccessors(head).stream().filter(n -> !this.exploredGraph.hasItem(n)).collect(Collectors.toList()).isEmpty()) : "Corrupt exploration graph: Some successors cannot be found again in the graph: " + this.exploredGraph.getSuccessors(head).stream().filter(n -> !this.exploredGraph.hasItem(n)).collect(Collectors.toList());
                if (successors.isEmpty()) {
                    this.exhausted.add(head);
                    this.prioritizedNodes.remove(head);
                    path.remove(head);
                    if (path.isEmpty()) {
                        return null;
                    }
                    head = path.get(path.size() - 1);
                    this.logger.trace("Detected a dead-end. Stepping back to parent {}", head);
                    continue;
                }
                assert (SetUtil.intersection(this.exhausted, this.prioritizedNodes).isEmpty()) : "There are nodes that are both exhausted and prioritized, which must not be the case:" + SetUtil.intersection(this.exhausted, this.prioritizedNodes).stream().map(n -> "\n\t" + n).collect(Collectors.joining());
                Collection prioritizedSuccessors = SetUtil.intersection(successors, this.prioritizedNodes);
                if (!prioritizedSuccessors.isEmpty()) {
                    head = prioritizedSuccessors.iterator().next();
                } else {
                    int n2 = successors.size();
                    assert (n2 != 0) : "Ended up in a situation where only exhausted nodes can be chosen.";
                    int k = this.random.nextInt(n2);
                    Object tmpHead = head = successors.get(k);
                    assert (!path.contains(head)) : "Going in circles ... " + path.stream().map(pn -> "\n\t[" + (pn.equals(tmpHead) ? "*" : " ") + "]" + pn.toString()).collect(Collectors.joining()) + "\n\t[*]" + head;
                    this.logger.trace("Selected {} as new head.", head);
                    assert (this.checkThatNodeExistsInExploredGraph(head));
                }
                path.add(head);
            }
        }
        this.logger.trace("Head node {} has been exhausted.", head);
        this.exhausted.add(head);
        this.prioritizedNodes.remove(head);
        this.updateExhaustedAndPrioritizedState(head);
        return head == this.root ? null : new SearchGraphPath(path, null);
    }

    private boolean checkThatNodeExistsInExploredGraph(N node) {
        assert (this.exploredGraph.hasItem(node)) : "Head node of random path is not in explored graph: " + node;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateExhaustedAndPrioritizedState(N node) {
        Graph<N> graph = this.exploredGraph;
        synchronized (graph) {
            Set predecessors;
            Object current = node;
            while (!(predecessors = this.exploredGraph.getPredecessors(current)).isEmpty()) {
                boolean currentIsCompletelyExpanded;
                assert (predecessors.size() == 1);
                current = predecessors.iterator().next();
                boolean bl = currentIsCompletelyExpanded = !this.isSingleNodeSuccessorGenerator || ((SingleSuccessorGenerator)this.gen).allSuccessorsComputed(current);
                if (!currentIsCompletelyExpanded) {
                    this.logger.trace("Leaving update routine at node {}, which has not been expanded completely.", current);
                    return;
                }
                boolean currentIsPrioritized = this.prioritizedNodes.contains(current);
                boolean allChildrenExhausted = true;
                boolean allPrioritizedChildrenExhausted = true;
                for (Object successor : this.exploredGraph.getSuccessors(current)) {
                    if (this.exhausted.contains(successor)) continue;
                    allChildrenExhausted = false;
                    if (currentIsPrioritized && this.prioritizedNodes.contains(successor)) {
                        allPrioritizedChildrenExhausted = false;
                        break;
                    }
                    if (currentIsPrioritized) continue;
                    break;
                }
                if (allChildrenExhausted) {
                    this.logger.trace("Update state of {} as being exhausted since all its children have been exhausted.", current);
                    this.exhausted.add(current);
                }
                if (!currentIsPrioritized || !allPrioritizedChildrenExhausted) continue;
                int sizeBefore = this.prioritizedNodes.size();
                this.prioritizedNodes.remove(current);
                this.post(new NodeTypeSwitchEvent(this.getId(), current, "or_closed"));
                int sizeAfter = this.prioritizedNodes.size();
                assert (sizeAfter == sizeBefore - 1);
            }
        }
    }

    public Graph<N> getExploredGraph() {
        return this.exploredGraph;
    }

    @Override
    public void setLoggerName(String name) {
        this.logger.info("Switch logger name from {} to {}", (Object)this.loggerName, (Object)name);
        this.loggerName = name;
        this.logger = LoggerFactory.getLogger((String)this.loggerName);
        if (this.getGraphGenerator() instanceof ILoggingCustomizable) {
            ((ILoggingCustomizable)this.getGraphGenerator()).setLoggerName(name + ".graphgen");
        }
        this.logger.info("Switched logger name to {}", (Object)this.loggerName);
        super.setLoggerName(this.loggerName + "._algorithm");
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }
}

