/*
 * Decompiled with CFR 0.152.
 */
package jaicore.search.algorithms.standard.rstar;

import ai.libs.jaicore.basic.Cancelable;
import ai.libs.jaicore.basic.ILoggingCustomizable;
import ai.libs.jaicore.basic.IMetric;
import ai.libs.jaicore.basic.TimeOut;
import ai.libs.jaicore.basic.algorithm.AlgorithmExecutionCanceledException;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmFinishedEvent;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmInitializedEvent;
import ai.libs.jaicore.basic.algorithm.events.SolutionCandidateFoundEvent;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmTimeoutedException;
import ai.libs.jaicore.basic.sets.SetUtil;
import jaicore.search.algorithms.standard.astar.AStar;
import jaicore.search.algorithms.standard.bestfirst.events.EvaluatedSearchSolutionCandidateFoundEvent;
import jaicore.search.algorithms.standard.bestfirst.events.NodeExpansionCompletedEvent;
import jaicore.search.algorithms.standard.bestfirst.exceptions.NodeEvaluationException;
import jaicore.search.algorithms.standard.bestfirst.nodeevaluation.INodeEvaluator;
import jaicore.search.algorithms.standard.rstar.GammaNode;
import jaicore.search.algorithms.standard.rstar.RStarK;
import jaicore.search.algorithms.standard.rstar.SubPathGraphGenerator;
import jaicore.search.core.interfaces.AOptimalPathInORGraphSearch;
import jaicore.search.model.other.EvaluatedSearchGraphPath;
import jaicore.search.model.other.SearchGraphPath;
import jaicore.search.model.travesaltree.Node;
import jaicore.search.probleminputs.GraphSearchWithNumberBasedAdditivePathEvaluation;
import jaicore.search.probleminputs.GraphSearchWithNumberBasedAdditivePathEvaluationAndSubPathHeuristic;
import jaicore.search.structure.graphgenerator.MultipleRootGenerator;
import jaicore.search.structure.graphgenerator.NodeGoalTester;
import jaicore.search.structure.graphgenerator.RootGenerator;
import jaicore.search.structure.graphgenerator.SingleRootGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RStar<T, A>
extends AOptimalPathInORGraphSearch<GraphSearchWithNumberBasedAdditivePathEvaluationAndSubPathHeuristic<T, A>, T, A, Double> {
    protected PriorityQueue<GammaNode<T>> open = new PriorityQueue((n1, n2) -> ((RStarK)n1.getInternalLabel()).compareTo((RStarK)n2.getInternalLabel()));
    protected ArrayList<GammaNode<T>> closed = new ArrayList();
    private final INodeEvaluator<T, Double> h;
    private final GraphSearchWithNumberBasedAdditivePathEvaluationAndSubPathHeuristic.PathCostEstimator<T> hPath;
    private final int k;
    protected final double w;
    private final double delta;
    private final IMetric<T> metricOverStates;
    private GammaNode<T> bestSeenGoalNode;
    private final Map<SetUtil.Pair<GammaNode<T>, GammaNode<T>>, SearchGraphPath<T, A>> externalPathsBetweenGammaNodes = new HashMap<SetUtil.Pair<GammaNode<T>, GammaNode<T>>, SearchGraphPath<T, A>>();
    private List<SolutionCandidateFoundEvent<EvaluatedSearchGraphPath<T, A, Double>>> unreturnedSolutionEvents = new LinkedList<SolutionCandidateFoundEvent<EvaluatedSearchGraphPath<T, A, Double>>>();
    private Collection<AStar<T, A>> activeAStarSubroutines = new ArrayList<AStar<T, A>>();
    private Logger logger = LoggerFactory.getLogger(RStar.class);

    public RStar(GraphSearchWithNumberBasedAdditivePathEvaluationAndSubPathHeuristic<T, A> problem, double w, int k, double delta) {
        super(problem);
        this.h = ((GraphSearchWithNumberBasedAdditivePathEvaluation.FComputer)((GraphSearchWithNumberBasedAdditivePathEvaluationAndSubPathHeuristic)this.getInput()).getNodeEvaluator()).getH();
        this.hPath = ((GraphSearchWithNumberBasedAdditivePathEvaluationAndSubPathHeuristic.SubPathEvaluationBasedFComputer)((GraphSearchWithNumberBasedAdditivePathEvaluationAndSubPathHeuristic)this.getInput()).getNodeEvaluator()).gethPath();
        this.w = w;
        this.k = k;
        this.metricOverStates = ((GraphSearchWithNumberBasedAdditivePathEvaluationAndSubPathHeuristic)this.getInput()).getMetricOverStates();
        this.delta = delta;
    }

    private void updateState(GammaNode<T> n) throws NodeEvaluationException, InterruptedException {
        if (n.getG() > this.w * this.h.f(n) || (n.getParent() == null || !this.isPathRealizationKnownForAbstractEdgeToNode(n)) && n.getAvoid()) {
            n.setInternalLabel(new RStarK(true, n.getG() + this.w * this.h.f(n)));
        } else {
            n.setInternalLabel(new RStarK(false, n.getG() + this.w * this.h.f(n)));
        }
        this.open.add(n);
    }

    private void reevaluateState(GammaNode<T> n) throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException, AlgorithmException {
        this.logger.debug("Reevaluating node {}", n);
        if (n.getParent() == null) {
            throw new IllegalArgumentException("Can only re-evaluate nodes that have a parent!");
        }
        SubPathGraphGenerator subProblemGraphGenerator = new SubPathGraphGenerator(((GraphSearchWithNumberBasedAdditivePathEvaluationAndSubPathHeuristic)this.getInput()).getGraphGenerator(), n.getParent().getPoint(), n.getPoint());
        AStar astar = new AStar(new GraphSearchWithNumberBasedAdditivePathEvaluation(subProblemGraphGenerator, (GraphSearchWithNumberBasedAdditivePathEvaluation.FComputer)((GraphSearchWithNumberBasedAdditivePathEvaluationAndSubPathHeuristic)this.getInput()).getNodeEvaluator()));
        astar.setLoggerName(this.getLoggerName() + ".astar");
        astar.setTimeout(new TimeOut(this.getRemainingTimeToDeadline().milliseconds(), TimeUnit.MILLISECONDS));
        this.logger.trace("Invoking AStar with root {} and only goal node {}", n.getParent().getPoint(), n.getPoint());
        this.activeAStarSubroutines.add(astar);
        EvaluatedSearchGraphPath optimalPath = (EvaluatedSearchGraphPath)astar.call();
        this.checkAndConductTermination();
        this.activeAStarSubroutines.remove(astar);
        this.externalPathsBetweenGammaNodes.put(new SetUtil.Pair((Object)n.getParent(), n), optimalPath);
        double bestKnownValueFromParentToNode = optimalPath != null ? (Double)optimalPath.getScore() : Double.MAX_VALUE;
        ((GammaNode)n.getParent()).cLow.put(n, bestKnownValueFromParentToNode);
        if (!n.isGoal() && (optimalPath == null || ((GammaNode)n.getParent()).getG() + bestKnownValueFromParentToNode > this.w * this.hPath.h(n.getParent(), n))) {
            n.setParent(this.argminCostToStateOverPredecessors(n));
            n.setAvoid(true);
        }
        n.setG(((GammaNode)n.getParent()).getG() + ((GammaNode)n.getParent()).cLow.get(n));
        if (!n.isGoal()) {
            this.updateState(n);
        }
    }

    public AlgorithmEvent nextWithException() throws InterruptedException, AlgorithmException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException {
        try {
            this.registerActiveThread();
            this.logger.debug("Performing next step. Current state is {}", (Object)this.getState());
            this.checkAndConductTermination();
            switch (this.getState()) {
                case created: {
                    Object internalRoot;
                    AlgorithmInitializedEvent initializationEvent = this.activate();
                    RootGenerator rootGenerator = ((GraphSearchWithNumberBasedAdditivePathEvaluationAndSubPathHeuristic)this.getInput()).getGraphGenerator().getRootGenerator();
                    if (rootGenerator instanceof MultipleRootGenerator) {
                        for (Object root : ((MultipleRootGenerator)rootGenerator).getRoots()) {
                            GammaNode internalRoot2 = new GammaNode(root);
                            internalRoot2.setInternalLabel(new RStarK(false, this.w * this.h.f(internalRoot2)));
                            internalRoot2.setG(0.0);
                            this.open.add(internalRoot2);
                        }
                    } else if (rootGenerator instanceof SingleRootGenerator) {
                        internalRoot = new GammaNode(((SingleRootGenerator)rootGenerator).getRoot());
                        ((Node)internalRoot).setInternalLabel(new RStarK(false, this.w * this.h.f((Node<T, ?>)internalRoot)));
                        ((GammaNode)internalRoot).setG(0.0);
                        this.open.add((GammaNode<T>)internalRoot);
                    } else assert (false) : "Only MultipleRootGenerator or SingleRootGenerators allowed.";
                    assert (!this.open.isEmpty()) : "OPEN must not be empty after initialization!";
                    internalRoot = initializationEvent;
                    return internalRoot;
                }
                case active: {
                    if (!this.unreturnedSolutionEvents.isEmpty()) {
                        this.logger.info("Returning known solution from solution cache!");
                        AlgorithmEvent internalRoot = (AlgorithmEvent)this.unreturnedSolutionEvents.remove(0);
                        return internalRoot;
                    }
                    GammaNode<T> n = this.open.poll();
                    this.logger.debug("Selected {} for expansion.", n);
                    if (n == null || this.bestSeenGoalNode != null && ((RStarK)n.getInternalLabel()).compareTo((RStarK)this.bestSeenGoalNode.getInternalLabel()) > 0) {
                        this.logger.info("Terminating RStar.");
                        AlgorithmFinishedEvent root = this.terminate();
                        return root;
                    }
                    if (n.getParent() != null && !this.isPathRealizationKnownForAbstractEdgeToNode(n)) {
                        this.reevaluateState(n);
                        this.logger.debug("Putting node {} on OPEN again", n);
                        this.open.add(n);
                    } else {
                        this.closed.add(n);
                        this.logger.debug("Starting generation of successors of {}", n);
                        Collection<GammaNode<T>> successors = this.generateGammaSuccessors(n);
                        this.logger.debug("Generated {} successors.", (Object)successors.size());
                        for (GammaNode<T> n_ : successors) {
                            boolean isNewNode;
                            n.cLow.put(n_, this.hPath.h(n, n_));
                            boolean bl = isNewNode = n_.getParent() == null;
                            if (!isNewNode && !(n.getG() + n.cLow.get(n_) < n_.getG())) continue;
                            n_.setG(n.getG() + n.cLow.get(n_));
                            n_.setParent(n);
                            this.updateState(n_);
                            if (!isNewNode) continue;
                            this.logger.debug("Adding new node {} to OPEN.", n_);
                            this.open.add(n_);
                        }
                    }
                    NodeExpansionCompletedEvent nodeExpansionCompletedEvent = new NodeExpansionCompletedEvent(this.getId(), n.getPoint());
                    return nodeExpansionCompletedEvent;
                }
            }
            throw new IllegalStateException("Cannot do anything in state " + this.getState());
        }
        finally {
            this.unregisterActiveThread();
        }
    }

    private boolean isPathRealizationKnownForAbstractEdgeToNode(GammaNode<T> node) {
        return this.externalPathsBetweenGammaNodes.containsKey(new SetUtil.Pair((Object)node.getParent(), node));
    }

    private EvaluatedSearchGraphPath<T, A, Double> getFullExternalPath(GammaNode<T> n) {
        ArrayList<T> nodes = new ArrayList<T>();
        ArrayList<A> edges = new ArrayList<A>();
        Node current = n;
        nodes.add(n.getPoint());
        while (current.getParent() != null) {
            SetUtil.Pair pair = new SetUtil.Pair((Object)current.getParent(), current);
            assert (this.externalPathsBetweenGammaNodes.containsKey(pair));
            SearchGraphPath<T, A> externalPath = this.externalPathsBetweenGammaNodes.get(pair);
            nodes.addAll(0, externalPath.getNodes());
            List<A> concreteEdges = externalPath.getEdges();
            if (concreteEdges == null) {
                concreteEdges = new ArrayList<A>();
                int m = externalPath.getNodes().size();
                for (int i = 0; i < m; ++i) {
                    concreteEdges.add(null);
                }
            }
            edges.addAll(0, concreteEdges);
            current = current.getParent();
        }
        return new EvaluatedSearchGraphPath(nodes, edges, n.getG());
    }

    private GammaNode<T> argminCostToStateOverPredecessors(GammaNode<T> n) {
        GammaNode<T> argmin = null;
        for (GammaNode<T> p : n.getPredecessors()) {
            if (argmin != null && !(p.getG() + p.cLow.get(n) < argmin.getG() + argmin.cLow.get(n))) continue;
            argmin = p;
        }
        return argmin;
    }

    private Collection<GammaNode<T>> generateGammaSuccessors(GammaNode<T> n) throws InterruptedException, AlgorithmTimeoutedException, AlgorithmException, AlgorithmExecutionCanceledException {
        this.logger.trace("Invoking distant successor generator timeout-aware.");
        List randomDistantSuccessors = (List)this.computeTimeoutAware(() -> ((GraphSearchWithNumberBasedAdditivePathEvaluationAndSubPathHeuristic)this.getInput()).getDistantSuccessorGenerator().getDistantSuccessors(n.getPoint(), this.k, this.metricOverStates, this.delta), "Computing distant successors", true);
        assert (randomDistantSuccessors.size() == new HashSet(randomDistantSuccessors).size()) : "Distant successor generator has created the same successor ar least twice: \n\t " + SetUtil.getMultiplyContainedItems((List)randomDistantSuccessors).stream().map(Object::toString).collect(Collectors.joining("\n\t"));
        this.logger.trace("Distant successor generator generated {}/{} successors.", (Object)randomDistantSuccessors.size(), (Object)this.k);
        randomDistantSuccessors.removeIf(childNode -> this.closed.stream().anyMatch(closedNode -> closedNode.getPoint().equals(childNode)));
        this.logger.trace("{} successors are still considered after having removed nodes that already are on CLOSED, which holds {} item(s).", (Object)randomDistantSuccessors.size(), (Object)this.closed.size());
        ArrayList<GammaNode<T>> succWithoutClosed = new ArrayList<GammaNode<T>>();
        for (Object childNode2 : randomDistantSuccessors) {
            GammaNode gammaNodeForThisChild;
            Optional<GammaNode> representantOnOpen = this.open.stream().filter(closedNode -> closedNode.getPoint().equals(childNode2)).findFirst();
            if (representantOnOpen.isPresent()) {
                gammaNodeForThisChild = representantOnOpen.get();
            } else {
                gammaNodeForThisChild = new GammaNode(childNode2);
                gammaNodeForThisChild.setGoal(((NodeGoalTester)this.getGraphGenerator().getGoalTester()).isGoal(childNode2));
            }
            if (gammaNodeForThisChild.isGoal()) {
                this.logger.info("Found new solution. Adding it to the solution set.");
                if (this.bestSeenGoalNode == null || this.bestSeenGoalNode.getG() > n.getG()) {
                    this.bestSeenGoalNode = n;
                    this.updateBestSeenSolution(this.getFullExternalPath(n));
                }
                EvaluatedSearchSolutionCandidateFoundEvent solutionEvent = new EvaluatedSearchSolutionCandidateFoundEvent(this.getId(), this.getFullExternalPath(gammaNodeForThisChild));
                this.post((Object)solutionEvent);
                this.unreturnedSolutionEvents.add((SolutionCandidateFoundEvent<EvaluatedSearchGraphPath<T, A, Double>>)solutionEvent);
            }
            gammaNodeForThisChild.addPredecessor(n);
            succWithoutClosed.add(gammaNodeForThisChild);
        }
        return succWithoutClosed;
    }

    @Override
    public void setLoggerName(String name) {
        GraphSearchWithNumberBasedAdditivePathEvaluationAndSubPathHeuristic.DistantSuccessorGenerator distantSuccessorGenerator;
        this.logger = LoggerFactory.getLogger((String)name);
        super.setLoggerName(name + "._orgraphsearch");
        if (this.getGraphGenerator() instanceof ILoggingCustomizable) {
            ((ILoggingCustomizable)this.getGraphGenerator()).setLoggerName(name + ".graphgenerator");
        }
        if ((distantSuccessorGenerator = ((GraphSearchWithNumberBasedAdditivePathEvaluationAndSubPathHeuristic)this.getInput()).getDistantSuccessorGenerator()) instanceof ILoggingCustomizable) {
            ((ILoggingCustomizable)distantSuccessorGenerator).setLoggerName(name + ".distantsuccessorgenerator");
        }
    }

    @Override
    public String getLoggerName() {
        return this.logger.getName();
    }

    public void cancel() {
        this.logger.info("RStar received cancel. Now invoking shutdown routing and cancel the AStar subroutines.");
        super.cancel();
        this.activeAStarSubroutines.forEach(Cancelable::cancel);
    }
}

