/*
 * Decompiled with CFR 0.152.
 */
package jaicore.search.algorithms.standard.rstar;

import jaicore.search.algorithms.standard.bestfirst.nodeevaluation.INodeEvaluator;
import jaicore.search.algorithms.standard.rstar.RStar;
import jaicore.search.core.interfaces.StandardORGraphSearchFactory;
import jaicore.search.model.other.EvaluatedSearchGraphPath;
import jaicore.search.probleminputs.GraphSearchWithNumberBasedAdditivePathEvaluationAndSubPathHeuristic;

public class RStarFactory<T, A>
extends StandardORGraphSearchFactory<GraphSearchWithNumberBasedAdditivePathEvaluationAndSubPathHeuristic<T, A>, EvaluatedSearchGraphPath<T, A, Double>, T, A, Double> {
    private int timeoutForFInMS;
    private INodeEvaluator<T, Double> timeoutEvaluator;
    private String loggerName;
    private double w = 1.0;
    private int k = 3;
    private double delta = 0.0;

    public RStarFactory() {
    }

    public RStarFactory(int timeoutForFInMS) {
        this();
        if (timeoutForFInMS > 0) {
            this.timeoutForFInMS = timeoutForFInMS;
        }
    }

    public double getW() {
        return this.w;
    }

    public void setW(double w) {
        this.w = w;
    }

    public int getK() {
        return this.k;
    }

    public void setK(int k) {
        this.k = k;
    }

    public double getDelta() {
        return this.delta;
    }

    public void setDelta(double delta) {
        this.delta = delta;
    }

    @Override
    public RStar<T, A> getAlgorithm() {
        return this.getAlgorithm((GraphSearchWithNumberBasedAdditivePathEvaluationAndSubPathHeuristic)this.getInput());
    }

    public RStar<T, A> getAlgorithm(GraphSearchWithNumberBasedAdditivePathEvaluationAndSubPathHeuristic<T, A> input) {
        RStar<T, A> search = new RStar<T, A>(input, this.w, this.k, this.delta);
        if (this.loggerName != null && this.loggerName.length() > 0) {
            search.setLoggerName(this.loggerName);
        }
        return search;
    }

    public void setTimeoutForFComputation(int timeoutInMS, INodeEvaluator<T, Double> timeoutEvaluator) {
        this.timeoutForFInMS = timeoutInMS;
        this.timeoutEvaluator = timeoutEvaluator;
    }

    public int getTimeoutForFInMS() {
        return this.timeoutForFInMS;
    }

    public INodeEvaluator<T, Double> getTimeoutEvaluator() {
        return this.timeoutEvaluator;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }
}

