/*
 * Decompiled with CFR 0.152.
 */
package jaicore.search.algorithms.standard.uncertainty;

import jaicore.search.algorithms.standard.uncertainty.IUncertaintySource;
import jaicore.search.model.travesaltree.Node;
import java.util.List;

public class BasicUncertaintySource<T, V extends Comparable<V>>
implements IUncertaintySource<T, V> {
    @Override
    public double calculateUncertainty(Node<T, V> n, List<List<T>> simulationPaths, List<V> simulationEvaluations) {
        double uncertainty = 1.0;
        if (simulationPaths != null && !simulationPaths.isEmpty()) {
            T t = n.getPoint();
            double meanDepth = 0.0;
            for (List<T> list : simulationPaths) {
                if (!list.contains(t) || list.isEmpty()) continue;
                double post = 0.0;
                boolean startsCounting = false;
                for (T pe : list) {
                    if (startsCounting) {
                        post += 1.0;
                    }
                    if (!pe.equals(t)) continue;
                    startsCounting = true;
                }
                meanDepth += post / (double)list.size();
            }
            if (meanDepth != 0.0) {
                uncertainty = meanDepth / (double)simulationPaths.size();
            }
        }
        if (simulationEvaluations != null && simulationEvaluations.size() > 1 && simulationEvaluations.get(0) instanceof Double) {
            double mean = 0.0;
            double sampleVariance = 0.0;
            for (Comparable f : simulationEvaluations) {
                mean += ((Double)f).doubleValue();
            }
            mean /= (double)simulationEvaluations.size();
            for (Comparable f : simulationEvaluations) {
                sampleVariance += ((Double)f - mean) * ((Double)f - mean);
            }
            sampleVariance = Math.sqrt(sampleVariance / (double)(simulationEvaluations.size() - 1));
            if (mean != 0.0) {
                double d = sampleVariance / mean;
                d = Math.max(Math.abs(d), 1.0);
                uncertainty *= d;
            }
        }
        return uncertainty;
    }
}

