/*
 * Decompiled with CFR 0.152.
 */
package jaicore.search.algorithms.standard.uncertainty;

import jaicore.search.algorithms.standard.uncertainty.ISolutionDistanceMetric;
import jaicore.search.algorithms.standard.uncertainty.paretosearch.FirstInFirstOutComparator;
import jaicore.search.model.travesaltree.Node;
import java.util.Comparator;

public class OversearchAvoidanceConfig<N, V extends Comparable<V>> {
    private OversearchAvoidanceMode oversearchAvoidanceMode;
    private long seed;
    private boolean adjustPhaseLengthsDynamically = false;
    private long timeout;
    private int interval = 50;
    private double exploitationScoreThreshold = 0.1;
    private double explorationUncertaintyThreshold = 0.1;
    private double minimumSolutionDistanceForExploration = 0.0;
    private ISolutionDistanceMetric<N> solutionDistanceMetric = (s1, s2) -> 1.0;
    private Comparator<Node<N, V>> paretoComparator = new FirstInFirstOutComparator<N, V>();

    public OversearchAvoidanceConfig(OversearchAvoidanceMode mode, long seed) {
        this.oversearchAvoidanceMode = mode;
        this.seed = seed;
    }

    public OversearchAvoidanceMode getOversearchAvoidanceMode() {
        return this.oversearchAvoidanceMode;
    }

    public ISolutionDistanceMetric<N> getSolutionDistanceMetric() {
        return this.solutionDistanceMetric;
    }

    public OversearchAvoidanceConfig<N, V> setSolutionDistanceMetric(ISolutionDistanceMetric<N> solutionDistanceMetric) {
        this.solutionDistanceMetric = solutionDistanceMetric;
        return this;
    }

    public boolean getAdjustPhaseLengthsDynamically() {
        return this.adjustPhaseLengthsDynamically;
    }

    public void activateDynamicPhaseLengthsAdjustment(long timeout) {
        this.adjustPhaseLengthsDynamically = true;
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public double getExploitationScoreThreshold() {
        return this.exploitationScoreThreshold;
    }

    public void setExploitationScoreThreshold(double exploitationScoreThreshold) {
        this.exploitationScoreThreshold = exploitationScoreThreshold;
    }

    public double getExplorationUncertaintyThreshold() {
        return this.explorationUncertaintyThreshold;
    }

    public void setExplorationUncertaintyThreshold(double explorationUncertaintyThreshold) {
        this.explorationUncertaintyThreshold = explorationUncertaintyThreshold;
    }

    public double getMinimumSolutionDistanceForExploration() {
        return this.minimumSolutionDistanceForExploration;
    }

    public void setMinimumSolutionDistanceForExploration(double minimumSolutionDistanceForExploration) {
        this.minimumSolutionDistanceForExploration = minimumSolutionDistanceForExploration;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setParetoComparator(Comparator<Node<N, V>> paretoComparator) {
        this.paretoComparator = paretoComparator;
    }

    public Comparator<Node<N, V>> getParetoComperator() {
        return this.paretoComparator;
    }

    public static enum OversearchAvoidanceMode {
        PARETO_FRONT_SELECTION,
        TWO_PHASE_SELECTION,
        NONE;

    }
}

