/*
 * Decompiled with CFR 0.152.
 */
package jaicore.search.algorithms.standard.uncertainty;

import jaicore.search.algorithms.standard.bestfirst.BestFirst;
import jaicore.search.algorithms.standard.bestfirst.BestFirstFactory;
import jaicore.search.algorithms.standard.bestfirst.nodeevaluation.IPotentiallyUncertaintyAnnotatingNodeEvaluator;
import jaicore.search.algorithms.standard.uncertainty.OversearchAvoidanceConfig;
import jaicore.search.algorithms.standard.uncertainty.explorationexploitationsearch.BasicClockModelPhaseLengthAdjuster;
import jaicore.search.algorithms.standard.uncertainty.explorationexploitationsearch.BasicExplorationCandidateSelector;
import jaicore.search.algorithms.standard.uncertainty.explorationexploitationsearch.IPhaseLengthAdjuster;
import jaicore.search.algorithms.standard.uncertainty.explorationexploitationsearch.UncertaintyExplorationOpenSelection;
import jaicore.search.algorithms.standard.uncertainty.paretosearch.ParetoSelection;
import jaicore.search.core.interfaces.IGraphSearch;
import jaicore.search.probleminputs.GraphSearchWithUncertaintyBasedSubpathEvaluationInput;
import java.util.PriorityQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UncertaintyORGraphSearchFactory<N, A, V extends Comparable<V>>
extends BestFirstFactory<GraphSearchWithUncertaintyBasedSubpathEvaluationInput<N, A, V>, N, A, V> {
    private static final Logger logger = LoggerFactory.getLogger(UncertaintyORGraphSearchFactory.class);
    private OversearchAvoidanceConfig<N, V> oversearchAvoidanceConfig;

    @Override
    public BestFirst<GraphSearchWithUncertaintyBasedSubpathEvaluationInput<N, A, V>, N, A, V> getAlgorithm() {
        if (this.oversearchAvoidanceConfig == null) {
            throw new IllegalStateException("Uncertainty Config has not been set yet.");
        }
        IGraphSearch search = super.getAlgorithm();
        if (!(((BestFirst)search).getNodeEvaluator() instanceof IPotentiallyUncertaintyAnnotatingNodeEvaluator)) {
            throw new UnsupportedOperationException("Cannot create uncertainty based search with node evaluator " + ((BestFirst)search).getNodeEvaluator().getClass().getName() + ", which does not implement " + IPotentiallyUncertaintyAnnotatingNodeEvaluator.class.getName());
        }
        if (!((IPotentiallyUncertaintyAnnotatingNodeEvaluator)((BestFirst)search).getNodeEvaluator()).annotatesUncertainty()) {
            throw new UnsupportedOperationException("The given node evaluator supports uncertainty annotation, but it declares that it will not annotate uncertainty. Maybe no uncertainty source has been defined.");
        }
        switch (this.oversearchAvoidanceConfig.getOversearchAvoidanceMode()) {
            case NONE: {
                logger.warn("Usage of OversearchAvoidanceMode.NONE is deprecated! Use StandardBestFirst search instead.");
                break;
            }
            case TWO_PHASE_SELECTION: {
                if (this.oversearchAvoidanceConfig.getAdjustPhaseLengthsDynamically()) {
                    ((BestFirst)search).setOpen(new UncertaintyExplorationOpenSelection(this.oversearchAvoidanceConfig.getTimeout(), this.oversearchAvoidanceConfig.getInterval(), this.oversearchAvoidanceConfig.getExploitationScoreThreshold(), this.oversearchAvoidanceConfig.getExplorationUncertaintyThreshold(), new BasicClockModelPhaseLengthAdjuster(), this.oversearchAvoidanceConfig.getSolutionDistanceMetric(), new BasicExplorationCandidateSelector(this.oversearchAvoidanceConfig.getMinimumSolutionDistanceForExploration())));
                    break;
                }
                ((BestFirst)search).setOpen(new UncertaintyExplorationOpenSelection(this.oversearchAvoidanceConfig.getTimeout(), this.oversearchAvoidanceConfig.getInterval(), this.oversearchAvoidanceConfig.getExploitationScoreThreshold(), this.oversearchAvoidanceConfig.getExplorationUncertaintyThreshold(), new IPhaseLengthAdjuster(){

                    @Override
                    public int[] getInitialPhaseLengths(int interval) {
                        return new int[]{interval / 2, interval - interval / 2};
                    }

                    @Override
                    public int[] adjustPhaseLength(int currentExplorationLength, int currentExploitationLength, long passedTime, long timeout) {
                        return new int[]{currentExplorationLength, currentExploitationLength};
                    }
                }, this.oversearchAvoidanceConfig.getSolutionDistanceMetric(), new BasicExplorationCandidateSelector(this.oversearchAvoidanceConfig.getMinimumSolutionDistanceForExploration())));
                break;
            }
            case PARETO_FRONT_SELECTION: {
                PriorityQueue pareto = new PriorityQueue(this.oversearchAvoidanceConfig.getParetoComperator());
                ((BestFirst)search).setOpen(new ParetoSelection(pareto));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Mode " + (Object)((Object)this.oversearchAvoidanceConfig.getOversearchAvoidanceMode()) + " is currently not supported.");
            }
        }
        return search;
    }

    public OversearchAvoidanceConfig<N, V> getConfig() {
        return this.oversearchAvoidanceConfig;
    }

    public void setConfig(OversearchAvoidanceConfig<N, V> config) {
        this.oversearchAvoidanceConfig = config;
    }
}

