/*
 * Decompiled with CFR 0.152.
 */
package jaicore.search.algorithms.standard.uncertainty.explorationexploitationsearch;

import jaicore.search.algorithms.standard.uncertainty.ISolutionDistanceMetric;
import jaicore.search.algorithms.standard.uncertainty.explorationexploitationsearch.IExplorationCandidateSelector;
import jaicore.search.model.travesaltree.Node;
import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;

public class BasicExplorationCandidateSelector<T, V extends Comparable<V>>
implements IExplorationCandidateSelector<T, V> {
    private double minimumSolutionDistanceForExploration;

    public BasicExplorationCandidateSelector(double minimumSolutionDistanceForExploration) {
        this.minimumSolutionDistanceForExploration = minimumSolutionDistanceForExploration;
    }

    @Override
    public List<Node<T, V>> selectExplorationCandidates(Queue<Node<T, V>> allCandidates, Node<T, V> bestCandidate, ISolutionDistanceMetric<T> solutionDistanceMetric) {
        return allCandidates.stream().filter(n -> {
            if (bestCandidate == n) {
                return false;
            }
            double solutionDistance = solutionDistanceMetric.calculateSolutionDistance(n.externalPath(), bestCandidate.externalPath());
            return solutionDistance >= this.minimumSolutionDistanceForExploration;
        }).collect(Collectors.toList());
    }
}

