/*
 * Decompiled with CFR 0.152.
 */
package jaicore.search.algorithms.standard.uncertainty.explorationexploitationsearch;

import jaicore.search.algorithms.standard.uncertainty.ISolutionDistanceMetric;
import jaicore.search.algorithms.standard.uncertainty.explorationexploitationsearch.IExplorationCandidateSelector;
import jaicore.search.algorithms.standard.uncertainty.explorationexploitationsearch.IPhaseLengthAdjuster;
import jaicore.search.model.travesaltree.DefaultNodeComparator;
import jaicore.search.model.travesaltree.Node;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UncertaintyExplorationOpenSelection<T, V extends Comparable<V>>
implements Queue<Node<T, V>> {
    private static final Logger logger = LoggerFactory.getLogger(UncertaintyExplorationOpenSelection.class);
    private final Queue<Node<T, V>> exploitationOpen = new PriorityQueue<Node<T, V>>(new DefaultNodeComparator());
    private final PriorityQueue<Node<T, V>> explorationOpen = new PriorityQueue(new DefaultNodeComparator());
    private final ISolutionDistanceMetric<T> solutionDistanceMetric;
    private final IPhaseLengthAdjuster phaseLengthAdjuster;
    private final IExplorationCandidateSelector<T, V> candidateSelector;
    private int explorationPhaseLength;
    private int exploitationPhaseLength;
    double exploitationScoreThreshold;
    double explorationUncertaintyThreshold;
    private int selectedNodes = 0;
    private int exploredNodes = 0;
    private long timeout;
    private long startTime;
    private boolean exploring = true;

    public UncertaintyExplorationOpenSelection(long timeout, int phaseInterval, double exploitationScoreThreshold, double explorationUncertaintyThreshold, IPhaseLengthAdjuster phaseLengthAdjuster, ISolutionDistanceMetric<T> solutionDistanceMetric, IExplorationCandidateSelector<T, V> candidateSelector) {
        this.timeout = timeout;
        this.startTime = System.currentTimeMillis();
        int[] phaseLenghts = phaseLengthAdjuster.getInitialPhaseLengths(phaseInterval);
        assert (phaseLenghts.length == 2);
        this.explorationPhaseLength = phaseLenghts[0];
        this.exploitationPhaseLength = phaseLenghts[1];
        this.exploitationScoreThreshold = exploitationScoreThreshold;
        this.explorationUncertaintyThreshold = explorationUncertaintyThreshold;
        this.phaseLengthAdjuster = phaseLengthAdjuster;
        this.solutionDistanceMetric = solutionDistanceMetric;
        this.candidateSelector = candidateSelector;
    }

    @Override
    public Node<T, V> peek() {
        return this.selectCandidate(this.exploring);
    }

    private synchronized Node<T, V> selectCandidate(boolean isExploring) {
        Comparator comparator = (n1, n2) -> {
            try {
                Double u1 = (Double)n1.getAnnotation("uncertainty");
                Double u2 = (Double)n2.getAnnotation("uncertainty");
                Object v1 = n1.getInternalLabel();
                Object v2 = n2.getInternalLabel();
                if (isExploring) {
                    if (Math.abs(u1 - u2) <= this.explorationUncertaintyThreshold) {
                        return -1 * v1.compareTo(v2);
                    }
                    return Double.compare(u1, u2);
                }
                if (v1 instanceof Double && v2 instanceof Double) {
                    Double s1 = (Double)v1;
                    Double s2 = (Double)v2;
                    if (Math.abs(s1 - s2) <= this.exploitationScoreThreshold) {
                        return Double.compare(u1, u2);
                    }
                    return Double.compare(s1, s2);
                }
                if (v1 instanceof Double && v2 instanceof Double) {
                    Double s1 = (Double)v1;
                    Double s2 = (Double)v2;
                    if (Math.abs(s1 - s2) <= this.exploitationScoreThreshold) {
                        return Double.compare(u1, u2);
                    }
                    return v1.compareTo(v2);
                }
                return v1.compareTo(v2);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                return 0;
            }
        };
        if (isExploring) {
            return this.explorationOpen.stream().max(comparator).orElse(this.explorationOpen.peek());
        }
        return this.exploitationOpen.stream().min(comparator).orElse(this.exploitationOpen.peek());
    }

    private void adjustPhaseLengths(long passedTime) {
        int[] newPhaseLengths = this.phaseLengthAdjuster.adjustPhaseLength(this.explorationPhaseLength, this.exploitationPhaseLength, passedTime, this.timeout);
        assert (newPhaseLengths.length == 2);
        this.explorationPhaseLength = newPhaseLengths[0];
        this.exploitationPhaseLength = newPhaseLengths[1];
    }

    @Override
    public synchronized boolean add(Node<T, V> node) {
        if (node == null) {
            throw new IllegalArgumentException("Cannot add node NULL to OPEN");
        }
        if (!this.contains(node)) {
            throw new IllegalArgumentException("Node " + node + " is already there!");
        }
        if (this.exploring) {
            return this.explorationOpen.add(node);
        }
        return this.exploitationOpen.add(node);
    }

    @Override
    public synchronized boolean remove(Object node) {
        if (this.exploitationOpen.contains(node) && this.explorationOpen.contains(node)) {
            throw new IllegalStateException("A node (" + node + ") that is to be removed is in BOTH open lists!");
        }
        if (this.exploring) {
            return this.explorationOpen.remove(node) || this.exploitationOpen.remove(node);
        }
        return this.exploitationOpen.remove(node) || this.explorationOpen.remove(node);
    }

    @Override
    public synchronized boolean addAll(Collection<? extends Node<T, V>> arg0) {
        assert (this.exploitationOpen != null) : "Primary OPEN is NULL!";
        if (arg0 == null) {
            throw new IllegalArgumentException("Cannot add NULL collection");
        }
        if (this.exploring) {
            return this.explorationOpen.addAll(arg0);
        }
        return this.exploitationOpen.addAll(arg0);
    }

    @Override
    public synchronized void clear() {
        this.exploitationOpen.clear();
        this.explorationOpen.clear();
    }

    @Override
    public synchronized boolean contains(Object arg0) {
        return this.exploitationOpen.contains(arg0) || this.explorationOpen.contains(arg0);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        for (Object o : arg0) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.exploitationOpen.isEmpty() && this.explorationOpen.isEmpty();
    }

    @Override
    public Iterator<Node<T, V>> iterator() {
        return this.exploring ? this.explorationOpen.iterator() : this.exploitationOpen.iterator();
    }

    @Override
    public synchronized boolean removeAll(Collection<?> arg0) {
        return this.exploitationOpen.removeAll(arg0) && this.explorationOpen.removeAll(arg0);
    }

    @Override
    public synchronized boolean retainAll(Collection<?> arg0) {
        return this.exploitationOpen.retainAll(arg0) && this.explorationOpen.retainAll(arg0);
    }

    @Override
    public synchronized int size() {
        return this.exploitationOpen.size() + this.explorationOpen.size();
    }

    @Override
    public Object[] toArray() {
        return this.exploitationOpen.toArray();
    }

    @Override
    public <X> X[] toArray(X[] arg0) {
        return this.exploitationOpen.toArray();
    }

    @Override
    public Node<T, V> element() {
        return this.peek();
    }

    @Override
    public boolean offer(Node<T, V> e) {
        return this.add(e);
    }

    @Override
    public Node<T, V> poll() {
        return this.remove();
    }

    @Override
    public synchronized Node<T, V> remove() {
        Object peek = this.peek();
        this.remove(peek);
        if (!this.exploring) {
            ++this.selectedNodes;
            if (this.selectedNodes % this.exploitationPhaseLength == 0) {
                List<Node<T, V>> explorationCandidates = this.candidateSelector.selectExplorationCandidates(this.exploitationOpen, this.exploitationOpen.peek(), this.solutionDistanceMetric);
                try {
                    logger.info("Entering exploration phase under {}", explorationCandidates);
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
                this.exploring = true;
                this.exploredNodes = 0;
                this.exploitationOpen.removeAll(explorationCandidates);
                this.explorationOpen.clear();
                this.explorationOpen.addAll(explorationCandidates);
            }
        } else {
            ++this.exploredNodes;
            if (this.exploredNodes > this.explorationPhaseLength || this.explorationOpen.isEmpty()) {
                this.adjustPhaseLengths(System.currentTimeMillis() - this.startTime);
                this.exploring = false;
                this.exploitationOpen.addAll(this.explorationOpen);
                this.explorationOpen.clear();
                logger.info("Entering exploitation phase");
            }
        }
        return peek;
    }
}

