/*
 * Decompiled with CFR 0.152.
 */
package jaicore.search.algorithms.standard.uncertainty.paretosearch;

import jaicore.search.model.travesaltree.Node;
import java.util.Comparator;

public class CosinusDistanceComparator<T, V extends Comparable<V>>
implements Comparator<Node<T, V>> {
    public final double x1;
    public final double x2;

    public CosinusDistanceComparator(double x1, double x2) {
        this.x1 = x1;
        this.x2 = x2;
    }

    @Override
    public int compare(Node<T, V> first, Node<T, V> second) {
        Double firstF = (Double)first.getAnnotation("f");
        Double firstU = (Double)first.getAnnotation("uncertainty");
        Double secondF = (Double)second.getAnnotation("f");
        Double secondU = (Double)second.getAnnotation("uncertainty");
        double cosDistanceFirst = 1.0 - this.cosineSimilarity(firstF, firstU);
        double cosDistanceSecond = 1.0 - this.cosineSimilarity(secondF, secondU);
        return (int)((cosDistanceFirst - cosDistanceSecond) * 10000.0);
    }

    public double cosineSimilarity(double f, double u) {
        return (this.x1 * f + this.x2 * u) / (Math.sqrt(f * f + u * u) * Math.sqrt(this.x1 * this.x1 + this.x2 * this.x2));
    }
}

