/*
 * Decompiled with CFR 0.152.
 */
package jaicore.search.algorithms.standard.uncertainty.paretosearch;

import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.XYStyler;

public class ParetoFrontVisualizer {
    final XYChart chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(600)).height(500)).title("Paretofront Visualizer")).theme(Styler.ChartTheme.Matlab)).xAxisTitle("Uncertainty").yAxisTitle("F Value").build();
    final SwingWrapper<XYChart> vis;
    final List<Double> fValues;
    final List<Double> uncertainties;

    public ParetoFrontVisualizer() {
        ((XYStyler)this.chart.getStyler()).setYAxisMin(Double.valueOf(0.0));
        ((XYStyler)this.chart.getStyler()).setXAxisMin(Double.valueOf(0.0));
        ((XYStyler)this.chart.getStyler()).setYAxisMax(Double.valueOf(1.0));
        ((XYStyler)this.chart.getStyler()).setXAxisMax(Double.valueOf(1.0));
        ((XYStyler)this.chart.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Scatter);
        ((XYStyler)this.chart.getStyler()).setLegendPosition(Styler.LegendPosition.OutsideS);
        ((XYStyler)this.chart.getStyler()).setMarkerSize(4);
        this.chart.addSeries("Paretofront Candidates", new double[]{1.0}, new double[]{1.0});
        this.vis = new SwingWrapper((Chart)this.chart);
        this.fValues = new ArrayList<Double>();
        this.uncertainties = new ArrayList<Double>();
    }

    public void show() {
        this.vis.displayChart();
    }

    public void update(double fValue, double uncertainty) {
        this.fValues.add(fValue);
        this.uncertainties.add(uncertainty);
        if (this.fValues.size() == this.uncertainties.size()) {
            double[] f = new double[this.fValues.size()];
            double[] u = new double[this.uncertainties.size()];
            for (int i = 0; i < this.fValues.size(); ++i) {
                f[i] = this.fValues.get(i);
                u[i] = this.uncertainties.get(i);
            }
            SwingUtilities.invokeLater(() -> {
                this.chart.updateXYSeries("Paretofront Candidates", u, f, null);
                this.vis.repaintChart();
            });
        } else {
            System.out.println("ERROR: Unqueal value amounts");
        }
    }
}

