/*
 * Decompiled with CFR 0.152.
 */
package jaicore.search.algorithms.standard.uncertainty.paretosearch;

import jaicore.search.model.travesaltree.Node;
import java.util.HashSet;

public class ParetoNode<T, V extends Comparable<V>> {
    final Node<T, V> node;
    final int n;
    final HashSet<ParetoNode<T, V>> dominates;
    final HashSet<ParetoNode<T, V>> dominatedBy;

    public ParetoNode(Node<T, V> node, int n) {
        this.node = node;
        if (n < 0) {
            throw new IllegalArgumentException("n has to be non-negative");
        }
        this.n = n;
        this.dominates = new HashSet();
        this.dominatedBy = new HashSet();
    }

    public String toString() {
        String s = "{" + this.node.getPoint() + "] dominated by {";
        for (ParetoNode<T, V> p : this.dominatedBy) {
            s = s + p.node.getPoint() + ",";
        }
        s = s + "} dominates { ";
        for (ParetoNode<T, V> p : this.dominates) {
            s = s + p.node.getPoint() + ",";
        }
        s = s + "}";
        return s;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.node == null ? 0 : this.node.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParetoNode other = (ParetoNode)obj;
        return !(this.node == null ? other.node != null : !this.node.equals(other.node));
    }
}

