/*
 * Decompiled with CFR 0.152.
 */
package jaicore.search.algorithms.standard.uncertainty.paretosearch;

import jaicore.search.model.travesaltree.Node;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;

public class ParetoSelection<T, V extends Comparable<V>>
implements Queue<Node<T, V>> {
    private static final String UNCERTAINTY = "uncertainty";
    private static final String DOMINATES = "dominates";
    private static final String DOMINATED_BY = "dominatedBy";
    private final LinkedList<Node<T, V>> open = new LinkedList();
    private final Queue<Node<T, V>> pareto;
    private int n = 0;

    public ParetoSelection(Queue<Node<T, V>> pareto) {
        this.pareto = pareto;
    }

    private boolean dominates(Node<T, V> p, Node<T, V> q) {
        if (!p.getAnnotations().containsKey(UNCERTAINTY)) {
            throw new IllegalArgumentException("Node " + p + " has no uncertainty information.");
        }
        if (!q.getAnnotations().containsKey(UNCERTAINTY)) {
            throw new IllegalArgumentException("Node " + q + " has no uncertainty information.");
        }
        Comparable p_f = (Comparable)p.getAnnotation("f");
        double p_u = (Double)p.getAnnotation(UNCERTAINTY);
        Comparable q_f = (Comparable)q.getAnnotation("f");
        double q_u = (Double)q.getAnnotation(UNCERTAINTY);
        return p_f.compareTo(q_f) < 0 && p_u <= q_u || p_f.compareTo(q_f) <= 0 && p_u < q_u;
    }

    private boolean isMaximal(Node<T, V> n) {
        return ((HashSet)n.getAnnotation(DOMINATED_BY)).size() == 0;
    }

    @Override
    public boolean add(Node<T, V> n) {
        if (n.getInternalLabel() == null) {
            throw new IllegalArgumentException("Cannot add nodes with value NULL to OPEN!");
        }
        n.setAnnotation("n", this.n++);
        n.setAnnotation(DOMINATES, new HashSet());
        n.setAnnotation(DOMINATED_BY, new HashSet());
        for (Node node : this.open) {
            if (this.dominates(n, node)) {
                ((HashSet)n.getAnnotation(DOMINATES)).add(node);
                ((HashSet)node.getAnnotation(DOMINATED_BY)).add(n);
                if (!this.isMaximal(node)) {
                    this.pareto.remove(node);
                }
            }
            if (!this.dominates(node, n)) continue;
            ((HashSet)n.getAnnotation(DOMINATES)).add(node);
            ((HashSet)node.getAnnotation(DOMINATED_BY)).add(n);
        }
        if (this.isMaximal(n)) {
            this.pareto.add(n);
        }
        return this.open.add(n);
    }

    @Override
    public boolean addAll(Collection<? extends Node<T, V>> c) {
        boolean changed = false;
        for (Node<T, V> p : c) {
            changed |= this.add(p);
        }
        return changed;
    }

    @Override
    public void clear() {
        this.open.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.open.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.open.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.open.isEmpty();
    }

    @Override
    public Iterator<Node<T, V>> iterator() {
        return this.pareto.iterator();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.open.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.open.retainAll(c);
    }

    @Override
    public int size() {
        return this.open.size();
    }

    @Override
    public Object[] toArray() {
        return this.open.toArray();
    }

    @Override
    public <X> X[] toArray(X[] a) {
        return this.open.toArray(a);
    }

    @Override
    public Node<T, V> peek() {
        return this.pareto.isEmpty() ? null : this.pareto.peek();
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Node) {
            Node node = (Node)o;
            for (Node q : (HashSet)node.getAnnotation(DOMINATES)) {
                ((HashSet)q.getAnnotation(DOMINATED_BY)).remove(node);
                if (!this.isMaximal(q)) continue;
                this.pareto.add(q);
            }
            for (Node q : (HashSet)node.getAnnotation(DOMINATED_BY)) {
                ((HashSet)q.getAnnotation(DOMINATES)).remove(node);
            }
            this.pareto.remove(node);
            return this.open.remove(node);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OPEN LIST: \n");
        for (Node node : this.open) {
            sb.append(node.toString());
            sb.append("\n");
        }
        sb.append("PARETO = [");
        for (Node node : this.pareto) {
            sb.append(node.getPoint());
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Node<T, V> element() {
        return this.peek();
    }

    @Override
    public boolean offer(Node<T, V> arg0) {
        return this.add(arg0);
    }

    @Override
    public Node<T, V> poll() {
        Object node = this.peek();
        this.remove(node);
        return node;
    }

    @Override
    public Node<T, V> remove() {
        return this.poll();
    }
}

