/*
 * Decompiled with CFR 0.152.
 */
package jaicore.search.core.interfaces;

import ai.libs.jaicore.basic.algorithm.AAlgorithm;
import ai.libs.jaicore.basic.algorithm.ASolutionCandidateIterator;
import ai.libs.jaicore.basic.algorithm.IAlgorithmConfig;
import jaicore.search.algorithms.standard.bestfirst.events.GraphSearchSolutionCandidateFoundEvent;
import jaicore.search.core.interfaces.GraphGenerator;
import jaicore.search.core.interfaces.IPathInORGraphSearch;
import jaicore.search.model.other.SearchGraphPath;
import jaicore.search.probleminputs.GraphSearchInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AAnyPathInORGraphSearch<I extends GraphSearchInput<N, A>, O extends SearchGraphPath<N, A>, N, A>
extends ASolutionCandidateIterator<I, O>
implements IPathInORGraphSearch<I, O, N, A> {
    private Logger logger = LoggerFactory.getLogger(AAlgorithm.class);
    private String loggerName;

    public AAnyPathInORGraphSearch(I problem) {
        super(problem);
    }

    protected AAnyPathInORGraphSearch(IAlgorithmConfig config, I problem) {
        super(config, problem);
    }

    protected GraphSearchSolutionCandidateFoundEvent<N, A, O> registerSolution(O path) {
        GraphSearchSolutionCandidateFoundEvent event = new GraphSearchSolutionCandidateFoundEvent(this.getId(), path);
        this.post((Object)event);
        return event;
    }

    @Override
    public GraphGenerator<N, A> getGraphGenerator() {
        return ((GraphSearchInput)this.getInput()).getGraphGenerator();
    }

    public void setLoggerName(String name) {
        this.logger.info("Switching logger to {}", (Object)name);
        this.loggerName = name;
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Switched to logger {}", (Object)name);
        super.setLoggerName(this.loggerName + "._algorithm");
    }

    public String getLoggerName() {
        return this.loggerName;
    }
}

