/*
 * Decompiled with CFR 0.152.
 */
package jaicore.search.core.interfaces;

import ai.libs.jaicore.basic.algorithm.AAlgorithm;
import ai.libs.jaicore.basic.algorithm.AOptimizer;
import ai.libs.jaicore.basic.algorithm.AlgorithmExecutionCanceledException;
import ai.libs.jaicore.basic.algorithm.IAlgorithmConfig;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmTimeoutedException;
import jaicore.search.algorithms.standard.bestfirst.events.EvaluatedSearchSolutionCandidateFoundEvent;
import jaicore.search.core.interfaces.GraphGenerator;
import jaicore.search.core.interfaces.IOptimalPathInORGraphSearch;
import jaicore.search.model.other.EvaluatedSearchGraphPath;
import jaicore.search.probleminputs.GraphSearchInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AOptimalPathInORGraphSearch<I extends GraphSearchInput<N, A>, N, A, V extends Comparable<V>>
extends AOptimizer<I, EvaluatedSearchGraphPath<N, A, V>, V>
implements IOptimalPathInORGraphSearch<I, N, A, V> {
    private Logger logger = LoggerFactory.getLogger(AAlgorithm.class);
    private String loggerName;

    public AOptimalPathInORGraphSearch(I problem) {
        super(problem);
    }

    protected AOptimalPathInORGraphSearch(IAlgorithmConfig config, I problem) {
        super(config, problem);
    }

    public EvaluatedSearchSolutionCandidateFoundEvent<N, A, V> nextSolutionCandidateEvent() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException, AlgorithmException {
        return (EvaluatedSearchSolutionCandidateFoundEvent)super.nextSolutionCandidateEvent();
    }

    protected EvaluatedSearchSolutionCandidateFoundEvent<N, A, V> registerSolution(EvaluatedSearchGraphPath<N, A, V> path) {
        this.updateBestSeenSolution(path);
        EvaluatedSearchSolutionCandidateFoundEvent<N, A, V> event = new EvaluatedSearchSolutionCandidateFoundEvent<N, A, V>(this.getId(), path);
        this.logger.info("Identified solution with score {}. Enable DEBUG to see the concrete nodes and actions.", path.getScore());
        this.logger.debug("Nodes: {}. Actions: {}", path.getNodes(), path.getEdges());
        this.post(event);
        return event;
    }

    @Override
    public GraphGenerator<N, A> getGraphGenerator() {
        return ((GraphSearchInput)this.getInput()).getGraphGenerator();
    }

    public void setLoggerName(String name) {
        this.logger.info("Switching logger to {}", (Object)name);
        this.loggerName = name;
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Switched to logger {}", (Object)name);
        super.setLoggerName(this.loggerName + "._algorithm");
    }

    public String getLoggerName() {
        return this.loggerName;
    }
}

