/*
 * Decompiled with CFR 0.152.
 */
package jaicore.search.model.other;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SearchGraphPath<N, A> {
    private final List<N> nodes;
    private final List<A> edges;
    private final Map<String, Object> annotations;

    public SearchGraphPath(List<N> nodes) {
        this(nodes, new ArrayList(), new HashMap<String, Object>());
    }

    public SearchGraphPath(List<N> nodes, List<A> edges) {
        this(nodes, edges, new HashMap<String, Object>());
    }

    public SearchGraphPath(List<N> nodes, List<A> edges, Map<String, Object> annotations) {
        this.nodes = nodes;
        this.edges = edges;
        this.annotations = annotations;
    }

    public List<N> getNodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    public List<A> getEdges() {
        return this.edges != null ? Collections.unmodifiableList(this.edges) : null;
    }

    public Map<String, Object> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotation(String key, Object value) {
        this.annotations.put(key, value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.annotations == null ? 0 : this.annotations.hashCode());
        result = 31 * result + (this.edges == null ? 0 : this.edges.hashCode());
        result = 31 * result + (this.nodes == null ? 0 : this.nodes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchGraphPath other = (SearchGraphPath)obj;
        if (this.annotations == null ? other.annotations != null : !this.annotations.equals(other.annotations)) {
            return false;
        }
        if (this.edges == null ? other.edges != null : !this.edges.equals(other.edges)) {
            return false;
        }
        return !(this.nodes == null ? other.nodes != null : !this.nodes.equals(other.nodes));
    }

    public String toString() {
        return "SearchGraphPath [nodes=" + this.nodes + ", edges=" + this.edges + ", annotations=" + this.annotations + "]";
    }
}

