/*
 * Decompiled with CFR 0.152.
 */
package jaicore.search.model.travesaltree;

import ai.libs.jaicore.logging.ToJSONStringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Node<T, V extends Comparable<V>> {
    private final T externalLabel;
    private boolean goal;
    protected Node<T, V> parent;
    private final Map<String, Object> annotations = new HashMap<String, Object>();

    public Node(Node<T, V> parent, T point) {
        this.parent = parent;
        this.externalLabel = point;
    }

    public Node<T, V> getParent() {
        return this.parent;
    }

    public T getPoint() {
        return this.externalLabel;
    }

    public V getInternalLabel() {
        return (V)((Comparable)this.annotations.get("f"));
    }

    public void setParent(Node<T, V> newParent) {
        this.parent = newParent;
    }

    public void setInternalLabel(V internalLabel) {
        this.setAnnotation("f", internalLabel);
    }

    public void setAnnotation(String annotationName, Object annotationValue) {
        this.annotations.put(annotationName, annotationValue);
    }

    public Object getAnnotation(String annotationName) {
        return this.annotations.get(annotationName);
    }

    public Map<String, Object> getAnnotations() {
        return this.annotations;
    }

    public boolean isGoal() {
        return this.goal;
    }

    public void setGoal(boolean goal) {
        this.goal = goal;
    }

    public List<Node<T, V>> path() {
        ArrayList<Node<T, V>> path = new ArrayList<Node<T, V>>();
        Node<T, V> current = this;
        while (current != null) {
            path.add(0, current);
            current = current.parent;
        }
        return path;
    }

    public List<T> externalPath() {
        ArrayList<T> path = new ArrayList<T>();
        Node<T, V> current = this;
        while (current != null) {
            path.add(0, current.externalLabel);
            current = current.parent;
        }
        return path;
    }

    public String getString() {
        String s = "Node [ref=";
        s = s + this.toString();
        s = s + ", externalLabel=";
        s = s + this.externalLabel;
        s = s + ", goal";
        s = s + this.goal;
        s = s + ", parentRef=";
        s = this.parent != null ? s + this.parent.toString() : s + "null";
        s = s + ", annotations=";
        s = s + this.annotations;
        s = s + "]";
        return s;
    }

    public String toString() {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("externalLabel", this.externalLabel);
        fields.put("goal", this.goal);
        fields.put("annotations", this.annotations);
        return ToJSONStringUtil.toJSONString((String)this.getClass().getSimpleName(), fields);
    }
}

