/*
 * Decompiled with CFR 0.152.
 */
package jaicore.search.model.travesaltree;

import jaicore.search.core.interfaces.GraphGenerator;
import jaicore.search.model.travesaltree.NodeExpansionDescription;
import jaicore.search.model.travesaltree.VersionedDomainNode;
import jaicore.search.model.travesaltree.VersionedGraphGeneratorInterface;
import jaicore.search.structure.graphgenerator.MultipleRootGenerator;
import jaicore.search.structure.graphgenerator.NodeGoalTester;
import jaicore.search.structure.graphgenerator.PathGoalTester;
import jaicore.search.structure.graphgenerator.SingleRootGenerator;
import jaicore.search.structure.graphgenerator.SuccessorGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;

public class VersionedGraphGenerator<T, A>
implements VersionedGraphGeneratorInterface<VersionedDomainNode<T>, A> {
    GraphGenerator<T, A> gen;
    boolean nodeNumbering;
    Random rnd;

    public VersionedGraphGenerator(GraphGenerator<T, A> gen) {
        this.gen = gen;
        this.nodeNumbering = true;
        this.rnd = new Random();
    }

    public int getNextID() {
        if (this.nodeNumbering) {
            return this.rnd.nextInt(Integer.MAX_VALUE);
        }
        return -1;
    }

    @Override
    public SingleRootGenerator<VersionedDomainNode<T>> getRootGenerator() {
        return () -> {
            SingleRootGenerator rootGenerator = (SingleRootGenerator)this.gen.getRootGenerator();
            Object root = rootGenerator.getRoot();
            return new VersionedDomainNode(root, this.getNextID());
        };
    }

    public SingleRootGenerator<VersionedDomainNode<T>> getSingleRootGenerator() {
        return () -> {
            SingleRootGenerator rootGenerator = (SingleRootGenerator)this.gen.getRootGenerator();
            Object root = rootGenerator.getRoot();
            return new VersionedDomainNode(root, this.getNextID());
        };
    }

    public MultipleRootGenerator<VersionedDomainNode<T>> getMultipleRootGenerator() {
        return () -> {
            MultipleRootGenerator rootGenerator = (MultipleRootGenerator)this.gen.getRootGenerator();
            ArrayList vRoots = new ArrayList();
            Collection roots = rootGenerator.getRoots();
            roots.stream().forEach(n -> vRoots.add(new VersionedDomainNode<Object>(n, this.getNextID())));
            return vRoots;
        };
    }

    @Override
    public SuccessorGenerator<VersionedDomainNode<T>, A> getSuccessorGenerator() {
        return nodeToExpand -> {
            SuccessorGenerator successorGenerator = this.gen.getSuccessorGenerator();
            List<NodeExpansionDescription<T, A>> successorDescriptions = successorGenerator.generateSuccessors(nodeToExpand.getNode());
            ArrayList versionedDescriptions = new ArrayList();
            successorDescriptions.stream().forEach(description -> versionedDescriptions.add(new NodeExpansionDescription(nodeToExpand, new VersionedDomainNode(description.getTo(), this.getNextID()), description.getAction(), description.getTypeOfToNode())));
            return versionedDescriptions;
        };
    }

    @Override
    public NodeGoalTester<VersionedDomainNode<T>> getGoalTester() {
        return n -> {
            NodeGoalTester goalTester = (NodeGoalTester)this.gen.getGoalTester();
            return goalTester.isGoal(n.getNode());
        };
    }

    public NodeGoalTester<VersionedDomainNode<T>> getNodeGoalTester() {
        return n -> {
            NodeGoalTester goalTester = (NodeGoalTester)this.gen.getGoalTester();
            return goalTester.isGoal(n.getNode());
        };
    }

    public PathGoalTester<VersionedDomainNode<T>> getPathGoalTester() {
        return n -> {
            PathGoalTester goalTester = (PathGoalTester)this.gen.getGoalTester();
            return goalTester.isGoal(n);
        };
    }

    @Override
    public boolean isSelfContained() {
        return this.gen.isSelfContained();
    }

    @Override
    public void setNodeNumbering(boolean numbering) {
        this.nodeNumbering = numbering;
    }
}

