/*
 * Decompiled with CFR 0.152.
 */
package jaicore.search.probleminputs;

import jaicore.search.algorithms.standard.bestfirst.exceptions.NodeEvaluationException;
import jaicore.search.algorithms.standard.bestfirst.nodeevaluation.INodeEvaluator;
import jaicore.search.core.interfaces.GraphGenerator;
import jaicore.search.model.travesaltree.Node;
import jaicore.search.probleminputs.GraphSearchWithSubpathEvaluationsInput;
import java.util.Iterator;
import java.util.List;

public class GraphSearchWithNumberBasedAdditivePathEvaluation<N, A>
extends GraphSearchWithSubpathEvaluationsInput<N, A, Double> {
    public GraphSearchWithNumberBasedAdditivePathEvaluation(GraphGenerator<N, A> graphGenerator, EdgeCostComputer<N> g, INodeEvaluator<N, Double> h) {
        super(graphGenerator, new FComputer<N>(g, h));
    }

    public GraphSearchWithNumberBasedAdditivePathEvaluation(GraphGenerator<N, A> graphGenerator, FComputer<N> fComputer) {
        super(graphGenerator, fComputer);
    }

    public static class FComputer<N>
    implements INodeEvaluator<N, Double> {
        private final EdgeCostComputer<N> g;
        private final INodeEvaluator<N, Double> h;

        public FComputer(EdgeCostComputer<N> g, INodeEvaluator<N, Double> h) {
            this.g = g;
            this.h = h;
        }

        @Override
        public Double f(Node<N, ?> node) throws NodeEvaluationException, InterruptedException {
            List<Node<N, ?>> path = node.path();
            int depth = path.size() - 1;
            double pathCost = 0.0;
            double heuristic = this.h.f(node);
            if (depth > 0) {
                Iterator<Node<N, ?>> it = path.iterator();
                Node<N, ?> parent = it.next();
                while (it.hasNext()) {
                    Node<N, ?> current = it.next();
                    pathCost += this.g.g(parent, current);
                    parent = current;
                }
            }
            return pathCost + heuristic;
        }

        public EdgeCostComputer<N> getG() {
            return this.g;
        }

        public INodeEvaluator<N, Double> getH() {
            return this.h;
        }
    }

    public static interface EdgeCostComputer<N> {
        public double g(Node<N, ?> var1, Node<N, ?> var2);
    }
}

