/*
 * Decompiled with CFR 0.152.
 */
package jaicore.search.util;

import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.graphvisualizer.events.graph.GraphInitializedEvent;
import ai.libs.jaicore.graphvisualizer.events.graph.NodeAddedEvent;
import ai.libs.jaicore.graphvisualizer.events.graph.NodeTypeSwitchEvent;
import jaicore.search.core.interfaces.AOptimalPathInORGraphSearch;
import jaicore.search.model.travesaltree.Node;
import jaicore.search.model.travesaltree.NodeExpansionDescription;
import jaicore.search.probleminputs.GraphSearchInput;
import jaicore.search.structure.graphgenerator.NodeGoalTester;
import jaicore.search.structure.graphgenerator.SingleRootGenerator;
import jaicore.search.util.CycleDetectedResult;
import jaicore.search.util.DeadEndDetectedResult;
import jaicore.search.util.GraphSeemsSaneResult;
import jaicore.search.util.SanityCheckResult;
import java.util.List;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphSanityChecker<N, A>
extends AOptimalPathInORGraphSearch<GraphSearchInput<N, A>, N, A, Double> {
    private Logger logger = LoggerFactory.getLogger(GraphSanityChecker.class);
    private String loggerName;
    private SanityCheckResult sanityCheckResult;
    private final int maxNodesToExpand;
    private final boolean detectCycles = true;
    private final boolean detectDeadEnds = true;

    public GraphSanityChecker(GraphSearchInput<N, A> problem, int maxNodesToExpand) {
        super(problem);
        this.maxNodesToExpand = maxNodesToExpand;
    }

    public AlgorithmEvent nextWithException() throws InterruptedException {
        switch (this.getState()) {
            case created: {
                return this.activate();
            }
            case active: {
                int expanded = 0;
                Stack open = new Stack();
                Object root = ((SingleRootGenerator)this.getGraphGenerator().getRootGenerator()).getRoot();
                NodeGoalTester goalTester = (NodeGoalTester)this.getGraphGenerator().getGoalTester();
                open.push(new Node(null, root));
                this.post(new GraphInitializedEvent(this.getId(), root));
                while (!open.isEmpty() && expanded < this.maxNodesToExpand) {
                    Node node = (Node)open.pop();
                    if (!node.isGoal()) {
                        this.post(new NodeTypeSwitchEvent(this.getId(), (Object)node, "or_closed"));
                    }
                    ++expanded;
                    List successors = this.getGraphGenerator().getSuccessorGenerator().generateSuccessors(node.getPoint());
                    this.getClass();
                    if (successors.isEmpty() && !node.isGoal()) {
                        this.sanityCheckResult = new DeadEndDetectedResult(node.getPoint());
                        break;
                    }
                    for (NodeExpansionDescription successor : successors) {
                        this.getClass();
                        if (node.externalPath().contains(successor.getTo())) {
                            List path = node.externalPath();
                            path.add(successor.getTo());
                            this.sanityCheckResult = new CycleDetectedResult(path, node.getPoint());
                            break;
                        }
                        Node newNode = new Node(node, successor.getTo());
                        newNode.setGoal(goalTester.isGoal(newNode.getPoint()));
                        open.add(newNode);
                        this.post(new NodeAddedEvent(this.getId(), node.getPoint(), successor.getTo(), newNode.isGoal() ? "or_solution" : "or_open"));
                    }
                    if (this.sanityCheckResult != null) break;
                    if (expanded % 100 != 0 && expanded != this.maxNodesToExpand) continue;
                    this.logger.debug("Expanded {}/{} nodes.", (Object)expanded, (Object)this.maxNodesToExpand);
                }
                this.shutdown();
                return this.terminate();
            }
        }
        throw new IllegalStateException("Cannot do anything in state " + this.getState());
    }

    public SanityCheckResult getSanityCheck() {
        return this.sanityCheckResult != null ? this.sanityCheckResult : new GraphSeemsSaneResult();
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    @Override
    public void setLoggerName(String name) {
        this.logger.info("Switching logger from {} to {}", (Object)this.logger.getName(), (Object)name);
        this.loggerName = name;
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Activated logger {} with name {}", (Object)name, (Object)this.logger.getName());
        super.setLoggerName(this.loggerName + "._orgraphsearch");
    }
}

