package ai.libs.jaicore.search.algorithms.standard.bestfirst.events;

import java.util.List;

import ai.libs.jaicore.search.model.travesaltree.Node;
import ai.libs.jaicore.search.model.travesaltree.NodeExpansionDescription;

public class SuccessorComputationCompletedEvent<T, A> extends BestFirstEvent {
	private Node<T, ?> node;
	private List<NodeExpansionDescription<T, A>> successorDescriptions;

	public SuccessorComputationCompletedEvent(String algorithmId, Node<T, ?> node,
			List<NodeExpansionDescription<T, A>> successorDescriptions) {
		super(algorithmId);
		this.node = node;
		this.successorDescriptions = successorDescriptions;
	}

	public Node<T, ?> getNode() {
		return node;
	}

	public void setNode(Node<T, ?> node) {
		this.node = node;
	}

	public List<NodeExpansionDescription<T, A>> getSuccessorDescriptions() {
		return successorDescriptions;
	}

	public void setSuccessorDescriptions(List<NodeExpansionDescription<T, A>> successorDescriptions) {
		this.successorDescriptions = successorDescriptions;
	}
}
