package ai.libs.jaicore.search.algorithms.standard.uncertainty.explorationexploitationsearch;

public class BasicClockModelPhaseLengthAdjuster implements IPhaseLengthAdjuster {
	
	private int interval;
	
	@Override
	public int[] getInitialPhaseLengths(int interval) {
		this.interval = interval;
		return new int[]{this.interval - 1, 1};
	}

	@Override
	public int[] adjustPhaseLength(int currentExplorationLength, int currentExploitationLength, long passedTime, long timeout) {
		double alpha = ((double) Math.min(passedTime, timeout))/((double) timeout) * 0.5 * Math.PI;
		int exploration = (int)(Math.cos(alpha) * (double)interval);
		int exploitation = this.interval - exploration;
		return new int[]{Math.max(exploration, 1), Math.max(exploitation, 1)};
	}

}
