/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.core;

import ai.libs.hasco.builder.forwarddecomposition.DefaultPathPriorizingPredicate;
import ai.libs.hasco.builder.forwarddecomposition.HASCOViaFDBuilder;
import ai.libs.jaicore.basic.FileUtil;
import ai.libs.jaicore.basic.ResourceFile;
import ai.libs.jaicore.basic.ResourceUtil;
import ai.libs.jaicore.basic.algorithm.reduction.AlgorithmicProblemReduction;
import ai.libs.jaicore.basic.reconstruction.ReconstructionUtil;
import ai.libs.jaicore.basic.sets.SetUtil;
import ai.libs.jaicore.components.api.IComponentRepository;
import ai.libs.jaicore.components.api.INumericParameterRefinementConfigurationMap;
import ai.libs.jaicore.components.serialization.ComponentSerialization;
import ai.libs.jaicore.ml.core.evaluation.evaluator.factory.ISupervisedLearnerEvaluatorFactory;
import ai.libs.jaicore.ml.core.evaluation.evaluator.factory.MonteCarloCrossValidationEvaluatorFactory;
import ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.tfd.TFDNode;
import ai.libs.mlplan.core.ILearnerFactory;
import ai.libs.mlplan.core.IMLPlanBuilder;
import ai.libs.mlplan.core.IProblemType;
import ai.libs.mlplan.core.MLPlan;
import ai.libs.mlplan.core.MLPlanUtil;
import ai.libs.mlplan.core.PipelineValidityCheckingNodeEvaluator;
import ai.libs.mlplan.multiclass.MLPlanClassifierConfig;
import ai.libs.mlplan.safeguard.IEvaluationSafeGuardFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.aeonbits.owner.ConfigFactory;
import org.api4.java.ai.graphsearch.problem.IOptimalPathInORGraphSearchFactory;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.IPathEvaluator;
import org.api4.java.ai.ml.core.dataset.splitter.IFoldSizeConfigurableRandomDatasetSplitter;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledDataset;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledInstance;
import org.api4.java.ai.ml.core.evaluation.supervised.loss.IDeterministicPredictionPerformanceMeasure;
import org.api4.java.ai.ml.core.learner.ISupervisedLearner;
import org.api4.java.algorithm.Timeout;
import org.api4.java.common.control.ILoggingCustomizable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AMLPlanBuilder<L extends ISupervisedLearner<ILabeledInstance, ILabeledDataset<? extends ILabeledInstance>>, B extends AMLPlanBuilder<L, B>>
implements IMLPlanBuilder<L, B>,
ILoggingCustomizable {
    private Logger logger = LoggerFactory.getLogger(AMLPlanBuilder.class);
    private String loggerName = AMLPlanBuilder.class.getName();
    private static final String RES_ALGORITHM_CONFIG = "mlplan/mlplan.properties";
    private static final String FS_ALGORITHM_CONFIG = "conf/mlplan.properties";
    private static final File DEF_ALGORITHM_CONFIG = FileUtil.getExistingFileWithHighestPriority((String)"mlplan/mlplan.properties", (String[])new String[]{"conf/mlplan.properties"});
    private final ComponentSerialization serializer = new ComponentSerialization();
    private File searchSpaceFile;
    private String requestedHASCOInterface;
    private String nameOfHASCOMethodToResolveBareLearner;
    private String nameOfHASCOMethodToResolverLearnerInPipeline;
    private ILearnerFactory<L> learnerFactory;
    private ILabeledDataset<?> dataset;
    private MLPlanClassifierConfig algorithmConfig;
    private Predicate<TFDNode> priorizingPredicate = new DefaultPathPriorizingPredicate();
    private List<IPathEvaluator<TFDNode, String, Double>> preferredNodeEvaluators = new ArrayList<IPathEvaluator<TFDNode, String, Double>>();
    private PipelineValidityCheckingNodeEvaluator pipelineValidityCheckingNodeEvaluator;
    private IFoldSizeConfigurableRandomDatasetSplitter<ILabeledDataset<?>> searchSelectionDatasetSplitter;
    private IDeterministicPredictionPerformanceMeasure<?, ?> metricForSearchPhase;
    private IDeterministicPredictionPerformanceMeasure<?, ?> metricForSelectionPhase;
    private ISupervisedLearnerEvaluatorFactory<ILabeledInstance, ILabeledDataset<? extends ILabeledInstance>> factoryForPipelineEvaluationInSearchPhase = this.getMCCVFactory(3, 0.7);
    private ISupervisedLearnerEvaluatorFactory<ILabeledInstance, ILabeledDataset<? extends ILabeledInstance>> factoryForPipelineEvaluationInSelectionPhase = this.getMCCVFactory(3, 0.7);
    private IEvaluationSafeGuardFactory safeGuard = null;

    protected AMLPlanBuilder() {
        this.withAlgorithmConfigFile(DEF_ALGORITHM_CONFIG);
        this.withSeed(0L);
    }

    protected AMLPlanBuilder(IProblemType<L> problemType) throws IOException {
        this.withAlgorithmConfigFile(DEF_ALGORITHM_CONFIG);
        this.withProblemType(problemType);
        this.withSeed(0L);
    }

    public AMLPlanBuilder<L, B> withProblemType(IProblemType<L> problemType) throws IOException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Setting problem type to {}.", (Object)problemType.getName());
        }
        this.withSearchSpaceConfigFile(FileUtil.getExistingFileWithHighestPriority((String)problemType.getSearchSpaceConfigFileFromResource(), (String[])new String[]{problemType.getSearchSpaceConfigFromFileSystem()}));
        this.withRequestedInterface(problemType.getRequestedInterface());
        this.withLearnerFactory(problemType.getLearnerFactory());
        if (problemType.getPreferredComponentListFromResource() != null || problemType.getPreferredComponentListFromFileSystem() != null) {
            boolean relevantFileAvailable = true;
            if (problemType.getPreferredComponentListFromResource() == null) {
                relevantFileAvailable = new File(problemType.getPreferredComponentListFromFileSystem()).exists();
            }
            if (relevantFileAvailable) {
                this.withPreferredComponentsFile(FileUtil.getExistingFileWithHighestPriority((String)problemType.getPreferredComponentListFromResource(), (String[])new String[]{problemType.getPreferredComponentListFromFileSystem()}));
                this.nameOfHASCOMethodToResolveBareLearner = problemType.getLastHASCOMethodPriorToParameterRefinementOfBareLearner();
                this.nameOfHASCOMethodToResolverLearnerInPipeline = problemType.getLastHASCOMethodPriorToParameterRefinementOfPipeline();
            }
        }
        this.withPipelineValidityCheckingNodeEvaluator(problemType.getValidityCheckingNodeEvaluator());
        this.withPerformanceMeasureForSearchPhase(problemType.getPerformanceMetricForSearchPhase());
        this.withPerformanceMeasureForSelectionPhase(problemType.getPerformanceMetricForSelectionPhase());
        this.searchSelectionDatasetSplitter = problemType.getSearchSelectionDatasetSplitter();
        return (AMLPlanBuilder)this.getSelf();
    }

    public B withPerformanceMeasureForSearchPhase(IDeterministicPredictionPerformanceMeasure<?, ?> performanceMeasure) {
        this.metricForSearchPhase = performanceMeasure;
        return (B)((AMLPlanBuilder)this.getSelf());
    }

    public B withPerformanceMeasureForSelectionPhase(IDeterministicPredictionPerformanceMeasure<?, ?> performanceMeasure) {
        this.metricForSelectionPhase = performanceMeasure;
        return (B)((AMLPlanBuilder)this.getSelf());
    }

    public B withPerformanceMeasure(IDeterministicPredictionPerformanceMeasure<?, ?> performanceMeasure) {
        this.withPerformanceMeasureForSearchPhase(performanceMeasure);
        this.withPerformanceMeasureForSelectionPhase(performanceMeasure);
        return (B)((AMLPlanBuilder)this.getSelf());
    }

    @Override
    public IDeterministicPredictionPerformanceMeasure<?, ?> getMetricForSearchPhase() {
        return this.metricForSearchPhase;
    }

    @Override
    public IDeterministicPredictionPerformanceMeasure<?, ?> getMetricForSelectionPhase() {
        return this.metricForSelectionPhase;
    }

    public B withPreferredComponentsFile(File preferredComponentsFile) throws IOException {
        this.getAlgorithmConfig().setProperty("mlplan.preferredComponents", preferredComponentsFile.getAbsolutePath());
        List namesOfPreferredComponents = null;
        if (preferredComponentsFile instanceof ResourceFile) {
            namesOfPreferredComponents = ResourceUtil.readResourceFileToStringList((ResourceFile)((ResourceFile)preferredComponentsFile));
        } else if (!preferredComponentsFile.exists()) {
            this.logger.warn("The configured file for preferred components \"{}\" does not exist. Not using any particular ordering.", (Object)preferredComponentsFile.getAbsolutePath());
        } else {
            namesOfPreferredComponents = FileUtil.readFileAsList((File)preferredComponentsFile);
        }
        if (namesOfPreferredComponents != null) {
            this.withPreferredComponents(namesOfPreferredComponents);
        }
        return (B)((AMLPlanBuilder)this.getSelf());
    }

    public B withPreferredComponents(List<String> preferredComponents) {
        this.getAlgorithmConfig().setProperty("mlplan.preferredComponents", "" + SetUtil.implode(preferredComponents, (String)", "));
        return (B)((AMLPlanBuilder)this.getSelf());
    }

    public List<String> getPreferredComponents() {
        return this.getAlgorithmConfig().preferredComponents();
    }

    public B withPreferredNodeEvaluator(IPathEvaluator<TFDNode, String, Double> preferredNodeEvaluator) {
        this.preferredNodeEvaluators.add(preferredNodeEvaluator);
        return (B)((AMLPlanBuilder)this.getSelf());
    }

    public List<IPathEvaluator<TFDNode, String, Double>> getPreferredNodeEvaluators() {
        return Collections.unmodifiableList(this.preferredNodeEvaluators);
    }

    public B withSearchFactory(IOptimalPathInORGraphSearchFactory searchFactory, AlgorithmicProblemReduction transformer) {
        throw new UnsupportedOperationException("Currently only support for BestFirst search. Will be extended in the upcoming release.");
    }

    public IComponentRepository getComponents() throws IOException {
        return this.serializer.deserializeRepository(this.searchSpaceFile);
    }

    public INumericParameterRefinementConfigurationMap getComponentParameterConfigurations() throws IOException {
        return this.serializer.deserializeParamMap(this.searchSpaceFile);
    }

    public B withAlgorithmConfigFile(File algorithmConfigFile) {
        return this.withAlgorithmConfig((MLPlanClassifierConfig)((MLPlanClassifierConfig)ConfigFactory.create(MLPlanClassifierConfig.class, (Map[])new Map[0])).loadPropertiesFromFile(algorithmConfigFile));
    }

    public B withAlgorithmConfig(MLPlanClassifierConfig config) {
        this.algorithmConfig = config;
        return (B)((AMLPlanBuilder)this.getSelf());
    }

    public B withDataset(ILabeledDataset<?> dataset) {
        if (!ReconstructionUtil.areInstructionsNonEmptyIfReconstructibilityClaimed(dataset)) {
            this.logger.warn("The dataset claims to be reconstructible, but it does not carry any instructions.");
        }
        this.dataset = dataset;
        if (dataset.stream().anyMatch(i -> i.getLabel() == null)) {
            this.logger.warn("Dataset has instances without label. Dropping those lines!! Number of instances now: {}", (Object)this.dataset.size());
            this.dataset.removeIf(i -> i.getLabel() == null);
            this.logger.warn("Dataset is now reduced. Number of instances now: {}", (Object)this.dataset.size());
        }
        return (B)((AMLPlanBuilder)this.getSelf());
    }

    public ILabeledDataset<?> getDataset() {
        return this.dataset;
    }

    public B withSearchSpaceConfigFile(File searchSpaceConfig) throws IOException {
        FileUtil.requireFileExists((File)searchSpaceConfig);
        this.searchSpaceFile = searchSpaceConfig;
        this.logger.info("The search space configuration file has been set to {}.", (Object)searchSpaceConfig.getCanonicalPath());
        return (B)((AMLPlanBuilder)this.getSelf());
    }

    public B withLearnerFactory(ILearnerFactory<L> classifierFactory) {
        this.learnerFactory = classifierFactory;
        return (B)((AMLPlanBuilder)this.getSelf());
    }

    public B withDatasetSplitterForSearchSelectionSplit(IFoldSizeConfigurableRandomDatasetSplitter<ILabeledDataset<?>> datasetSplitter) {
        this.searchSelectionDatasetSplitter = datasetSplitter;
        return (B)((AMLPlanBuilder)this.getSelf());
    }

    public B withRequestedInterface(String requestedInterface) {
        this.requestedHASCOInterface = requestedInterface;
        return (B)((AMLPlanBuilder)this.getSelf());
    }

    public B withTimeOut(Timeout timeout) {
        this.algorithmConfig.setProperty("timeout", timeout.milliseconds() + "");
        return (B)((AMLPlanBuilder)this.getSelf());
    }

    public Timeout getTimeOut() {
        return new Timeout(this.algorithmConfig.timeout(), TimeUnit.MILLISECONDS);
    }

    public B withTimeoutPrecautionOffsetInSeconds(int seconds) {
        this.algorithmConfig.setProperty("mlplan.precautionoffset", "" + seconds);
        return (B)((AMLPlanBuilder)this.getSelf());
    }

    public int getTimeoutPrecautionOffsetInSeconds() {
        return this.algorithmConfig.precautionOffset();
    }

    public B withNodeEvaluationTimeOut(Timeout timeout) {
        this.algorithmConfig.setProperty("hasco.random_completions.timeout_node", timeout.milliseconds() + "");
        return (B)((AMLPlanBuilder)this.getSelf());
    }

    public Timeout getNodeEvaluationTimeOut() {
        return new Timeout((long)this.algorithmConfig.timeoutForNodeEvaluation(), TimeUnit.MILLISECONDS);
    }

    public B withCandidateEvaluationTimeOut(Timeout timeout) {
        this.algorithmConfig.setProperty("hasco.random_completions.timeout_path", timeout.milliseconds() + "");
        return (B)((AMLPlanBuilder)this.getSelf());
    }

    public Timeout getCandidateEvaluationTimeOut() {
        return new Timeout((long)this.algorithmConfig.timeoutForCandidateEvaluation(), TimeUnit.MILLISECONDS);
    }

    public B withMCCVBasedCandidateEvaluationInSearchPhase(int numIterations, double trainPortion) {
        this.factoryForPipelineEvaluationInSearchPhase = this.getMCCVFactory(numIterations, trainPortion);
        return (B)((AMLPlanBuilder)this.getSelf());
    }

    public B withMCCVBasedCandidateEvaluationInSelectionPhase(int numIterations, double trainPortion) {
        this.factoryForPipelineEvaluationInSelectionPhase = this.getMCCVFactory(numIterations, trainPortion);
        return (B)((AMLPlanBuilder)this.getSelf());
    }

    private MonteCarloCrossValidationEvaluatorFactory getMCCVFactory(int numIterations, double trainPortion) {
        MonteCarloCrossValidationEvaluatorFactory factory = new MonteCarloCrossValidationEvaluatorFactory();
        ((MonteCarloCrossValidationEvaluatorFactory)factory.withNumMCIterations(numIterations)).withTrainFoldSize(trainPortion);
        return factory;
    }

    @Override
    public ISupervisedLearnerEvaluatorFactory<ILabeledInstance, ILabeledDataset<? extends ILabeledInstance>> getLearnerEvaluationFactoryForSearchPhase() {
        return this.factoryForPipelineEvaluationInSearchPhase;
    }

    @Override
    public ISupervisedLearnerEvaluatorFactory<ILabeledInstance, ILabeledDataset<? extends ILabeledInstance>> getLearnerEvaluationFactoryForSelectionPhase() {
        return this.factoryForPipelineEvaluationInSelectionPhase;
    }

    public void withSearchPhaseEvaluatorFactory(ISupervisedLearnerEvaluatorFactory<ILabeledInstance, ILabeledDataset<? extends ILabeledInstance>> evaluatorFactory) {
        this.factoryForPipelineEvaluationInSearchPhase = evaluatorFactory;
    }

    protected ISupervisedLearnerEvaluatorFactory<ILabeledInstance, ILabeledDataset<? extends ILabeledInstance>> getSearchEvaluatorFactory() {
        return this.factoryForPipelineEvaluationInSearchPhase;
    }

    public B withSelectionPhaseEvaluatorFactory(ISupervisedLearnerEvaluatorFactory<ILabeledInstance, ILabeledDataset<? extends ILabeledInstance>> evaluatorFactory) {
        this.factoryForPipelineEvaluationInSelectionPhase = evaluatorFactory;
        return (B)((AMLPlanBuilder)this.getSelf());
    }

    public B withNumCpus(int numCpus) {
        this.algorithmConfig.setProperty("cpus", numCpus + "");
        return (B)((AMLPlanBuilder)this.getSelf());
    }

    public B withSeed(long seed) {
        this.algorithmConfig.setProperty("seed", seed + "");
        this.logger.info("Seed has been set to {}", (Object)seed);
        return (B)((AMLPlanBuilder)this.getSelf());
    }

    protected ISupervisedLearnerEvaluatorFactory<ILabeledInstance, ILabeledDataset<? extends ILabeledInstance>> getSelectionEvaluatorFactory() {
        return this.factoryForPipelineEvaluationInSelectionPhase;
    }

    @Override
    public HASCOViaFDBuilder<Double, ?> getHASCOFactory() {
        return MLPlanUtil.getHASCOBuilder(this.algorithmConfig, this.dataset, this.searchSpaceFile, this.requestedHASCOInterface, this.priorizingPredicate, this.preferredNodeEvaluators, this.pipelineValidityCheckingNodeEvaluator, this.nameOfHASCOMethodToResolveBareLearner, this.nameOfHASCOMethodToResolverLearnerInPipeline);
    }

    @Override
    public ILearnerFactory<L> getLearnerFactory() {
        return this.learnerFactory;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
        this.serializer.setLoggerName(name + ".serializer");
        this.loggerName = name;
    }

    @Override
    public String getRequestedInterface() {
        return this.requestedHASCOInterface;
    }

    @Override
    public IFoldSizeConfigurableRandomDatasetSplitter<ILabeledDataset<?>> getSearchSelectionDatasetSplitter() {
        return this.searchSelectionDatasetSplitter;
    }

    @Override
    public File getSearchSpaceConfigFile() {
        return this.searchSpaceFile;
    }

    @Override
    public MLPlanClassifierConfig getAlgorithmConfig() {
        return this.algorithmConfig;
    }

    public B withPipelineValidityCheckingNodeEvaluator(PipelineValidityCheckingNodeEvaluator ne) {
        this.pipelineValidityCheckingNodeEvaluator = ne;
        return (B)((AMLPlanBuilder)this.getSelf());
    }

    public PipelineValidityCheckingNodeEvaluator getPipelineValidityCheckingNodeEvaluator() {
        return this.pipelineValidityCheckingNodeEvaluator;
    }

    public B withPortionOfDataReservedForSelection(double value) {
        this.algorithmConfig.setProperty("mlplan.selectionportion", value + "");
        return (B)((AMLPlanBuilder)this.getSelf());
    }

    @Override
    public double getPortionOfDataReservedForSelectionPhase() {
        return this.algorithmConfig.dataPortionForSelection();
    }

    public B withSafeGuardFactory(IEvaluationSafeGuardFactory safeGuard) {
        this.safeGuard = safeGuard;
        return (B)((AMLPlanBuilder)this.getSelf());
    }

    @Override
    public IEvaluationSafeGuardFactory getSafeGuardFactory() {
        return this.safeGuard;
    }

    public MLPlan<L> build(ILabeledDataset<?> dataset) {
        return ((AMLPlanBuilder)this.withDataset(dataset)).build();
    }

    public void checkPreconditionsForInitialization() {
        Objects.requireNonNull(this.searchSpaceFile, "No search space file defined.");
        Objects.requireNonNull(this.requestedHASCOInterface, "No requested HASCO interface defined!");
        Objects.requireNonNull(this.dataset, "A dataset needs to be provided as input to ML-Plan");
        Objects.requireNonNull(this.learnerFactory, "The learner factory has not been set.");
        Objects.requireNonNull(this.factoryForPipelineEvaluationInSearchPhase, "Factory for pipeline evaluation in search phase is not set!");
        Objects.requireNonNull(this.factoryForPipelineEvaluationInSelectionPhase, "Factory for pipeline evaluation in selection phase is not set!");
        Objects.requireNonNull(this.searchSelectionDatasetSplitter, "Dataset splitter for search phase must be set!");
    }

    public MLPlan<L> build() {
        this.checkPreconditionsForInitialization();
        return new MLPlan(this, this.dataset);
    }
}

