/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.core;

import ai.libs.hasco.builder.HASCOBuilder;
import ai.libs.hasco.builder.forwarddecomposition.HASCOViaFDAndBestFirstWithRandomCompletionsBuilder;
import ai.libs.jaicore.basic.MathExt;
import ai.libs.jaicore.basic.sets.Pair;
import ai.libs.jaicore.components.api.IComponent;
import ai.libs.jaicore.components.model.RefinementConfiguredSoftwareConfigurationProblem;
import ai.libs.jaicore.ml.core.evaluation.evaluator.factory.ISupervisedLearnerEvaluatorFactory;
import ai.libs.jaicore.ml.core.evaluation.evaluator.factory.LearnerEvaluatorConstructionFailedException;
import ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.tfd.TFDNode;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.nodeevaluation.AlternativeNodeEvaluator;
import ai.libs.mlplan.core.ILearnerFactory;
import ai.libs.mlplan.core.PipelineEvaluator;
import ai.libs.mlplan.core.PipelineValidityCheckingNodeEvaluator;
import ai.libs.mlplan.core.PreferenceBasedNodeEvaluator;
import ai.libs.mlplan.multiclass.MLPlanClassifierConfig;
import ai.libs.mlplan.safeguard.IEvaluationSafeGuard;
import ai.libs.mlplan.safeguard.IEvaluationSafeGuardFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.IPathEvaluator;
import org.api4.java.ai.ml.core.IDataConfigurable;
import org.api4.java.ai.ml.core.dataset.splitter.IFoldSizeConfigurableRandomDatasetSplitter;
import org.api4.java.ai.ml.core.dataset.splitter.SplitFailedException;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledDataset;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledInstance;
import org.api4.java.ai.ml.core.evaluation.IPredictionPerformanceMetricConfigurable;
import org.api4.java.ai.ml.core.evaluation.ISupervisedLearnerEvaluator;
import org.api4.java.ai.ml.core.evaluation.supervised.loss.IDeterministicPredictionPerformanceMeasure;
import org.api4.java.ai.ml.core.learner.ISupervisedLearner;
import org.api4.java.algorithm.Timeout;
import org.api4.java.algorithm.exceptions.AlgorithmException;
import org.api4.java.common.control.ILoggingCustomizable;
import org.api4.java.common.control.IRandomConfigurable;
import org.slf4j.Logger;

abstract class MLPlanUtil {
    private MLPlanUtil() {
    }

    public static Pair<ILabeledDataset<?>, ILabeledDataset<?>> getDataForSearchAndSelection(ILabeledDataset<?> dataset, double dataPortionUsedForSelection, Random random, IFoldSizeConfigurableRandomDatasetSplitter<ILabeledDataset<?>> splitter, Logger logger) throws InterruptedException, AlgorithmException {
        ILabeledDataset dataShownToSelection;
        ILabeledDataset dataShownToSearch;
        if (dataPortionUsedForSelection > 0.0) {
            try {
                if (splitter == null) {
                    throw new IllegalArgumentException("The builder does not specify a dataset splitter for the separation between search and selection phase data.");
                }
                logger.debug("Splitting given {} data points into search data ({}%) and selection data ({}%) with splitter {}.", new Object[]{dataset.size(), MathExt.round((double)((1.0 - dataPortionUsedForSelection) * 100.0), (int)2), MathExt.round((double)(dataPortionUsedForSelection * 100.0), (int)2), splitter.getClass().getName()});
                if (splitter instanceof ILoggingCustomizable) {
                    ((ILoggingCustomizable)splitter).setLoggerName(logger.getName() + ".searchselectsplitter");
                }
                List split = splitter.split(dataset, random, new double[]{dataPortionUsedForSelection});
                int expectedSearchSize = (int)Math.round((double)dataset.size() * (1.0 - dataPortionUsedForSelection));
                int expectedSelectionSize = dataset.size() - expectedSearchSize;
                if (Math.abs(expectedSearchSize - ((ILabeledDataset)split.get(1)).size()) > 1 || Math.abs(expectedSelectionSize - ((ILabeledDataset)split.get(0)).size()) > 1) {
                    throw new IllegalStateException("Invalid split produced by " + splitter.getClass().getName() + "! Split sizes are " + ((ILabeledDataset)split.get(1)).size() + "/" + ((ILabeledDataset)split.get(0)).size() + " but expected sizes were " + expectedSearchSize + "/" + expectedSelectionSize);
                }
                dataShownToSearch = (ILabeledDataset)split.get(1);
                dataShownToSelection = dataset;
                logger.debug("Search/Selection split completed. Using {} data points in search and {} in selection.", (Object)dataShownToSearch.size(), (Object)dataShownToSelection.size());
            }
            catch (SplitFailedException e) {
                throw new AlgorithmException("Error in ML-Plan execution.", (Throwable)e);
            }
        } else {
            dataShownToSearch = dataset;
            dataShownToSelection = null;
            logger.debug("Selection phase de-activated. Not splitting the data and giving everything to the search.");
        }
        if (dataShownToSearch.isEmpty()) {
            throw new IllegalStateException("Cannot search on no data.");
        }
        if (dataShownToSelection != null && dataShownToSelection.size() < dataShownToSearch.size()) {
            throw new IllegalStateException("The search data (" + dataShownToSearch.size() + " data points) are bigger than the selection data (" + dataShownToSelection.size() + " data points)!");
        }
        return new Pair(dataShownToSearch, dataShownToSelection);
    }

    public static Pair<PipelineEvaluator, PipelineEvaluator> getPipelineEvaluators(ISupervisedLearnerEvaluatorFactory<ILabeledInstance, ILabeledDataset<? extends ILabeledInstance>> evaluatorFactoryForSearch, IDeterministicPredictionPerformanceMeasure<?, ?> metricForSearch, ISupervisedLearnerEvaluatorFactory<ILabeledInstance, ILabeledDataset<? extends ILabeledInstance>> evaluatorFactoryForSelection, IDeterministicPredictionPerformanceMeasure<?, ?> metricForSelection, Random random, ILabeledDataset<?> dataShownToSearch, ILabeledDataset<?> dataShownToSelection, IEvaluationSafeGuardFactory safeGuardFactory, ILearnerFactory<? extends ISupervisedLearner<ILabeledInstance, ILabeledDataset<? extends ILabeledInstance>>> learnerFactory, Timeout timeoutForCandidateEvaluation) throws InterruptedException, AlgorithmException, LearnerEvaluatorConstructionFailedException {
        if (evaluatorFactoryForSearch instanceof IPredictionPerformanceMetricConfigurable) {
            ((IPredictionPerformanceMetricConfigurable)evaluatorFactoryForSearch).setMeasure(metricForSearch);
        }
        if (evaluatorFactoryForSearch instanceof IRandomConfigurable) {
            ((IRandomConfigurable)evaluatorFactoryForSearch).setRandom(random);
        }
        if (evaluatorFactoryForSearch instanceof IDataConfigurable) {
            ((IDataConfigurable)evaluatorFactoryForSearch).setData(dataShownToSearch);
        }
        if (evaluatorFactoryForSelection instanceof IPredictionPerformanceMetricConfigurable) {
            ((IPredictionPerformanceMetricConfigurable)evaluatorFactoryForSelection).setMeasure(metricForSelection);
        }
        if (evaluatorFactoryForSelection instanceof IRandomConfigurable) {
            ((IRandomConfigurable)evaluatorFactoryForSelection).setRandom(random);
        }
        if (evaluatorFactoryForSelection instanceof IDataConfigurable && dataShownToSelection != null) {
            ((IDataConfigurable)evaluatorFactoryForSelection).setData(dataShownToSelection);
        }
        ISupervisedLearnerEvaluator searchEvaluator = evaluatorFactoryForSearch.getLearnerEvaluator();
        PipelineEvaluator classifierEvaluatorForSearch = new PipelineEvaluator(learnerFactory, (ISupervisedLearnerEvaluator<ILabeledInstance, ILabeledDataset<? extends ILabeledInstance>>)searchEvaluator, timeoutForCandidateEvaluation);
        if (safeGuardFactory != null) {
            safeGuardFactory.withEvaluator((ISupervisedLearnerEvaluator<ILabeledInstance, ILabeledDataset<? extends ILabeledInstance>>)searchEvaluator);
            try {
                IEvaluationSafeGuard safeGuard = safeGuardFactory.build();
                classifierEvaluatorForSearch.setSafeGuard(safeGuard);
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AlgorithmException("Could not build safe guard.", (Throwable)e);
            }
        }
        PipelineEvaluator classifierEvaluatorForSelection = dataShownToSelection != null ? new PipelineEvaluator(learnerFactory, (ISupervisedLearnerEvaluator<ILabeledInstance, ILabeledDataset<? extends ILabeledInstance>>)evaluatorFactoryForSelection.getLearnerEvaluator(), timeoutForCandidateEvaluation) : null;
        return new Pair((Object)classifierEvaluatorForSearch, (Object)classifierEvaluatorForSelection);
    }

    public static HASCOViaFDAndBestFirstWithRandomCompletionsBuilder getHASCOBuilder(MLPlanClassifierConfig algorithmConfig, ILabeledDataset<?> dataset, File searchSpaceFile, String requestedHASCOInterface, Predicate<TFDNode> priorizingPredicate, List<IPathEvaluator<TFDNode, String, Double>> preferredNodeEvaluators, PipelineValidityCheckingNodeEvaluator pipelineValidityCheckingNodeEvaluator, String nameOfMethod1, String nameOfMethod2) {
        RefinementConfiguredSoftwareConfigurationProblem problem;
        try {
            problem = new RefinementConfiguredSoftwareConfigurationProblem(searchSpaceFile, requestedHASCOInterface, null);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid configuration file " + searchSpaceFile, e);
        }
        HASCOViaFDAndBestFirstWithRandomCompletionsBuilder hascoBuilder = HASCOBuilder.get((RefinementConfiguredSoftwareConfigurationProblem)problem).withBestFirst().withRandomCompletions();
        ArrayList<Object> neChain = new ArrayList<Object>();
        if (pipelineValidityCheckingNodeEvaluator != null) {
            pipelineValidityCheckingNodeEvaluator.setComponents((Collection<? extends IComponent>)problem.getComponents());
            pipelineValidityCheckingNodeEvaluator.setData(dataset);
            neChain.add(pipelineValidityCheckingNodeEvaluator);
        }
        if (algorithmConfig.preferredComponents() != null && !algorithmConfig.preferredComponents().isEmpty()) {
            Objects.requireNonNull(nameOfMethod1, "First HASCO method must not be null!");
            Objects.requireNonNull(nameOfMethod2, "Second HASCO method must not be null!");
            neChain.add(new PreferenceBasedNodeEvaluator((Collection<? extends IComponent>)problem.getComponents(), algorithmConfig.preferredComponents(), nameOfMethod1, nameOfMethod2));
        }
        neChain.addAll(preferredNodeEvaluators);
        if (!neChain.isEmpty()) {
            IPathEvaluator preferredNodeEvaluator = (IPathEvaluator)neChain.remove(0);
            for (IPathEvaluator iPathEvaluator : neChain) {
                preferredNodeEvaluator = new AlternativeNodeEvaluator(preferredNodeEvaluator, iPathEvaluator);
            }
            hascoBuilder.withPreferredNodeEvaluator(preferredNodeEvaluator);
        }
        hascoBuilder.withNumSamples(algorithmConfig.numberOfRandomCompletions());
        hascoBuilder.withSeed(algorithmConfig.seed());
        hascoBuilder.withTimeoutForNode(new Timeout((long)algorithmConfig.timeoutForNodeEvaluation(), TimeUnit.MILLISECONDS));
        hascoBuilder.withTimeoutForSingleEvaluation(new Timeout((long)algorithmConfig.timeoutForCandidateEvaluation(), TimeUnit.MILLISECONDS));
        hascoBuilder.withPriorizingPredicate(priorizingPredicate);
        return hascoBuilder;
    }
}

