/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.core;

import ai.libs.jaicore.components.api.IComponentInstance;
import ai.libs.jaicore.components.exceptions.ComponentInstantiationFailedException;
import ai.libs.jaicore.components.model.ComponentInstance;
import ai.libs.jaicore.components.model.ComponentInstanceUtil;
import ai.libs.jaicore.ml.scikitwrapper.ScikitLearnWrapper;
import ai.libs.jaicore.timing.TimedObjectEvaluator;
import ai.libs.mlplan.core.ILearnerFactory;
import ai.libs.mlplan.core.TimeTrackingLearnerWrapper;
import ai.libs.mlplan.core.events.SupervisedLearnerCreatedEvent;
import ai.libs.mlplan.core.events.TimeTrackingLearnerEvaluationEvent;
import ai.libs.mlplan.safeguard.AlwaysEvaluateSafeGuard;
import ai.libs.mlplan.safeguard.EvaluationSafeGuardException;
import ai.libs.mlplan.safeguard.EvaluationSafeGuardFiredEvent;
import ai.libs.mlplan.safeguard.IEvaluationSafeGuard;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledDataset;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledInstance;
import org.api4.java.ai.ml.core.evaluation.ISupervisedLearnerEvaluator;
import org.api4.java.ai.ml.core.learner.ISupervisedLearner;
import org.api4.java.algorithm.Timeout;
import org.api4.java.common.attributedobjects.ObjectEvaluationFailedException;
import org.api4.java.common.control.ILoggingCustomizable;
import org.api4.java.common.event.IEvent;
import org.api4.java.common.event.IEventEmitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineEvaluator
extends TimedObjectEvaluator<IComponentInstance, Double>
implements ILoggingCustomizable {
    private static final String DEFAULT_PIPELINE_EVALUATOR_ID = "PipelineEvaluator";
    private String pipelineEvaluatorID = "PipelineEvaluator";
    private Logger logger = LoggerFactory.getLogger(PipelineEvaluator.class);
    private final EventBus eventBus = new EventBus();
    private final ILearnerFactory<? extends ISupervisedLearner<ILabeledInstance, ILabeledDataset<? extends ILabeledInstance>>> learnerFactory;
    private final ISupervisedLearnerEvaluator<ILabeledInstance, ILabeledDataset<? extends ILabeledInstance>> benchmark;
    private final Timeout timeoutForEvaluation;
    private IEvaluationSafeGuard safeGuard;

    public PipelineEvaluator(ILearnerFactory<? extends ISupervisedLearner<ILabeledInstance, ILabeledDataset<? extends ILabeledInstance>>> learnerFactory, ISupervisedLearnerEvaluator<ILabeledInstance, ILabeledDataset<? extends ILabeledInstance>> benchmark, Timeout timeoutForEvaluation) {
        this(learnerFactory, benchmark, timeoutForEvaluation, new AlwaysEvaluateSafeGuard());
    }

    public PipelineEvaluator(ILearnerFactory<? extends ISupervisedLearner<ILabeledInstance, ILabeledDataset<? extends ILabeledInstance>>> learnerFactory, ISupervisedLearnerEvaluator<ILabeledInstance, ILabeledDataset<? extends ILabeledInstance>> benchmark, Timeout timeoutForEvaluation, IEvaluationSafeGuard safeGuard) {
        this.learnerFactory = learnerFactory;
        this.benchmark = benchmark;
        if (benchmark instanceof IEventEmitter) {
            ((IEventEmitter)benchmark).registerListener((Object)this);
        }
        this.timeoutForEvaluation = timeoutForEvaluation;
        this.safeGuard = safeGuard;
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public void setLoggerName(String name) {
        this.logger.info("Switching logger name from {} to {}", (Object)this.logger.getName(), (Object)name);
        this.logger = LoggerFactory.getLogger((String)name);
        if (this.benchmark instanceof ILoggingCustomizable) {
            this.logger.info("Setting logger name of actual benchmark {} to {}.benchmark", (Object)this.benchmark.getClass().getName(), (Object)name);
            ((ILoggingCustomizable)this.benchmark).setLoggerName(name + ".benchmark");
        } else {
            this.logger.info("Benchmark {} does not implement ILoggingCustomizable, not customizing its logger.", (Object)this.benchmark.getClass().getName());
        }
    }

    public Double evaluateSupervised(IComponentInstance c) throws InterruptedException, ObjectEvaluationFailedException {
        this.logger.debug("Received request to evaluate component instance {}", (Object)c);
        this.logger.debug("Query evaluation safe guard whether to evaluate this component instance for the given timeout {}.", (Object)this.timeoutForEvaluation);
        try {
            if (!this.safeGuard.predictWillAdhereToTimeout(c, this.timeoutForEvaluation)) {
                this.eventBus.post((Object)new EvaluationSafeGuardFiredEvent(c));
                throw new EvaluationSafeGuardException("Evaluation safe guard prevents evaluation of component instance.", c);
            }
        }
        catch (EvaluationSafeGuardException | InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Could not use evaluation safe guard for component instance of {}. Continue with business as usual. Here is the stacktrace:", (Object)ComponentInstanceUtil.toComponentNameString((IComponentInstance)c), (Object)e);
        }
        try {
            this.logger.debug("Instantiate learner from component instance.");
            ISupervisedLearner learner = (ISupervisedLearner)this.learnerFactory.getComponentInstantiation(c);
            this.eventBus.post((Object)new SupervisedLearnerCreatedEvent(c, learner));
            TimeTrackingLearnerWrapper trackableLearner = new TimeTrackingLearnerWrapper(c, (ISupervisedLearner<ILabeledInstance, ILabeledDataset<? extends ILabeledInstance>>)learner);
            if (c instanceof ComponentInstance) {
                trackableLearner.setPredictedInductionTime(((ComponentInstance)c).getAnnotation("predictedInductionTime"));
                trackableLearner.setPredictedInferenceTime(((ComponentInstance)c).getAnnotation("predictedInferenceTime"));
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Starting benchmark {} for classifier {}", this.benchmark, (Object)(learner instanceof ScikitLearnWrapper ? learner.toString() : learner.getClass().getName()));
            }
            Double score = (Double)this.benchmark.evaluate((Object)trackableLearner);
            trackableLearner.setScore(score);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Obtained score {} for classifier {}", (Object)score, (Object)(learner instanceof ScikitLearnWrapper ? learner.toString() : learner.getClass().getName()));
            }
            this.eventBus.post((Object)new TimeTrackingLearnerEvaluationEvent(trackableLearner));
            this.safeGuard.updateWithActualInformation(c, trackableLearner);
            return score;
        }
        catch (ComponentInstantiationFailedException e) {
            throw new ObjectEvaluationFailedException("Evaluation of composition failed as the component instantiation could not be built.", (Throwable)e);
        }
    }

    public Timeout getTimeout(IComponentInstance item) {
        return this.timeoutForEvaluation;
    }

    public String getMessage(IComponentInstance item) {
        return "Pipeline evaluation phase";
    }

    public ISupervisedLearnerEvaluator<ILabeledInstance, ILabeledDataset<? extends ILabeledInstance>> getBenchmark() {
        return this.benchmark;
    }

    public void setSafeGuard(IEvaluationSafeGuard safeGuard) {
        this.safeGuard = safeGuard != null ? safeGuard : new AlwaysEvaluateSafeGuard();
    }

    public void setPipelineEvaluatorID(String pipelineEvaluatorID) {
        this.pipelineEvaluatorID = pipelineEvaluatorID;
    }

    public String getPipelineEvaluatorID() {
        return this.pipelineEvaluatorID;
    }

    public IEvaluationSafeGuard getSafeGuard() {
        return this.safeGuard;
    }

    public void registerListener(Object listener) {
        this.eventBus.register(listener);
    }

    @Subscribe
    public void receiveEvent(IEvent e) {
        this.eventBus.post((Object)e);
    }
}

