/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.core;

import ai.libs.jaicore.components.api.IComponent;
import ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.tfd.TFDNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.IPathEvaluator;
import org.api4.java.ai.ml.core.dataset.schema.attribute.IAttribute;
import org.api4.java.ai.ml.core.dataset.schema.attribute.ICategoricalAttribute;
import org.api4.java.ai.ml.core.dataset.schema.attribute.INumericAttribute;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledDataset;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledInstance;

public abstract class PipelineValidityCheckingNodeEvaluator
implements IPathEvaluator<TFDNode, String, Double> {
    private ILabeledDataset<?> data;
    private List<IComponent> components;
    protected boolean propertiesDetermined;
    protected boolean binaryClass;
    protected boolean multiClass;
    protected boolean regression;
    protected boolean multiValuedNominalAttributes;
    protected boolean containsNegativeValues;

    public PipelineValidityCheckingNodeEvaluator() {
    }

    public PipelineValidityCheckingNodeEvaluator(Collection<? extends IComponent> components, ILabeledDataset<?> data) {
        this.setComponents(components);
        this.setData(data);
        this.extractDatasetProperties();
    }

    protected synchronized void extractDatasetProperties() {
        if (!this.propertiesDetermined) {
            if (this.getComponents() == null) {
                throw new IllegalStateException("Components not defined!");
            }
            this.binaryClass = this.getData().getLabelAttribute() instanceof ICategoricalAttribute && ((ICategoricalAttribute)this.getData().getLabelAttribute()).getNumberOfCategories() == 2;
            this.multiClass = this.getData().getLabelAttribute() instanceof ICategoricalAttribute && ((ICategoricalAttribute)this.getData().getLabelAttribute()).getNumberOfCategories() > 2;
            this.regression = this.getData().getLabelAttribute() instanceof INumericAttribute;
            this.multiValuedNominalAttributes = false;
            for (IAttribute att : this.getData().getListOfAttributes()) {
                if (!(att instanceof ICategoricalAttribute) || ((ICategoricalAttribute)att).getNumberOfCategories() <= 2) continue;
                this.multiValuedNominalAttributes = true;
                break;
            }
            this.containsNegativeValues = false;
            for (ILabeledInstance i : this.getData()) {
                boolean bl = this.containsNegativeValues = this.containsNegativeValues || Arrays.stream(i.getPoint()).anyMatch(x -> x < 0.0);
                if (!this.containsNegativeValues) continue;
                break;
            }
            this.propertiesDetermined = true;
        }
    }

    public void setData(ILabeledDataset<?> data) {
        Objects.requireNonNull(data);
        this.data = data;
    }

    public void setComponents(Collection<? extends IComponent> components) {
        Objects.requireNonNull(components);
        this.components = new ArrayList<IComponent>(components);
    }

    public ILabeledDataset<?> getData() {
        return this.data;
    }

    public Collection<IComponent> getComponents() {
        return this.components;
    }
}

