/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.core;

import ai.libs.hasco.core.HASCOUtil;
import ai.libs.jaicore.components.api.IComponent;
import ai.libs.jaicore.components.api.IComponentInstance;
import ai.libs.jaicore.components.model.ComponentInstance;
import ai.libs.jaicore.components.serialization.ComponentSerialization;
import ai.libs.jaicore.logic.fol.structure.Monom;
import ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.tfd.TFDNode;
import ai.libs.jaicore.search.model.travesaltree.BackPointerPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.IPathEvaluator;
import org.api4.java.common.control.ILoggingCustomizable;
import org.api4.java.datastructure.graph.ILabeledPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferenceBasedNodeEvaluator
implements IPathEvaluator<TFDNode, String, Double>,
ILoggingCustomizable {
    private static final double EXPAND_NODE_SCORE = -1.7976931348623157E308;
    private final Collection<IComponent> components;
    private final List<String> orderingOfComponents;
    private final String nameOfMethodToResolveBareLearner;
    private final String nameOfMethodToResolveLearnerInPipeline;
    private Logger logger = LoggerFactory.getLogger(PreferenceBasedNodeEvaluator.class);
    private boolean sentLogMessageForHavingEnteredSecondSubPhase = false;

    public PreferenceBasedNodeEvaluator(Collection<? extends IComponent> components, List<String> orderingOfComponents, String nameOfMethodToResolveBareLearner, String nameOfMethodToResolveLearnerInPipeline) {
        this.components = new ArrayList<IComponent>(components);
        this.orderingOfComponents = orderingOfComponents;
        this.nameOfMethodToResolveBareLearner = nameOfMethodToResolveBareLearner;
        this.nameOfMethodToResolveLearnerInPipeline = nameOfMethodToResolveLearnerInPipeline;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Double evaluate(ILabeledPath<TFDNode, String> n) {
        this.logger.info("Received request for node evaluation.");
        LinkedList<String> appliedMethods = new LinkedList<String>();
        for (TFDNode x2 : n.getNodes()) {
            if (x2.getAppliedMethodInstance() == null) continue;
            appliedMethods.add(x2.getAppliedMethodInstance().getMethod().getName());
        }
        this.logger.debug("Determined {} applied methods: {}", (Object)appliedMethods.size(), appliedMethods);
        ComponentInstance instance = HASCOUtil.getSolutionCompositionFromState(this.components, (Monom)((TFDNode)n.getHead()).getState(), (boolean)false);
        boolean isPipeline = appliedMethods.stream().anyMatch(x -> x.toLowerCase().contains("pipeline"));
        String classifierName = null;
        if (instance == null) {
            this.logger.info("No decision recognizable *in state* yet, returning 0.0");
            return -1.7976931348623157E308;
        }
        String nameOfLastAppliedMethod = (String)appliedMethods.get(appliedMethods.size() - 1);
        String compactStringOfCI = new ComponentSerialization().serialize((IComponentInstance)instance).toString();
        this.logger.debug("The associated component instance is {}. Constitutes a pipeline? {}. Name of last applied method: {}", new Object[]{compactStringOfCI, isPipeline ? "yes" : "no", nameOfLastAppliedMethod});
        Double score = -1.7976931348623157E308;
        boolean lastMethodBeforeSteppingToRandomCompletions = false;
        if (instance.getComponent().getName().toLowerCase().contains("pipeline")) {
            lastMethodBeforeSteppingToRandomCompletions = nameOfLastAppliedMethod.startsWith(this.nameOfMethodToResolveLearnerInPipeline);
            if (instance.getSatisfactionOfRequiredInterfaces().containsKey("classifier")) {
                classifierName = ((IComponentInstance)instance.getSatisfactionOfRequiredInterface("classifier").iterator().next()).getComponent().getName();
            } else {
                if (!instance.getSatisfactionOfRequiredInterfaces().containsKey("regressor")) {
                    this.logger.debug("Exact decision about pipeline fillup not recognizable in state yet. Returning {}.", (Object)-1.7976931348623157E308);
                    return -1.7976931348623157E308;
                }
                classifierName = ((IComponentInstance)instance.getSatisfactionOfRequiredInterface("regressor").iterator().next()).getComponent().getName();
            }
        } else {
            classifierName = instance.getComponent().getName();
            lastMethodBeforeSteppingToRandomCompletions = nameOfLastAppliedMethod.startsWith(this.nameOfMethodToResolveBareLearner);
        }
        this.logger.debug("Identified classifier {}.", (Object)classifierName);
        if (lastMethodBeforeSteppingToRandomCompletions) {
            if (isPipeline) {
                score = score / Math.pow(10.0, this.orderingOfComponents.size() + 1);
            }
            score = score / Math.pow(10.0, this.orderingOfComponents.contains(classifierName) ? this.orderingOfComponents.indexOf(classifierName) + 1 : this.orderingOfComponents.size() + 1);
        } else {
            score = null;
            if (!this.sentLogMessageForHavingEnteredSecondSubPhase) {
                double d;
                double scoreOfParent = (Double)((BackPointerPath)n.getPathToParentOfHead()).getScore();
                if (d > -1.7976931348623157E208) {
                    this.sentLogMessageForHavingEnteredSecondSubPhase = true;
                    this.logger.info("Entering phase 1b! Breadth first search ends here, because the search is asking for the f-value of a node whose parent has been truely evaluated with an f-value of {}", (Object)scoreOfParent);
                }
            }
        }
        this.logger.info("Returning score {} for instance {}", (Object)score, (Object)compactStringOfCI);
        return score;
    }

    public String toString() {
        return "PreferenceBasedNodeEvaluator [ORDERING_OF_CLASSIFIERS=" + this.orderingOfComponents + "]";
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public void setLoggerName(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
    }
}

