/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.core.events;

import ai.libs.jaicore.components.api.IComponentInstance;
import ai.libs.mlplan.core.ITimeTrackingLearner;
import org.api4.java.ai.ml.core.learner.ISupervisedLearner;
import org.api4.java.common.event.IEvent;

public class TimeTrackingLearnerEvaluationEvent
implements IEvent {
    private final long timestamp = System.currentTimeMillis();
    private final IComponentInstance ci;
    private final ISupervisedLearner<?, ?> learner;
    private final Double actualFitTime;
    private final Double actualPredictTime;
    private final Double predictedFitTime;
    private final Double predictedPredictTime;
    private final Double score;

    public String toString() {
        return "CI " + this.ci + " " + this.actualFitTime + " " + this.actualPredictTime + " " + this.predictedFitTime + " " + this.predictedPredictTime + " " + this.score;
    }

    public TimeTrackingLearnerEvaluationEvent(ITimeTrackingLearner timeTrackingLearner) {
        this.ci = timeTrackingLearner.getComponentInstance();
        this.learner = timeTrackingLearner;
        this.actualFitTime = !timeTrackingLearner.getFitTimes().isEmpty() ? Double.valueOf(timeTrackingLearner.getFitTimes().stream().mapToDouble(x -> x.longValue()).average().getAsDouble() / 1000.0) : null;
        this.actualPredictTime = !timeTrackingLearner.getBatchPredictionTimesInMS().isEmpty() ? Double.valueOf(timeTrackingLearner.getBatchPredictionTimesInMS().stream().mapToDouble(x -> x.longValue()).average().getAsDouble() / 1000.0) : null;
        this.predictedFitTime = timeTrackingLearner.getPredictedInductionTime();
        this.predictedPredictTime = timeTrackingLearner.getPredictedInferenceTime();
        this.score = timeTrackingLearner.getScore();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public IComponentInstance getComponentInstance() {
        return this.ci;
    }

    public ISupervisedLearner<?, ?> getLearner() {
        return this.learner;
    }

    public Double getActualFitTime() {
        return this.actualFitTime;
    }

    public Double getActualPredictTime() {
        return this.actualPredictTime;
    }

    public Double getPredictedFitTime() {
        return this.predictedFitTime;
    }

    public Double getPredictedPredictTime() {
        return this.predictedPredictTime;
    }

    public Double getScore() {
        return this.score;
    }
}

