/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.metamining;

import ai.libs.hasco.metamining.IMetaMiner;
import ai.libs.jaicore.components.model.Component;
import ai.libs.jaicore.components.model.ComponentInstance;
import ai.libs.jaicore.components.model.Parameter;
import ai.libs.jaicore.components.model.ParameterRefinementConfiguration;
import ai.libs.mlplan.metamining.WEKAMetaminerRuntimeException;
import ai.libs.mlplan.metamining.pipelinecharacterizing.IPipelineCharacterizer;
import ai.libs.mlplan.metamining.pipelinecharacterizing.WEKAPipelineCharacterizer;
import ai.libs.mlplan.metamining.similaritymeasures.F3Optimizer;
import ai.libs.mlplan.metamining.similaritymeasures.IHeterogenousSimilarityMeasureComputer;
import ai.libs.mlplan.metamining.similaritymeasures.IRelativeRankMatrixComputer;
import ai.libs.mlplan.metamining.similaritymeasures.RelativeRankMatricComputer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.api4.java.algorithm.exceptions.AlgorithmException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.core.Attribute;
import weka.core.Instances;

public class WEKAMetaminer
implements IMetaMiner {
    private Logger logger = LoggerFactory.getLogger(WEKAMetaminer.class);
    private boolean hasBeenBuilt = false;
    private INDArray datasetMetafeatures;
    private Enumeration<Attribute> dataSetMetaFeaturesAttributes;
    private IHeterogenousSimilarityMeasureComputer similarityMeasure = new F3Optimizer(0.1);
    private IRelativeRankMatrixComputer similarityComputer = new RelativeRankMatricComputer();
    private IPipelineCharacterizer pipelineCharacterizer;

    public WEKAMetaminer(Map<Component, Map<Parameter, ParameterRefinementConfiguration>> paramConfigs) {
        this.pipelineCharacterizer = new WEKAPipelineCharacterizer(paramConfigs);
    }

    public double score(ComponentInstance componentInstance) {
        if (!this.hasBeenBuilt) {
            throw new WEKAMetaminerRuntimeException("Metaminer has not been built!");
        }
        if (this.dataSetMetaFeaturesAttributes == null) {
            throw new WEKAMetaminerRuntimeException("Metaminer has not been given a data set characterization!");
        }
        double[] pipelineMetafeatures = this.pipelineCharacterizer.characterize(componentInstance);
        return this.similarityMeasure.computeSimilarity(this.datasetMetafeatures, Nd4j.create((double[])pipelineMetafeatures));
    }

    public void build(List<ComponentInstance> distinctPipelines, Instances metaFeatureInformation, double[][][] performanceValues) throws AlgorithmException, InterruptedException {
        if (this.hasBeenBuilt) {
            throw new AlgorithmException("MetaMiner has already been built!");
        }
        this.dataSetMetaFeaturesAttributes = metaFeatureInformation.enumerateAttributes();
        INDArray datasetsMetafeatures = Nd4j.create((int)metaFeatureInformation.size(), (int)metaFeatureInformation.numAttributes());
        for (int i = 0; i < metaFeatureInformation.size(); ++i) {
            datasetsMetafeatures.putRow((long)i, Nd4j.create((double[])metaFeatureInformation.get(i).toDoubleArray()));
        }
        this.logger.debug("Dataset metafeatures: {} x {}", (Object)datasetsMetafeatures.rows(), (Object)datasetsMetafeatures.columns());
        this.logger.info("Computing relative performance Matrix.");
        INDArray rankMatrix = this.similarityComputer.computeRelativeRankMatrix(performanceValues);
        this.logger.info("Rank matrix: {} x {}", (Object)rankMatrix.rows(), (Object)rankMatrix.columns());
        this.logger.debug("Rank Matrix: {}", (Object)rankMatrix);
        this.logger.info("WEKAMetaminer: Initializing pipeline characterizer.");
        this.pipelineCharacterizer.build(distinctPipelines);
        INDArray pipelinesMetafeatures = Nd4j.create((double[][])this.pipelineCharacterizer.getCharacterizationsOfTrainingExamples());
        this.logger.debug("WEKAMetaminer: Pipeline Metafeatures: {} x {}", (Object)pipelinesMetafeatures.rows(), (Object)pipelinesMetafeatures.columns());
        this.logger.info("WEKAMetaminer: Create similarity measure.");
        this.similarityMeasure.build(datasetsMetafeatures, pipelinesMetafeatures, rankMatrix);
        this.hasBeenBuilt = true;
    }

    public void setDataSetCharacterization(Map<String, Double> datasetCharacterization) {
        this.datasetMetafeatures = Nd4j.create((int)datasetCharacterization.size());
        ArrayList<Attribute> attributes = Collections.list(this.dataSetMetaFeaturesAttributes);
        for (int i = 0; i < attributes.size(); ++i) {
            this.datasetMetafeatures.putScalar((long)i, datasetCharacterization.get(((Attribute)attributes.get(i)).name()).doubleValue());
        }
    }

    public IHeterogenousSimilarityMeasureComputer getSimilarityMeasure() {
        return this.similarityMeasure;
    }

    public void setSimilarityMeasure(IHeterogenousSimilarityMeasureComputer similarityMeasure) {
        this.similarityMeasure = similarityMeasure;
    }

    public IPipelineCharacterizer getPipelineCharacterizer() {
        return this.pipelineCharacterizer;
    }

    public void setPipelineCharacterizer(IPipelineCharacterizer pipelineCharacterizer) {
        this.pipelineCharacterizer = pipelineCharacterizer;
    }
}

