/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.metamining.databaseconnection;

import ai.libs.jaicore.components.model.ComponentInstance;
import ai.libs.jaicore.components.serialization.ComponentNotFoundException;
import ai.libs.jaicore.db.sql.SQLAdapter;
import ai.libs.jaicore.logging.LoggerUtil;
import ai.libs.jaicore.ml.weka.classification.pipeline.MLPipeline;
import ai.libs.mlplan.multiclass.wekamlplan.weka.MLPipelineComponentInstanceFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.api4.java.datastructure.kvstore.IKVStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.classifiers.AbstractClassifier;

public class ComponentInstanceDatabaseGetter
extends Thread {
    private Logger logger = LoggerFactory.getLogger(ComponentInstanceDatabaseGetter.class);
    private List<ComponentInstance> pipelines;
    private List<HashMap<String, List<Double>>> pipelinePerformances;
    private int offset;
    private int limit;
    private SQLAdapter adapter;
    private MLPipelineComponentInstanceFactory factory;
    private boolean finishedSuccessfully = false;

    @Override
    public void run() {
        String query = "SELECT searcher, evaluator, classifier, GROUP_CONCAT( CONCAT (dataset_id, ':', dataset_origin, ',', error_rate) SEPARATOR ';') AS results FROM basePipelineEvals GROUP BY searcher, evaluator, classifier ORDER BY searcher, evaluator, classifier LIMIT " + this.limit + " OFFSET " + this.offset;
        try {
            this.pipelines = new ArrayList<ComponentInstance>(this.limit);
            this.pipelinePerformances = new ArrayList<HashMap<String, List<Double>>>(this.limit);
            List resultSet = this.adapter.getResultsOfQuery(query);
            this.logger.debug("ComponentInstanceDatabaseGetter: Thread {} got pipelines from data base.", (Object)this.getId());
            for (IKVStore store : resultSet) {
                this.next(store);
            }
        }
        catch (Exception e1) {
            this.logger.error("Thread {} could not finish getting all pipelines. Cause: {}", (Object)this.getId(), (Object)e1.getMessage());
            return;
        }
        this.finishedSuccessfully = true;
    }

    private void next(IKVStore resultSet) throws Exception {
        try {
            ComponentInstance ci = resultSet.getAsString("searcher") != null && resultSet.getAsString("evaluator") != null ? this.factory.convertToComponentInstance(new MLPipeline(ASSearch.forName((String)resultSet.getAsString("searcher"), null), ASEvaluation.forName((String)resultSet.getAsString("evaluator"), null), AbstractClassifier.forName((String)resultSet.getAsString("classifier"), null))) : this.factory.convertToComponentInstance(new MLPipeline(new ArrayList(), AbstractClassifier.forName((String)resultSet.getAsString("classifier"), null)));
            String[] results = resultSet.getAsString("results").split(";");
            HashMap datasetPerformances = new HashMap();
            for (int j = 0; j < results.length; ++j) {
                String[] errorRatePerformance = results[j].split(",");
                if (!datasetPerformances.containsKey(errorRatePerformance[0])) {
                    datasetPerformances.put(errorRatePerformance[0], new ArrayList());
                }
                if (errorRatePerformance.length <= 1) continue;
                ((List)datasetPerformances.get(errorRatePerformance[0])).add(Double.parseDouble(errorRatePerformance[1]));
            }
            this.pipelines.add(ci);
            this.pipelinePerformances.add(datasetPerformances);
        }
        catch (ComponentNotFoundException e) {
            this.logger.warn("Could not convert component due to {}", (Object)LoggerUtil.getExceptionInfo((Throwable)e));
        }
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setAdapter(SQLAdapter adapter) {
        this.adapter = adapter;
    }

    public void setFactory(MLPipelineComponentInstanceFactory factory) {
        this.factory = factory;
    }

    public List<ComponentInstance> getPipelines() {
        return this.pipelines;
    }

    public List<HashMap<String, List<Double>>> getPipelinePerformances() {
        return this.pipelinePerformances;
    }

    public boolean isFinishedSuccessfully() {
        return this.finishedSuccessfully;
    }
}

