/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.metamining.databaseconnection;

import ai.libs.jaicore.components.model.ComponentInstance;
import ai.libs.jaicore.db.sql.SQLAdapter;
import ai.libs.mlplan.metamining.databaseconnection.ComponentInstanceDatabaseGetter;
import ai.libs.mlplan.multiclass.wekamlplan.weka.MLPipelineComponentInstanceFactory;
import dataHandling.mySQL.MetaDataDataBaseConnection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.api4.java.datastructure.kvstore.IKVStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.core.Instances;

public class ExperimentRepository {
    private Logger logger = LoggerFactory.getLogger(ExperimentRepository.class);
    private SQLAdapter adapter;
    private String host;
    private String user;
    private String password;
    private MLPipelineComponentInstanceFactory factory;
    private int cpus;
    private String metaFeatureSetName;
    private String datasetSetName;
    private Integer limit;
    private List<HashMap<String, List<Double>>> pipelinePerformances = new ArrayList<HashMap<String, List<Double>>>();
    private MetaDataDataBaseConnection metaDataBaseConnection;

    public ExperimentRepository(String host, String user, String password, MLPipelineComponentInstanceFactory factory, int cpus, String metaFeatureSetName, String datasetSetName) {
        this.user = user;
        this.password = password;
        this.host = host;
        this.factory = factory;
        this.cpus = cpus;
        this.metaDataBaseConnection = new MetaDataDataBaseConnection(host, user, password, "hgraf");
        this.metaFeatureSetName = metaFeatureSetName;
        this.datasetSetName = datasetSetName;
    }

    public List<ComponentInstance> getDistinctPipelines() throws SQLException, InterruptedException {
        this.connect();
        String query = "SELECT (COUNT(DISTINCT searcher, evaluator, classifier)) FROM basePipelineEvals";
        List resultSet = this.adapter.getResultsOfQuery(query);
        int distinctPipelineCount = ((IKVStore)resultSet.get(0)).getAsInt("(COUNT(DISTINCT searcher, evaluator, classifier))");
        distinctPipelineCount = this.limit == null ? distinctPipelineCount : this.limit;
        this.logger.info("Getting {} distinct pipelines.", (Object)distinctPipelineCount);
        int chunkSize = Math.floorDiv(distinctPipelineCount, this.cpus);
        int lastchunkSize = distinctPipelineCount - chunkSize * (this.cpus - 1);
        this.logger.debug("ExperimentRepository: Allocate Getter-Threads.");
        ComponentInstanceDatabaseGetter[] threads = new ComponentInstanceDatabaseGetter[this.cpus];
        for (int i = 0; i < threads.length; ++i) {
            threads[i] = new ComponentInstanceDatabaseGetter();
            threads[i].setAdapter(this.adapter);
            threads[i].setOffset(i * chunkSize);
            threads[i].setLimit(i == threads.length - 1 ? lastchunkSize : chunkSize);
            threads[i].setFactory(this.factory);
            threads[i].start();
        }
        ArrayList<ComponentInstance> pipelines = new ArrayList<ComponentInstance>();
        for (int i = 0; i < threads.length; ++i) {
            threads[i].join();
            pipelines.addAll(threads[i].getPipelines());
            this.pipelinePerformances.addAll(threads[i].getPipelinePerformances());
        }
        boolean allSuccessful = true;
        for (int i = 0; i < threads.length; ++i) {
            this.logger.debug("Thread {} finished succuesfully: {}", (Object)threads[i].getId(), (Object)threads[i].isFinishedSuccessfully());
            if (threads[i].isFinishedSuccessfully()) continue;
            allSuccessful = false;
        }
        if (!allSuccessful) {
            this.logger.error("Not all threads finished the download successfully!");
        } else {
            this.logger.info("All threads finished successfully.");
        }
        this.disconnect();
        return pipelines;
    }

    public Instances getDatasetCahracterizations() throws SQLException {
        this.logger.info("Downloading dataset characterizations.");
        Instances metaData = this.metaDataBaseConnection.getMetaDataSetForDataSetSet(this.datasetSetName, this.metaFeatureSetName);
        metaData.deleteAttributeAt(0);
        return metaData;
    }

    public double[][][] getPipelineResultsOnDatasets() throws SQLException {
        this.logger.info("Downloading pipeline results for datasets.");
        ArrayList datasets = this.metaDataBaseConnection.getMembersOfDatasetSet(this.datasetSetName);
        double[][][] results = new double[datasets.size()][this.pipelinePerformances.size()][];
        for (int j = 0; j < datasets.size(); ++j) {
            String dataset = (String)datasets.get(j);
            for (int i = 0; i < this.pipelinePerformances.size(); ++i) {
                List<Double> datasetResults = this.pipelinePerformances.get(i).get(dataset);
                if (datasetResults == null || datasetResults.isEmpty()) continue;
                results[j][i] = datasetResults.stream().mapToDouble(value -> value).toArray();
            }
        }
        return results;
    }

    private void connect() {
        this.adapter = new SQLAdapter(this.host, this.user, this.password, "pgotfml_hgraf");
    }

    private void disconnect() {
        this.adapter.close();
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }
}

