/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.metamining.pipelinecharacterizing;

import ai.libs.jaicore.components.model.CategoricalParameterDomain;
import ai.libs.jaicore.components.model.Component;
import ai.libs.jaicore.components.model.ComponentInstance;
import ai.libs.jaicore.components.model.Parameter;
import ai.libs.jaicore.math.linearalgebra.DenseDoubleVector;
import ai.libs.mlplan.metamining.pipelinecharacterizing.IPipelineCharacterizer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.api4.java.common.math.IVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentInstanceVectorFeatureGenerator
implements IPipelineCharacterizer {
    private static final Logger logger = LoggerFactory.getLogger(ComponentInstanceVectorFeatureGenerator.class);
    private Map<String, Map<String, Integer>> componentNameToParameterDyadIndex = new HashMap<String, Map<String, Integer>>();
    private Map<String, Integer> componentNameToDyadIndex = new HashMap<String, Integer>();
    private int patternCount;

    public ComponentInstanceVectorFeatureGenerator(Collection<Component> collection) {
        int counter = 0;
        logger.debug("Got {} components as input.", (Object)collection.size());
        for (Component component : collection) {
            logger.debug("Inserting {} at position {}", (Object)component.getName(), (Object)counter);
            this.componentNameToDyadIndex.put(component.getName(), counter++);
            HashMap<String, Integer> parameterIndices = new HashMap<String, Integer>();
            logger.debug("{} has {} parameters.", (Object)component.getName(), (Object)component.getParameters().size());
            for (Parameter param : component.getParameters()) {
                if (param.isNumeric()) {
                    parameterIndices.put(param.getName(), counter++);
                    continue;
                }
                if (!param.isCategorical()) continue;
                parameterIndices.put(param.getName(), counter);
                CategoricalParameterDomain domain = (CategoricalParameterDomain)param.getDefaultDomain();
                counter += domain.getValues().length;
            }
            this.componentNameToParameterDyadIndex.put(component.getName(), parameterIndices);
        }
        this.patternCount = counter;
    }

    public double[] characterize(ComponentInstance cI, IVector patterns) {
        Component c = cI.getComponent();
        String componentName = c.getName();
        int index = this.componentNameToDyadIndex.get(componentName);
        patterns.setValue(index, 1.0);
        Map<String, Integer> parameterIndices = this.componentNameToParameterDyadIndex.get(componentName);
        for (Parameter param : c.getParameters()) {
            String parameterName = param.getName();
            int parameterIndex = parameterIndices.get(parameterName);
            if (param.isNumeric()) {
                this.handleNumericalParameter(cI, patterns, param, parameterIndex);
                continue;
            }
            if (!param.isCategorical()) continue;
            this.handleCatergoricalParameter(cI, patterns, param, parameterIndex);
        }
        for (ComponentInstance requiredInterface : cI.getSatisfactionOfRequiredInterfaces().values()) {
            this.characterize(requiredInterface, patterns);
        }
        return patterns.asArray();
    }

    private void handleNumericalParameter(ComponentInstance cI, IVector patterns, Parameter param, int parameterIndex) {
        if (cI.getParameterValue(param) != null) {
            double value = Double.parseDouble(cI.getParameterValue(param));
            patterns.setValue(parameterIndex, value);
        } else {
            double value = (Double)param.getDefaultValue();
            patterns.setValue(parameterIndex, value);
        }
    }

    private void handleCatergoricalParameter(ComponentInstance cI, IVector patterns, Parameter param, int parameterIndex) {
        String parameterValue = cI.getParameterValue(param);
        if (parameterValue == null) {
            parameterValue = param.getDefaultValue() instanceof String ? (String)param.getDefaultValue() : String.valueOf(param.getDefaultValue());
        }
        CategoricalParameterDomain domain = (CategoricalParameterDomain)param.getDefaultDomain();
        for (int i = 0; i < domain.getValues().length; ++i) {
            if (domain.getValues()[i].equals(parameterValue)) {
                patterns.setValue(parameterIndex + i, 1.0);
                continue;
            }
            patterns.setValue(parameterIndex + i, 0.0);
        }
    }

    @Override
    public void build(List<ComponentInstance> pipelines) throws InterruptedException {
        throw new UnsupportedOperationException("This characterizer is not trained!");
    }

    @Override
    public double[] characterize(ComponentInstance pipeline) {
        return this.characterize(pipeline, (IVector)new DenseDoubleVector(this.patternCount, 0.0));
    }

    @Override
    public double[][] getCharacterizationsOfTrainingExamples() {
        throw new UnsupportedOperationException("This characterizer is not trained!");
    }

    @Override
    public int getLengthOfCharacterization() {
        return this.patternCount;
    }
}

