/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.metamining.pipelinecharacterizing;

import ai.libs.jaicore.components.model.Component;
import ai.libs.jaicore.components.model.ComponentInstance;
import ai.libs.jaicore.components.model.Parameter;
import ai.libs.jaicore.components.model.ParameterRefinementConfiguration;
import ai.libs.mlplan.metamining.pipelinecharacterizing.ComponentInstanceStringConverter;
import ai.libs.mlplan.metamining.pipelinecharacterizing.IOntologyConnector;
import ai.libs.mlplan.metamining.pipelinecharacterizing.IPipelineCharacterizer;
import ai.libs.mlplan.metamining.pipelinecharacterizing.OntologyNotFoundException;
import ai.libs.mlplan.metamining.pipelinecharacterizing.WEKAOntologyConnector;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import treeminer.FrequentSubtreeFinder;
import treeminer.TreeMiner;
import treeminer.util.TreeRepresentationUtils;

public class WEKAPipelineCharacterizer
implements IPipelineCharacterizer {
    private static final Logger logger = LoggerFactory.getLogger(WEKAPipelineCharacterizer.class);
    private static final String ALGORITHM_PATTERNS_SUPPORT_5_PATH = "draco/patterns_support_5.csv";
    private int cpus = 1;
    private IOntologyConnector ontologyConnector;
    private FrequentSubtreeFinder treeMiner;
    private List<String> foundPipelinePatterns;
    private int patternMinSupport = 5;
    private Map<Component, Map<Parameter, ParameterRefinementConfiguration>> componentParameters;

    public WEKAPipelineCharacterizer(Map<Component, Map<Parameter, ParameterRefinementConfiguration>> componentParameters) {
        TreeMiner miner = new TreeMiner();
        miner.setCountMultipleOccurrences(false);
        miner.setOnlySearchForPatternsThatStartWithTheRoot(true);
        this.treeMiner = new TreeMiner();
        this.componentParameters = componentParameters;
        try {
            this.ontologyConnector = new WEKAOntologyConnector();
        }
        catch (OWLOntologyCreationException e) {
            logger.error("Cannot connect to Ontology!");
            throw new OntologyNotFoundException(e);
        }
    }

    public void buildFromFile(File file) {
        ArrayList<String> foundPatterns = new ArrayList<String>();
        try (Scanner scanner = new Scanner(file);){
            while (scanner.hasNextLine()) {
                String pattern = scanner.nextLine();
                foundPatterns.add(pattern);
            }
        }
        catch (IOException e) {
            logger.error("Couldn't initialize pipeline characterizer", (Throwable)e);
        }
        this.foundPipelinePatterns = foundPatterns;
    }

    public void buildFromFile() {
        try {
            this.buildFromFile(Paths.get(this.getClass().getClassLoader().getResource(ALGORITHM_PATTERNS_SUPPORT_5_PATH).toURI()).toFile());
        }
        catch (URISyntaxException e) {
            logger.error("Couldn't find default algorithm patterns!", (Throwable)e);
        }
    }

    @Override
    public void build(List<ComponentInstance> pipelines) throws InterruptedException {
        logger.info("Converting training examples to trees. With support {}", (Object)this.patternMinSupport);
        int chunkSize = Math.floorDiv(pipelines.size(), this.cpus);
        int lastchunkSize = pipelines.size() - chunkSize * (this.cpus - 1);
        ComponentInstanceStringConverter[] threads = new ComponentInstanceStringConverter[this.cpus];
        for (int i = 0; i < threads.length; ++i) {
            threads[i] = new ComponentInstanceStringConverter(this.ontologyConnector, pipelines.subList(i * chunkSize, i == threads.length - 1 ? i * chunkSize + lastchunkSize : (i + 1) * chunkSize), this.componentParameters);
            threads[i].start();
        }
        ArrayList<String> pipelineRepresentations = new ArrayList<String>(pipelines.size());
        for (int i = 0; i < threads.length; ++i) {
            threads[i].join();
            pipelineRepresentations.addAll(threads[i].getConvertedPipelines());
        }
        logger.info("Finding frequent subtrees");
        this.foundPipelinePatterns = this.treeMiner.findFrequentSubtrees(pipelineRepresentations, this.patternMinSupport);
    }

    @Override
    public double[] characterize(ComponentInstance pipeline) {
        String treeRepresentation = new ComponentInstanceStringConverter(this.ontologyConnector, new ArrayList<ComponentInstance>(), this.componentParameters).makeStringTreeRepresentation(pipeline);
        double[] pipelineCharacterization = new double[this.foundPipelinePatterns.size()];
        for (int i = 0; i < this.foundPipelinePatterns.size(); ++i) {
            pipelineCharacterization[i] = TreeRepresentationUtils.containsSubtree((String)treeRepresentation, (String)this.foundPipelinePatterns.get(i)) ? 1.0 : 0.0;
        }
        return pipelineCharacterization;
    }

    @Override
    public double[][] getCharacterizationsOfTrainingExamples() {
        return this.treeMiner.getCharacterizationsOfTrainingExamples();
    }

    @Override
    public int getLengthOfCharacterization() {
        return this.foundPipelinePatterns.size();
    }

    public IOntologyConnector getOntologyConnector() {
        return this.ontologyConnector;
    }

    public void setOntologyConnector(IOntologyConnector ontologyConnector) {
        this.ontologyConnector = ontologyConnector;
    }

    public int getMinSupport() {
        return this.patternMinSupport;
    }

    public void setMinSupport(int minSupport) {
        this.patternMinSupport = minSupport;
    }

    public void setCPUs(int cpus) {
        this.cpus = cpus;
    }

    public List<String> getFoundPipelinePatterns() {
        return this.foundPipelinePatterns;
    }
}

