/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.metamining.dyadranking;

import org.aeonbits.owner.Config;
import org.aeonbits.owner.Mutable;

@Config.Sources(value={"file:conf/draco/dyadranking/nodeevaluator.properties"})
public interface DyadRankingBasedNodeEvaluatorConfig
extends Mutable {
    public static final String NUM_EVALUATIONS_KEY = "numEval";
    public static final String NUM_SAMPLES_KEY = "numSamples";
    public static final String SEED_KEY = "seed";
    public static final String PLNET_ZIP_KEY = "plnetPath";
    public static final String SCALER_SER_KEY = "scalerPath";
    public static final String LANDMARKERS_KEY = "landmarkers";
    public static final String LANDMARKERS_SAMPLE_SIZE_KEY = "landmarkerSampleSize";
    public static final String USE_LANDMARKERS = "useLandmarkers";
    public static final String USE_EVALUATIONS = "useEvaluations";

    @Config.Key(value="numEval")
    @Config.DefaultValue(value="10")
    public int getNumberOfEvaluations();

    @Config.Key(value="numSamples")
    @Config.DefaultValue(value="20")
    public int getNumberOfRandomSamples();

    @Config.Key(value="seed")
    @Config.DefaultValue(value="42")
    public int getSeed();

    @Config.Key(value="plnetPath")
    @Config.DefaultValue(value="resources/draco/plnet/final_plnet_minmax.zip")
    public String getPlNetPath();

    @Config.Key(value="landmarkers")
    @Config.Separator(value=";")
    @Config.DefaultValue(value="4; 8; 16")
    public int[] getLandmarkers();

    @Config.Key(value="landmarkerSampleSize")
    @Config.DefaultValue(value="10")
    public int getLandmarkerSampleSize();

    @Config.Key(value="useLandmarkers")
    @Config.DefaultValue(value="false")
    public boolean useLandmarkers();

    @Config.Key(value="useEvaluations")
    @Config.DefaultValue(value="true")
    public boolean useEvaluations();

    @Config.Key(value="scalerPath")
    @Config.DefaultValue(value="resources/draco/plnet/minmaxscaler.ser")
    public String scalerPath();
}

