/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.metamining.pipelinecharacterizing;

import ai.libs.jaicore.math.linearalgebra.DenseDoubleVector;
import ai.libs.jaicore.ml.weka.classification.singlelabel.timeseries.learner.trees.AccessibleRandomTree;
import ai.libs.mlplan.metamining.pipelinecharacterizing.AWEKAPerformanceDecisionTreeBasedFeatureGenerator;
import java.util.HashMap;
import java.util.Map;
import org.api4.java.algorithm.exceptions.AlgorithmException;
import org.api4.java.common.math.IVector;
import weka.core.Instances;

public class RandomTreePerformanceBasedFeatureGenerator
extends AWEKAPerformanceDecisionTreeBasedFeatureGenerator {
    private AccessibleRandomTree randomTree = new AccessibleRandomTree();
    private Map<AccessibleRandomTree.AccessibleTree, Integer> nodesIndices = new HashMap<AccessibleRandomTree.AccessibleTree, Integer>();
    private AccessibleRandomTree.AccessibleTree tree;
    private boolean allowUnsetValues = false;
    private double incomingUnsetValueValue = Double.NaN;
    private double outgoingUnsetValueValue = 0.0;
    private double occurenceValue = 1.0;
    private double nonOccurenceValue = -1.0;

    @Override
    public void train(Instances data) throws AlgorithmException {
        try {
            this.randomTree.buildClassifier(data);
        }
        catch (Exception e) {
            throw new AlgorithmException("Random Tree could not be trained!", (Throwable)e);
        }
        this.addIndexToMap(0, this.randomTree.getMTree());
        this.tree = this.randomTree.getMTree();
    }

    private int addIndexToMap(int subTreeIndex, AccessibleRandomTree.AccessibleTree subTree) {
        this.nodesIndices.put(subTree, subTreeIndex);
        ++subTreeIndex;
        int numberOfSuccessors = 0;
        if (subTree.getSuccessors() != null) {
            for (int i = 0; i < subTree.getSuccessors().length; ++i) {
                numberOfSuccessors += this.addIndexToMap(subTreeIndex += numberOfSuccessors, subTree.getSuccessors()[i]) + 1;
            }
        }
        return numberOfSuccessors;
    }

    @Override
    public IVector predict(IVector intermediatePipelineRepresentation) {
        DenseDoubleVector pipelineRepresentation = new DenseDoubleVector(this.nodesIndices.size(), this.nonOccurenceValue);
        AccessibleRandomTree.AccessibleTree subTree = this.tree;
        while (subTree != null) {
            if (subTree.getAttribute() == -1) {
                pipelineRepresentation.setValue(this.nodesIndices.get(subTree).intValue(), this.occurenceValue);
                subTree = null;
                continue;
            }
            if (this.allowUnsetValues && !this.isValueUnset(intermediatePipelineRepresentation.getValue(subTree.getAttribute())) || !this.allowUnsetValues) {
                pipelineRepresentation.setValue(this.nodesIndices.get(subTree).intValue(), this.occurenceValue);
                if (intermediatePipelineRepresentation.getValue(subTree.getAttribute()) < subTree.getSplitPoint()) {
                    subTree = subTree.getSuccessors()[0];
                    continue;
                }
                subTree = subTree.getSuccessors()[1];
                continue;
            }
            this.setSubTreeToValue(subTree, this.outgoingUnsetValueValue, (IVector)pipelineRepresentation);
            subTree = null;
        }
        return pipelineRepresentation;
    }

    private boolean isValueUnset(double value) {
        if (Double.isNaN(this.incomingUnsetValueValue)) {
            return Double.isNaN(value);
        }
        return value == this.incomingUnsetValueValue;
    }

    private void setSubTreeToValue(AccessibleRandomTree.AccessibleTree subTree, double value, IVector featureRepresentation) {
        featureRepresentation.setValue(this.nodesIndices.get(subTree).intValue(), value);
        if (subTree.getSuccessors() != null) {
            for (int i = 0; i < subTree.getSuccessors().length; ++i) {
                this.setSubTreeToValue(subTree.getSuccessors()[i], value, featureRepresentation);
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        try {
            builder.append(this.randomTree);
        }
        catch (Exception e) {
            builder.append("Can not print tree");
        }
        builder.append(System.lineSeparator());
        builder.append(this.nodesIndices);
        builder.append(System.lineSeparator());
        return builder.toString();
    }

    public double getIncomingUnsetValueValue() {
        return this.incomingUnsetValueValue;
    }

    public void setAllowNonOccurence(double unsetValueValue) {
        this.allowUnsetValues = true;
        this.incomingUnsetValueValue = unsetValueValue;
    }

    public void disallowNonOccurence() {
        this.allowUnsetValues = false;
    }

    public double getOutgoingUnsetValueValue() {
        return this.outgoingUnsetValueValue;
    }

    public void setOutgoingUnsetValueValue(double outgoingUnsetValueValue) {
        this.outgoingUnsetValueValue = outgoingUnsetValueValue;
    }

    public double getOccurenceValue() {
        return this.occurenceValue;
    }

    public void setOccurenceValue(double occurenceValue) {
        this.occurenceValue = occurenceValue;
    }

    public double getNonOccurenceValue() {
        return this.nonOccurenceValue;
    }

    public void setNonOccurenceValue(double nonOccurenceValue) {
        this.nonOccurenceValue = nonOccurenceValue;
    }
}

