/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.metamining.pipelinecharacterizing;

import ai.libs.mlplan.metamining.pipelinecharacterizing.IOntologyConnector;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.ClassExpressionType;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class WEKAOntologyConnector
implements IOntologyConnector {
    private static final String ONTOLOGY_FILE_NAME = "DMOP_modified.owl";
    private static final String ONTOLOGY_IRI = "http://www.e-lico.eu/ontologies/dmo/DMOP/DMOP.owl";
    private static final String ONTOLOGY_IRI_SEPARATOR = "#";
    private static final List<String> classifierPortfolio = Arrays.asList("weka.classifiers.bayes.BayesNet", "weka.classifiers.bayes.NaiveBayes", "weka.classifiers.bayes.NaiveBayesMultinomial", "weka.classifiers.functions.Logistic", "weka.classifiers.functions.MultilayerPerceptron", "weka.classifiers.functions.SGD", "weka.classifiers.functions.SimpleLogistic", "weka.classifiers.functions.SMO", "weka.classifiers.functions.VotedPerceptron", "weka.classifiers.lazy.IBk", "weka.classifiers.lazy.KStar", "weka.classifiers.rules.DecisionTable", "weka.classifiers.rules.JRip", "weka.classifiers.rules.OneR", "weka.classifiers.rules.PART", "weka.classifiers.rules.ZeroR", "weka.classifiers.trees.DecisionStump", "weka.classifiers.trees.J48", "weka.classifiers.trees.LMT", "weka.classifiers.trees.RandomForest", "weka.classifiers.trees.RandomTree", "weka.classifiers.trees.REPTree", "weka.classifiers.meta.Vote", "weka.classifiers.meta.Stacking", "weka.classifiers.meta.RandomSubSpace", "weka.classifiers.meta.RandomCommittee", "weka.classifiers.meta.MultiClassClassifier", "weka.classifiers.meta.LogitBoost", "weka.classifiers.meta.ClassificationViaRegression", "weka.classifiers.meta.Bagging", "weka.classifiers.meta.AdditiveRegression", "weka.classifiers.meta.AdaBoostM1", "weka.classifiers.trees.M5P", "weka.classifiers.rules.M5Rules", "weka.classifiers.functions.SimpleLinearRegression");
    private static final List<String> evaluatorPortfolio = Arrays.asList("weka.attributeSelection.CfsSubsetEval", "weka.attributeSelection.CorrelationAttributeEval", "weka.attributeSelection.GainRatioAttributeEval", "weka.attributeSelection.InfoGainAttributeEval", "weka.attributeSelection.OneRAttributeEval", "weka.attributeSelection.PrincipalComponents", "weka.attributeSelection.ReliefFAttributeEval", "weka.attributeSelection.SymmetricalUncertAttributeEval");
    private static final List<String> searcherPortfolio = Arrays.asList("weka.attributeSelection.BestFirst", "weka.attributeSelection.GreedyStepwise", "weka.attributeSelection.Ranker");
    private static final List<String> kernelFunctionPortfolio = Arrays.asList("weka.classifiers.functions.supportVector.Puk", "weka.classifiers.functions.supportVector.RBFKernel", "weka.classifiers.functions.supportVector.PolyKernel", "weka.classifiers.functions.supportVector.NormalizedPolyKernel");
    private static final String CLASSIFIER_TOP_NODE = "ModelingAlgorithm";
    private static final String SEARCHER_TOP_NODE = "DataProcessingAlgorithm";
    private static final String EVALUTATOR_TOP_NODE = "DataProcessingAlgorithm";
    private static final String KERNEL_FUNCTION_TOP_NODE = "KernelFunction";
    private OWLDataFactory dataFactory;
    private OWLOntology ontology;
    private boolean includeEqualSuperClasses = true;

    public WEKAOntologyConnector() throws OWLOntologyCreationException {
        OWLOntologyManager ontologyManager = OWLManager.createOWLOntologyManager();
        this.dataFactory = ontologyManager.getOWLDataFactory();
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(ONTOLOGY_FILE_NAME);
        this.ontology = ontologyManager.loadOntologyFromOntologyDocument(inputStream);
    }

    @Override
    public List<String> getAncestorsOfAlgorithm(String algorithmName) {
        if (classifierPortfolio.contains(algorithmName)) {
            return this.getAncestorsOfAlgorithmUntil(algorithmName, CLASSIFIER_TOP_NODE);
        }
        if (searcherPortfolio.contains(algorithmName)) {
            return this.getAncestorsOfAlgorithmUntil(algorithmName, "DataProcessingAlgorithm");
        }
        if (evaluatorPortfolio.contains(algorithmName)) {
            return this.getAncestorsOfAlgorithmUntil(algorithmName, "DataProcessingAlgorithm");
        }
        if (kernelFunctionPortfolio.contains(algorithmName)) {
            return this.getAncestorsOfAlgorithmUntil(algorithmName, KERNEL_FUNCTION_TOP_NODE);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(algorithmName);
        builder.append(" is not supported by the used ontology.");
        throw new IllegalArgumentException(builder.toString());
    }

    protected List<String> getAncestorsOfAlgorithmUntil(String algorithm, String until) {
        OWLNamedIndividual algorithmAsIndividual = this.dataFactory.getOWLNamedIndividual(this.getAsOntologyElement(algorithm));
        ArrayList ancestors = new ArrayList();
        this.ontology.classAssertionAxioms((OWLIndividual)algorithmAsIndividual).findFirst().ifPresent(algorithmClass -> ancestors.add(algorithmClass.getClassExpression().asOWLClass()));
        for (int i = 0; i < ancestors.size() && !((OWLClass)ancestors.get(ancestors.size() - 1)).getIRI().getShortForm().equals(until); ++i) {
            int previousAncestorSize = ancestors.size();
            this.ontology.subClassAxiomsForSubClass((OWLClass)ancestors.get(i)).filter(axiom -> axiom.getSuperClass().getClassExpressionType() == ClassExpressionType.OWL_CLASS).forEach(axiom -> {
                OWLClass toAdd = axiom.getSuperClass().asOWLClass();
                ancestors.add(toAdd);
            });
            if (!this.includeEqualSuperClasses || ancestors.size() != previousAncestorSize) continue;
            this.ontology.equivalentClassesAxioms((OWLClass)ancestors.get(i)).forEach(axiom -> axiom.classExpressions().forEach(elem -> {
                if (!ancestors.contains(((OWLClassExpression)elem.conjunctSet().findFirst().get()).asOWLClass())) {
                    ancestors.add(((OWLClassExpression)elem.conjunctSet().findFirst().get()).asOWLClass());
                }
            }));
        }
        ArrayList<String> ancestorNames = new ArrayList<String>();
        for (int i = ancestors.size() - 1; i >= 0; --i) {
            String ancestorName = ((OWLClass)ancestors.get(i)).getIRI().getShortForm();
            if (!ancestorName.equals(until)) continue;
            ancestorNames.add(ancestorName);
        }
        ancestorNames.add(algorithmAsIndividual.getIRI().getShortForm());
        return ancestorNames;
    }

    private String getAsOntologyElement(String name) {
        StringBuilder builder = new StringBuilder();
        builder.append(ONTOLOGY_IRI);
        builder.append(ONTOLOGY_IRI_SEPARATOR);
        builder.append(name);
        return builder.toString();
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }

    public List<String> getAvailableClassifiers() {
        return classifierPortfolio;
    }

    public List<String> getAvailableSearchers() {
        return searcherPortfolio;
    }

    public List<String> getAvailableEvaluators() {
        return evaluatorPortfolio;
    }

    public List<String> getAvailableKernelFunctions() {
        return kernelFunctionPortfolio;
    }

    public String getClassifierTopNode() {
        return CLASSIFIER_TOP_NODE;
    }

    public String getSearcherTopNode() {
        return "DataProcessingAlgorithm";
    }

    public String getEvaluatorTopNode() {
        return "DataProcessingAlgorithm";
    }

    public String getKernelFunctionTopNode() {
        return KERNEL_FUNCTION_TOP_NODE;
    }
}

