/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.metamining.dyadranking;

import ai.libs.hasco.core.HASCOUtil;
import ai.libs.jaicore.components.api.IComponent;
import ai.libs.jaicore.components.api.IComponentInstance;
import ai.libs.jaicore.components.model.ComponentInstance;
import ai.libs.jaicore.logic.fol.structure.Monom;
import ai.libs.jaicore.math.linearalgebra.DenseDoubleVector;
import ai.libs.jaicore.ml.ranking.dyad.learner.algorithm.IDyadRanker;
import ai.libs.jaicore.ml.ranking.dyad.learner.search.ADyadRankedNodeQueue;
import ai.libs.jaicore.ml.ranking.dyad.learner.util.AbstractDyadScaler;
import ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.tfd.TFDNode;
import ai.libs.mlplan.metamining.pipelinecharacterizing.IPipelineCharacterizer;
import java.util.ArrayList;
import java.util.Collection;
import org.api4.java.ai.graphsearch.problem.pathsearch.pathevaluation.IEvaluatedPath;
import org.api4.java.common.math.IVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WEKADyadRankedNodeQueue
extends ADyadRankedNodeQueue<TFDNode, Double> {
    private Logger logger = LoggerFactory.getLogger(WEKADyadRankedNodeQueue.class);
    private Collection<IComponent> components;
    private IPipelineCharacterizer characterizer;

    public WEKADyadRankedNodeQueue(IVector contextCharacterization, Collection<? extends IComponent> components, IDyadRanker ranker, AbstractDyadScaler scaler, IPipelineCharacterizer characterizer) {
        super(contextCharacterization, ranker, scaler);
        this.components = new ArrayList<IComponent>(components);
        this.characterizer = characterizer;
    }

    protected IVector characterize(IEvaluatedPath<TFDNode, ?, Double> path) {
        ComponentInstance cI = HASCOUtil.getComponentInstanceFromState(this.components, (Monom)((TFDNode)path.getHead()).getState(), (String)"solution", (boolean)true);
        if (cI != null) {
            this.logger.debug("Characterizing new node.");
            return new DenseDoubleVector(this.characterizer.characterize((IComponentInstance)cI));
        }
        this.logger.debug("CI from node for characterization is null.");
        return new DenseDoubleVector(this.characterizer.getLengthOfCharacterization(), 0.0);
    }
}

