/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.mlplan.metamining.dyadranking;

import ai.libs.jaicore.components.api.IComponent;
import ai.libs.jaicore.math.linearalgebra.DenseDoubleVector;
import ai.libs.jaicore.ml.ranking.dyad.learner.search.ADyadRankedNodeQueueConfig;
import ai.libs.jaicore.planning.hierarchical.algorithms.forwarddecomposition.graphgenerators.tfd.TFDNode;
import ai.libs.jaicore.search.algorithms.standard.bestfirst.BestFirst;
import ai.libs.mlplan.metamining.dyadranking.WEKADyadRankedNodeQueue;
import ai.libs.mlplan.metamining.pipelinecharacterizing.ComponentInstanceVectorFeatureGenerator;
import ai.libs.mlplan.metamining.pipelinecharacterizing.IPipelineCharacterizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import org.api4.java.common.math.IVector;
import org.openml.webapplication.fantail.dc.Characterizer;
import org.openml.webapplication.fantail.dc.DatasetCharacterizerInitializationFailedException;
import org.openml.webapplication.fantail.dc.LandmarkerCharacterizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.core.Instances;

public class WEKADyadRankedNodeQueueConfig
extends ADyadRankedNodeQueueConfig<TFDNode> {
    private Logger logger = LoggerFactory.getLogger(WEKADyadRankedNodeQueueConfig.class);
    private Characterizer datasetCharacterizer = new LandmarkerCharacterizer();
    private IPipelineCharacterizer pipelineCharacterizer;
    private double[] contextCharacterization;
    private Collection<IComponent> components;

    public void configureBestFirst(BestFirst bestFirst) {
        this.logger.trace("Configuring OPEN list of BF");
        bestFirst.setOpen((Queue)((Object)new WEKADyadRankedNodeQueue((IVector)new DenseDoubleVector(this.contextCharacterization), this.components, this.ranker, this.scaler, this.pipelineCharacterizer)));
    }

    public void setData(Instances data) throws Exception {
        this.logger.trace("Setting data to instances of size {}", (Object)data.size());
        this.contextCharacterization = this.datasetCharacterizer.characterizeAll(data).entrySet().stream().mapToDouble(Map.Entry::getValue).toArray();
    }

    public void setComponents(Collection<? extends IComponent> components) {
        this.components = new ArrayList<IComponent>(components);
        if (this.pipelineCharacterizer == null) {
            this.pipelineCharacterizer = new ComponentInstanceVectorFeatureGenerator(components);
        }
    }

    public void setDatasetCharacterizer(Characterizer datasetCharacterizer) {
        this.datasetCharacterizer = datasetCharacterizer;
    }

    public void setPipelineCharacterizer(IPipelineCharacterizer pipelineCharacterizer) {
        this.pipelineCharacterizer = pipelineCharacterizer;
    }
}

